<?php
/**
 * Profilfelder zur Users-Tabelle hinzufügen
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "<h1>Profildatenfelder hinzufügen</h1>";
    
    // Prüfe welche Spalten schon existieren
    $stmt = $conn->query("SHOW COLUMNS FROM users");
    $existingColumns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h2>Existierende Spalten:</h2>";
    echo "<ul>";
    foreach ($existingColumns as $column) {
        echo "<li>$column</li>";
    }
    echo "</ul>";
    
    // Felder die hinzugefügt werden sollen
    $fieldsToAdd = [
        'phone_number' => "ALTER TABLE users ADD COLUMN phone_number VARCHAR(50) DEFAULT NULL",
        'address' => "ALTER TABLE users ADD COLUMN address VARCHAR(255) DEFAULT NULL",
        'postal_code' => "ALTER TABLE users ADD COLUMN postal_code VARCHAR(10) DEFAULT NULL",
        'city' => "ALTER TABLE users ADD COLUMN city VARCHAR(100) DEFAULT NULL",
        'profile_image' => "ALTER TABLE users ADD COLUMN profile_image VARCHAR(255) DEFAULT NULL",
        'updated_at' => "ALTER TABLE users ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"
    ];
    
    echo "<h2>Hinzufügen von Spalten:</h2>";
    echo "<ul>";
    
    foreach ($fieldsToAdd as $fieldName => $sql) {
        if (!in_array($fieldName, $existingColumns)) {
            try {
                $conn->exec($sql);
                echo "<li style='color: green;'>✅ $fieldName hinzugefügt</li>";
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'Duplicate column') !== false) {
                    echo "<li style='color: orange;'>⚠️ $fieldName existiert bereits</li>";
                } else {
                    echo "<li style='color: red;'>❌ Fehler bei $fieldName: " . $e->getMessage() . "</li>";
                }
            }
        } else {
            echo "<li style='color: blue;'>ℹ️ $fieldName existiert bereits</li>";
        }
    }
    
    echo "</ul>";
    
    // Prüfe ob Verzeichnis für Profile Images existiert
    $uploadDir = 'uploads/profile_images/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
        echo "<p style='color: green;'>✅ Verzeichnis $uploadDir erstellt</p>";
    } else {
        echo "<p style='color: blue;'>ℹ️ Verzeichnis $uploadDir existiert bereits</p>";
    }
    
    echo "<h2 style='color: green;'>✅ Fertig!</h2>";
    echo "<p>Alle Profilfelder wurden erfolgreich hinzugefügt.</p>";
    
} catch (Exception $e) {
    echo "<h1 style='color: red;'>FEHLER</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

