<?php
/**
 * Fahrzeug aktualisieren
 */
session_start();
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Prüfe ob User eingeloggt ist
    if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
        throw new Exception('Nicht angemeldet');
    }
    
    $user_id = $_SESSION['user_id'];
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || empty($input['vehicle_id'])) {
        throw new Exception('Fahrzeug-ID erforderlich');
    }
    
    $vehicle_id = $input['vehicle_id'];
    
    // Prüfe ob Fahrzeug dem User gehört
    $stmt = $pdo->prepare("SELECT id FROM user_vehicles WHERE id = ? AND user_id = ? AND is_active = 1");
    $stmt->execute([$vehicle_id, $user_id]);
    if (!$stmt->fetch()) {
        throw new Exception('Fahrzeug nicht gefunden');
    }
    
    // Prüfe ob neues Kennzeichen bereits existiert (wenn geändert)
    if (!empty($input['license_plate'])) {
        $stmt = $pdo->prepare("SELECT id FROM user_vehicles WHERE user_id = ? AND license_plate = ? AND id != ? AND is_active = 1");
        $stmt->execute([$user_id, $input['license_plate'], $vehicle_id]);
        if ($stmt->fetch()) {
            throw new Exception('Dieses Kennzeichen existiert bereits');
        }
    }
    
    // Wenn als Standard gesetzt, alle anderen auf nicht-Standard setzen
    if (!empty($input['is_default'])) {
        $stmt = $pdo->prepare("UPDATE user_vehicles SET is_default = 0 WHERE user_id = ?");
        $stmt->execute([$user_id]);
    }
    
    // Fahrzeug aktualisieren
    $sql = "UPDATE user_vehicles SET 
            license_plate = ?,
            vehicle_brand = ?,
            vehicle_model = ?,
            vehicle_year = ?,
            is_default = ?,
            notes = ?,
            updated_at = NOW()
            WHERE id = ? AND user_id = ?";
    
    $stmt = $pdo->prepare($sql);
    $result = $stmt->execute([
        $input['license_plate'] ?? '',
        $input['vehicle_brand'] ?? null,
        $input['vehicle_model'] ?? null,
        $input['vehicle_year'] ?? null,
        !empty($input['is_default']) ? 1 : 0,
        $input['vehicle_notes'] ?? null,
        $vehicle_id,
        $user_id
    ]);
    
    if ($result) {
        // Aktualisierte Fahrzeugdaten zurückgeben
        $stmt = $pdo->prepare("SELECT * FROM user_vehicles WHERE id = ?");
        $stmt->execute([$vehicle_id]);
        $vehicle = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'vehicle' => $vehicle,
            'message' => 'Fahrzeug erfolgreich aktualisiert'
        ]);
    } else {
        throw new Exception('Fehler beim Aktualisieren des Fahrzeugs');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

