<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

try {
    error_log("TEST TIRE API: Starting");
    
    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) {
        $input = $_POST;
    }
    
    $storageNumber = $input['storage_number'] ?? '';
    
    error_log("TEST TIRE API: Storage number: " . $storageNumber);
    
    if (empty($storageNumber)) {
        throw new Exception('Einlagerungsnummer ist erforderlich');
    }
    
    // Lade die API-Klasse
    require_once 'check_tire_status.php';
    
    error_log("TEST TIRE API: Class loaded");
    
    // Erstelle API-Instanz
    $api = new ResyTireStatusAPI();
    
    error_log("TEST TIRE API: Instance created");
    
    // Teste die API
    $result = $api->checkTireStatus($storageNumber, '', '');
    
    error_log("TEST TIRE API: Result obtained: " . ($result['success'] ? 'success' : 'fail'));
    
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
    
    error_log("TEST TIRE API: JSON sent");
    
} catch (Exception $e) {
    error_log("TEST TIRE API ERROR: " . $e->getMessage());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>
