<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['autohaus_id']) || !isset($input['brand_model'])) {
        throw new Exception('Autohaus ID und Marke/Modell sind erforderlich');
    }
    
    $autohaus_id = intval($input['autohaus_id']);
    $brand_model = trim($input['brand_model']);
    $eu_label = isset($input['eu_label']) ? trim($input['eu_label']) : null;
    $size_pattern = isset($input['size_pattern']) ? trim($input['size_pattern']) : null;
    
    // Check if suggestion already exists
    $stmt = $conn->prepare("
        SELECT id, usage_count 
        FROM tire_suggestions 
        WHERE autohaus_id = ? AND brand_model = ?
    ");
    
    $stmt->execute([$autohaus_id, $brand_model]);
    $existing = $stmt->fetch();
    
    if ($existing) {
        // Update existing suggestion
        $stmt = $conn->prepare("
            UPDATE tire_suggestions 
            SET usage_count = usage_count + 1,
                last_used = CURRENT_TIMESTAMP,
                eu_label = COALESCE(?, eu_label),
                size_pattern = COALESCE(?, size_pattern)
            WHERE id = ?
        ");
        
        $stmt->execute([$eu_label, $size_pattern, $existing['id']]);
        
        $message = "Reifenvorschlag aktualisiert";
    } else {
        // Insert new suggestion
        $stmt = $conn->prepare("
            INSERT INTO tire_suggestions (autohaus_id, brand_model, eu_label, size_pattern, usage_count) 
            VALUES (?, ?, ?, ?, 1)
        ");
        
        $stmt->execute([$autohaus_id, $brand_model, $eu_label, $size_pattern]);
        
        $message = "Neuer Reifenvorschlag gespeichert";
    }
    
    echo json_encode([
        'success' => true,
        'message' => $message
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
