<?php
// Vereinfachte Image Proxy mit vollständigen Cookies
// Diese Version lädt Bilder direkt ohne Detailseite-Logik

// Debug-Logging-Funktion
function debugLog($message) {
    $logFile = __DIR__ . '/../logs/resy_image_proxy.log';
    $timestamp = date('Y-m-d H:i:s');
    $logDir = dirname($logFile);
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND | LOCK_EX);
}

// EXAKT GLEICHE Cookie-Validierung wie in resy_data_extraction_breakthrough.php
function validateAndUpdateCookiesImageProxy($baseUrl, $currentCookies, $username, $password) {
    debugLog("=== IMAGE PROXY COOKIE-VALIDIERUNG START ===");
    
    // Teste die aktuellen Cookies
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_COOKIE, implode('; ', $currentCookies));
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    // Teste mit einer einfachen RESY-Seite (exakt wie in der funktionierenden API)
    $testUrl = $baseUrl . '/resyweb/index.php';
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    debugLog("Cookie-Test: HTTP $httpCode, Length: " . strlen($response));
    
    // Prüfe ob die Cookies gültig sind (exakt wie in der funktionierenden API)
    $hasLoginForm = strpos($response, 'Anmeldename') !== false || 
                    strpos($response, 'UserName') !== false;
    $hasResyContent = strpos($response, 'RESY') !== false ||
                     strpos($response, 'resyweb') !== false;
    
    if (!$hasLoginForm && $hasResyContent) {
        debugLog("✅ Aktuelle Cookies sind gültig");
        return ['valid' => true, 'cookies' => $currentCookies, 'method' => 'current_cookies'];
    }
    
    debugLog("⚠️ Cookies ungültig - starte automatische Cookie-Verwaltung");
    
    // HYBRID-ANSATZ: Automatische Cookie-Verwaltung (exakt wie in der funktionierenden API)
    $cookieResult = performAutomaticCookieManagementImageProxy($baseUrl, $username, $password);
    
    debugLog("=== IMAGE PROXY COOKIE-VALIDIERUNG END ===");
    
    return $cookieResult;
}

// EXAKT GLEICHE automatische Cookie-Verwaltung wie in resy_data_extraction_breakthrough.php
function performAutomaticCookieManagementImageProxy($baseUrl, $username, $password) {
    debugLog("=== AUTOMATISCHE COOKIE-VERWALTUNG IMAGE PROXY START ===");
    
    // Schritt 1: Versuche automatisches Login (exakt wie in der funktionierenden API)
    try {
        debugLog("🔄 Schritt 1: Automatisches Login...");
        
        $loginResponse = performBreakthroughLoginImageProxy($baseUrl, $username, $password);
        debugLog("✅ Automatisches Login erfolgreich");
        
        // Extrahiere neue Cookies aus der Cookie-Datei
        $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
        if (file_exists($cookieFile)) {
            $newCookies = extractCookiesFromFileImageProxy($cookieFile);
            if (!empty($newCookies)) {
                debugLog("✅ Neue Cookies nach automatischem Login extrahiert: " . count($newCookies) . " Cookies");
                return ['valid' => true, 'cookies' => $newCookies, 'method' => 'automatic_login'];
            }
        }
    } catch (Exception $e) {
        debugLog("❌ Automatisches Login fehlgeschlagen: " . $e->getMessage());
    }
    
    // Schritt 2: Fallback auf aktualisierte Hardcoded-Cookies (exakt wie in der funktionierenden API)
    debugLog("🔄 Schritt 2: Fallback auf aktualisierte Cookies...");
    
    $updatedCookies = [
        "PHPSESSID=tujfce9g5sesps0hdod1o3dqio",
        "HideWheelsetSearchResultBEZEICHNUNG=0",
        "HideWheelsetSearchResultKDNR=0",
        "HideWheelsetSearchResultORT=0",
        "HideWheelsetSearchResultSTRASSE1=0",
        "SortWheelsetSearchResultCol=6",
        "SortWheelsetSearchResultDesc=-1"
    ];
    
    // Teste die aktualisierten Cookies
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_COOKIE, implode('; ', $updatedCookies));
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $testUrl = $baseUrl . '/resyweb/index.php';
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $hasLoginForm = strpos($response, 'Anmeldename') !== false || 
                    strpos($response, 'UserName') !== false;
    $hasResyContent = strpos($response, 'RESY') !== false ||
                     strpos($response, 'resyweb') !== false;
    
    if (!$hasLoginForm && $hasResyContent) {
        debugLog("✅ Aktualisierte Cookies sind gültig");
        return ['valid' => true, 'cookies' => $updatedCookies, 'method' => 'updated_cookies'];
    }
    
    // Schritt 3: Letzter Fallback - verwende aktualisierte Cookies trotzdem
    debugLog("⚠️ Schritt 3: Letzter Fallback - verwende aktualisierte Cookies");
    return ['valid' => false, 'cookies' => $updatedCookies, 'method' => 'fallback_cookies'];
}

// EXAKT GLEICHER Login wie in resy_data_extraction_breakthrough.php
function performBreakthroughLoginImageProxy($baseUrl, $username, $password) {
    debugLog("=== BREAKTHROUGH LOGIN IMAGE PROXY START ===");
    debugLog("Base URL: $baseUrl");
    debugLog("Username: $username");
    
    $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
    
    // Lösche alte Cookie-Datei für frische Session
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
        debugLog("Alte Cookie-Datei gelöscht für frische Session");
    }
    
    $loginUrl = "$baseUrl/index.php?m=login&a=login";
    debugLog("Lade Login-Seite: $loginUrl");
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception("Login-Seite nicht erreichbar: HTTP $httpCode");
    }
    
    debugLog("Login-Seite erfolgreich geladen");
    
    $postData = [
        'FN' => 'login',
        'UserName' => $username,
        'Password' => $password,
        'button' => 'submit'
    ];
    
    $loginDataString = http_build_query($postData);
    debugLog("Login-Daten: " . str_replace($password, '***', $loginDataString));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $loginDataString);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1'
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    debugLog("Login-Response Code: $loginHttpCode");
    
    // Dekodiere gzip falls nötig
    if (substr($loginResponse, 0, 2) === "\x1f\x8b") {
        $loginResponse = gzdecode($loginResponse);
    }
    
    // Prüfe ob Login erfolgreich war (exakt wie in der funktionierenden API)
    $hasLoginForm = strpos($loginResponse, 'Anmeldename') !== false || 
                    strpos($loginResponse, 'UserName') !== false;
    $hasResyContent = strpos($loginResponse, 'RESY') !== false ||
                     strpos($loginResponse, 'resyweb') !== false;
    
    if (!$hasLoginForm && $hasResyContent) {
        debugLog("✅ Login erfolgreich! (RESY-Content gefunden)");
        debugLog("💾 Session-Cookies gespeichert in: $cookieFile");
        debugLog("=== BREAKTHROUGH LOGIN IMAGE PROXY END ===");
        return $loginResponse;
    }
    
    throw new Exception("Login fehlgeschlagen - RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . ", Login-Seite: " . ($hasLoginForm ? 'Ja' : 'Nein'));
}

// Hilfsfunktion: Extrahiere Cookies aus Cookie-Datei (exakt wie in der funktionierenden API)
function extractCookiesFromFileImageProxy($cookieFile) {
    if (!file_exists($cookieFile)) {
        return [];
    }
    
    $cookieContent = file_get_contents($cookieFile);
    $cookieLines = explode("\n", $cookieContent);
    $cookies = [];
    
    foreach ($cookieLines as $line) {
        $line = trim($line);
        if (empty($line) || strpos($line, '#') === 0) {
            continue;
        }
        
        if (strpos($line, "\t") !== false) {
            $parts = explode("\t", $line);
            if (count($parts) >= 7) {
                $cookies[] = $parts[5] . '=' . $parts[6];
            }
        }
    }
    
    return $cookies;
}

// Setze Content-Type für JSON-Responses
header('Content-Type: application/json');

try {
    // Validiere Eingabeparameter
    $lgfotoId = $_GET['lgfoto_id'] ?? null;
    $appointmentId = $_GET['appointment_id'] ?? null;
    
    if (!$lgfotoId) {
        throw new Exception('LGFOTO_ID ist erforderlich');
    }
    
    debugLog("Image Proxy Request - LGFOTO_ID: $lgfotoId, Appointment ID: " . ($appointmentId ?? 'null'));
    
    // Hole Autohaus-Daten
    require_once __DIR__ . '/../config/database.php';
    
    $stmt = $conn->prepare("SELECT resy_base_url, resy_username, resy_password FROM autohaus WHERE id = 1 LIMIT 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus) {
        throw new Exception('Autohaus-Daten nicht gefunden');
    }
    
    debugLog("Autohaus gefunden: " . $autohaus['resy_base_url']);
    
    // EXAKT GLEICHER HYBRID-ANSATZ wie in resy_data_extraction_breakthrough.php
    debugLog("=== IMAGE PROXY HYBRID-ANSATZ START ===");
    
    // Verwende die EXAKT GLEICHEN Cookies wie die funktionierende API mit NEUER Session-ID
    $realCookies = [
        "PHPSESSID=tujfce9g5sesps0hdod1o3dqio",
        "HideWheelsetSearchResultBEZEICHNUNG=0",
        "HideWheelsetSearchResultKDNR=0",
        "HideWheelsetSearchResultORT=0",
        "HideWheelsetSearchResultSTRASSE1=0",
        "SortWheelsetSearchResultCol=6",
        "SortWheelsetSearchResultDesc=-1"
    ];
    
    // Cookie-Validierung und -Verwaltung (exakt wie in der funktionierenden API)
    $cookieValidationResult = validateAndUpdateCookiesImageProxy($autohaus['resy_base_url'], $realCookies, $autohaus['resy_username'], $autohaus['resy_password']);
    
    $realCookies = $cookieValidationResult['cookies'];
    $cookieString = implode("; ", $realCookies);
    
    debugLog("Image Proxy Cookies validiert (Methode: " . ($cookieValidationResult['method'] ?? 'unknown') . ")");
    
    // Mögliche Bild-URLs
    $possibleUrls = [
        rtrim($autohaus['resy_base_url'], '/') . '/resyweb/index.php?m=wheelphoto&a=show&LGFOTO_ID=' . $lgfotoId . '&FN=ShowPruefDoc',
        rtrim($autohaus['resy_base_url'], '/') . '/resyweb/index.php?FN=ShowPruefDoc&a=show&m=wheelphoto&LGFOTO_ID=' . $lgfotoId,
        rtrim($autohaus['resy_base_url'], '/') . '/index.php?m=wheelphoto&a=show&LGFOTO_ID=' . $lgfotoId . '&FN=ShowPruefDoc',
        rtrim($autohaus['resy_base_url'], '/') . '/wheelphoto/show/' . $lgfotoId,
        rtrim($autohaus['resy_base_url'], '/') . '/images/wheelphoto/' . $lgfotoId . '.jpg',
        rtrim($autohaus['resy_base_url'], '/') . '/uploads/wheelphoto/' . $lgfotoId . '.jpg'
    ];
    
    debugLog("Mögliche Bild-URLs: " . implode(', ', $possibleUrls));
    
    // Teste verschiedene URLs bis eine funktioniert
    $imageData = null;
    $contentType = null;
    $workingUrl = null;
    
    // EXAKT GLEICHE Cookie-Datei wie die funktionierende API verwenden
    $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
    debugLog("Verwende Cookie-Datei: $cookieFile");
    
    foreach ($possibleUrls as $imageUrl) {
        debugLog("Teste URL: $imageUrl");
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $imageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);  // Verwende Cookie-Datei statt Cookie-String
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);   // Speichere neue Cookies
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept: image/webp,image/apng,image/*,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
            'Accept-Encoding: gzip, deflate, br, zstd',
            'Referer: ' . rtrim($autohaus['resy_base_url'], '/') . '/resyweb/index.php?m=wheelset&a=search'
        ]);
        
        $testData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $testContentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
        curl_close($ch);
        
        debugLog("URL $imageUrl - Response Code: $httpCode, Content-Type: $testContentType");
        
        // Dekodiere gzip falls nötig
        if (substr($testData, 0, 2) === "\x1f\x8b") {
            $testData = gzdecode($testData);
            debugLog("Gzip-komprimierte Bild-Antwort dekodiert");
        }
        
        // Prüfe ob es ein Bild ist
        if ($httpCode === 200 && 
            !empty($testData) && 
            strpos($testContentType, 'image/') === 0 &&
            strpos($testData, '<html') === false &&
            strpos($testData, '<!DOCTYPE') === false) {
            
            $imageData = $testData;
            $contentType = $testContentType;
            $workingUrl = $imageUrl;
            debugLog("✅ Bild erfolgreich geladen von: $imageUrl");
            break;
        } else {
            debugLog("❌ HTML-Response erhalten (wahrscheinlich Login-Seite) für URL: $imageUrl");
            debugLog("HTML-Inhalt (erste 200 Zeichen): " . substr($testData, 0, 200));
            
            // Prüfe ob es eine Login-Seite ist
            if (strpos($testData, 'login') !== false || 
                strpos($testData, 'anmelden') !== false ||
                strpos($testData, 'Login') !== false ||
                strpos($testData, 'Anmeldename') !== false) {
                debugLog("❌ Login-Seite erkannt - Session abgelaufen");
                throw new Exception("RESY-Session abgelaufen. Bitte führen Sie die Datenauslese erneut durch.");
            }
        } else {
            debugLog("⚠️ Unerwartete Response für URL: $imageUrl - Code: $httpCode, Content-Type: $testContentType");
        }
    }
    
    if (!$imageData) {
        debugLog("❌ Keine funktionierende Bild-URL gefunden");
        throw new Exception("Bild konnte nicht geladen werden. Alle URL-Varianten fehlgeschlagen.");
    }
    
    // Setze korrekten Content-Type
    if ($contentType) {
        header('Content-Type: ' . $contentType);
    }
    
    // Setze Content-Length
    header('Content-Length: ' . strlen($imageData));
    
    // Output das Bild
    echo $imageData;
    
    debugLog("✅ Bild erfolgreich geladen von: $workingUrl");
    
} catch (Exception $e) {
    debugLog("❌ Fehler: " . $e->getMessage());
    
    // Generiere SVG-Fehlerbild
    $errorSvg = '<?xml version="1.0" encoding="UTF-8"?>
<svg width="200" height="150" xmlns="http://www.w3.org/2000/svg">
  <rect width="200" height="150" fill="#f8f9fa" stroke="#dee2e6" stroke-width="2"/>
  <text x="100" y="70" text-anchor="middle" font-family="Arial, sans-serif" font-size="14" fill="#6c757d">
    Bild nicht verfügbar
  </text>
  <text x="100" y="90" text-anchor="middle" font-family="Arial, sans-serif" font-size="10" fill="#6c757d">
    ' . htmlspecialchars($e->getMessage()) . '
  </text>
</svg>';
    
    header('Content-Type: image/svg+xml');
    header('Content-Length: ' . strlen($errorSvg));
    echo $errorSvg;
}
?>
