<?php
/**
 * Kurze Kundenübersicht mit Aktivitäten für Admin Dashboard
 */

session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Admin-Check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $user_id = intval($_GET['user_id'] ?? 0);
    
    if ($user_id <= 0) {
        throw new Exception('Ungültige Benutzer-ID');
    }
    
    // Benutzer-Daten laden
    $stmt = $conn->prepare("
        SELECT 
            id, first_name, last_name, email, phone_number, 
            verification_status, created_at, profile_image,
            registration_source
        FROM users 
        WHERE id = ?
    ");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        throw new Exception('Benutzer nicht gefunden');
    }
    
    // Fahrzeuge laden
    $stmt = $conn->prepare("
        SELECT * FROM user_vehicles 
        WHERE user_id = ? AND is_active = 1 
        ORDER BY is_default DESC, created_at DESC
    ");
    $stmt->execute([$user_id]);
    $vehicles = $stmt->fetchAll();
    
    // Termine laden
    $stmt = $conn->prepare("
        SELECT 
            a.*,
            e.name as event_name,
            e.event_date,
            COALESCE(e.event_time, e.start_time) as event_time,
            ah.name as autohaus_name
        FROM appointments a
        LEFT JOIN events e ON a.event_id = e.id
        LEFT JOIN autohaus ah ON e.autohaus_id = ah.id
        WHERE a.user_id = ? AND a.is_active = 1
        ORDER BY e.event_date DESC, COALESCE(e.event_time, e.start_time) DESC
        LIMIT 10
    ");
    $stmt->execute([$user_id]);
    $appointments = $stmt->fetchAll();
    
    // Activity Log laden
    $stmt = $conn->prepare("
        SELECT * FROM user_activity_log 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT 20
    ");
    $stmt->execute([$user_id]);
    $activities = $stmt->fetchAll();
    
    // Statistiken
    $stats = [
        'total_appointments' => count($appointments),
        'total_vehicles' => count($vehicles),
        'total_activities' => count($activities),
        'verification_status' => $user['verification_status']
    ];
    
    echo json_encode([
        'success' => true,
        'user' => $user,
        'vehicles' => $vehicles,
        'appointments' => $appointments,
        'activities' => $activities,
        'stats' => $stats
    ]);
    
} catch (\Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

