<?php
/**
 * Check Email Logs
 * Zeigt die letzten E-Mail-Versuche an
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Error Log lesen
$logFile = 'C:/xampp/apache/logs/error.log';

if (!file_exists($logFile)) {
    echo "Log-Datei nicht gefunden: $logFile\n";
    exit;
}

$content = file_get_contents($logFile);
$lines = explode("\n", $content);

// Suche nach E-Mail-Logs
$emailLogs = [];
foreach ($lines as $line) {
    if (strpos($line, 'FREISCHALTUNGS-E-MAIL') !== false || 
        strpos($line, 'ABLEHNUNGS-E-MAIL') !== false ||
        strpos($line, 'SMTP Debug:') !== false) {
        $emailLogs[] = $line;
    }
}

// Zeige die letzten 50 E-Mail-Logs
echo "<h1>E-Mail Logs</h1>";
echo "<pre style='background: #f5f5f5; padding: 1rem; border: 1px solid #ddd; overflow-x: auto;'>";

if (empty($emailLogs)) {
    echo "Keine E-Mail-Logs gefunden.\n\n";
    echo "Mögliche Gründe:\n";
    echo "1. Es wurden noch keine E-Mails versendet\n";
    echo "2. Error-Log wird nicht geschrieben\n";
    echo "3. Log-Datei ist an anderem Ort\n\n";
    echo "Bitte versuchen Sie:\n";
    echo "1. Einen User freischalten oder ablehnen\n";
    echo "2. Prüfen Sie die Log-Datei: " . $logFile . "\n";
} else {
    echo "Letzte " . min(50, count($emailLogs)) . " E-Mail-Logs:\n\n";
    $lastLogs = array_slice($emailLogs, -50);
    foreach ($lastLogs as $log) {
        echo htmlspecialchars($log) . "\n";
    }
}

echo "</pre>";

// Zeige auch PHPMailer-Logs falls vorhanden
$phpmailerLog = __DIR__ . '/phpmailer_errors.log';
if (file_exists($phpmailerLog)) {
    echo "<h2>PHPMailer Logs</h2>";
    echo "<pre style='background: #f5f5f5; padding: 1rem; border: 1px solid #ddd; overflow-x: auto;'>";
    echo htmlspecialchars(file_get_contents($phpmailerLog));
    echo "</pre>";
}

// Prüfe ob PHPMailer verfügbar ist
echo "<h2>PHPMailer Status</h2>";
if (class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
    echo "<p style='color: green;'>✅ PHPMailer ist verfügbar</p>";
} else {
    echo "<p style='color: red;'>❌ PHPMailer ist NICHT verfügbar</p>";
    
    // Prüfe ob Dateien existieren
    $files = ['phpmailer/PHPMailer.php', 'phpmailer/SMTP.php', 'phpmailer/Exception.php'];
    echo "<ul>";
    foreach ($files as $file) {
        $path = __DIR__ . '/' . $file;
        if (file_exists($path)) {
            echo "<li style='color: green;'>✅ $file</li>";
        } else {
            echo "<li style='color: red;'>❌ $file (nicht gefunden)</li>";
        }
    }
    echo "</ul>";
}

// Prüfe SMTP-Daten
require_once __DIR__ . '/config.php';

$stmt = $pdo->prepare("SELECT email_smtp_host, email_smtp_port, email_smtp_username, email_smtp_encryption, email_from_name, name FROM autohaus WHERE is_active = 1 ORDER BY id LIMIT 1");
$stmt->execute();
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h2>SMTP-Konfiguration (erstes Autohaus)</h2>";
if ($autohaus) {
    echo "<ul>";
    echo "<li>Name: " . htmlspecialchars($autohaus['name']) . "</li>";
    echo "<li>Host: " . htmlspecialchars($autohaus['email_smtp_host'] ?: 'NICHT GESETZT') . "</li>";
    echo "<li>Port: " . htmlspecialchars($autohaus['email_smtp_port'] ?: 'NICHT GESETZT') . "</li>";
    echo "<li>Username: " . htmlspecialchars($autohaus['email_smtp_username'] ?: 'NICHT GESETZT') . "</li>";
    echo "<li>Password: " . ($autohaus['email_smtp_password'] ? '✅ GESETZT' : '❌ NICHT GESETZT') . "</li>";
    echo "<li>Encryption: " . htmlspecialchars($autohaus['email_smtp_encryption'] ?: 'NICHT GESETZT') . "</li>";
    echo "<li>From Name: " . htmlspecialchars($autohaus['email_from_name'] ?: 'NICHT GESETZT') . "</li>";
    echo "</ul>";
} else {
    echo "<p style='color: red;'>Kein Autohaus mit SMTP-Daten gefunden</p>";
}
?>

