<?php
/**
 * Apple Sign-In Callback Handler
 * Wird von Apple aufgerufen nach erfolgreicher Sign-In
 */

session_start();
require_once __DIR__ . '/../config/database.php';

header('Content-Type: text/html; charset=utf-8');

// Parse the callback
$code = $_GET['code'] ?? null;
$state = $_GET['state'] ?? null;
$error = $_GET['error'] ?? null;

if ($error) {
    // Apple Sign-In Fehler
    echo "<script>
        window.opener.postMessage({
            type: 'apple-signin-error',
            error: '" . addslashes($error) . "'
        }, '*');
        
        setTimeout(() => {
            window.close();
        }, 2000);
    </script>";
    exit;
}

if (!$code) {
    echo "<script>
        alert('Kein Authorization Code erhalten');
        window.close();
    </script>";
    exit;
}

// Im echten System müssten Sie hier:
// 1. Den Authorization Code gegen Tokens bei Apple austauschen
// 2. Die ID Token validieren
// 3. User-Daten extrahieren

// Für jetzt: Schließen Sie das Popup und senden Sie eine Nachricht
echo "<script>
    console.log('Apple Callback received:', {
        code: '" . addslashes($code) . "',
        state: '" . addslashes($state) . "'
    });
    
    // Schließe das Popup nach kurzer Verzögerung
    setTimeout(() => {
        window.close();
    }, 1000);
</script>";

?>

