<?php
// Simple API key gate for boxenstop/api. Usage: require __DIR__ . '/_require_api_key.php';

$headers = [];
if (function_exists('getallheaders')) {
    $headers = getallheaders();
}

$key = null;
if (isset($headers['Authorization'])) {
    $key = trim(str_replace('Bearer', '', $headers['Authorization']));
} elseif (isset($_GET['api_key'])) {
    $key = $_GET['api_key'];
} elseif (isset($_POST['api_key'])) {
    $key = $_POST['api_key'];
}

$keysFile = __DIR__ . '/.api_keys';
$allowed = [];
if (is_readable($keysFile)) {
    $allowed = array_filter(array_map('trim', file($keysFile)));
}

if (!$key || !in_array($key, $allowed, true)) {
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized', 'message' => 'Missing or invalid API key']);
    exit;
}

return;
