<?php
// Analysiere die gespeicherte HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

echo "<h1>HTML-Struktur Analyse</h1>";

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Suche nach Tabellen
    if (preg_match_all('/<table[^>]*>(.*?)<\/table>/s', $html, $tables)) {
        echo "<h2>Gefundene Tabellen: " . count($tables[1]) . "</h2>";
        
        foreach ($tables[1] as $index => $table) {
            echo "<h3>Tabelle " . ($index + 1) . "</h3>";
            echo "<p>Länge: " . strlen($table) . " Zeichen</p>";
            
            // Suche nach tbody
            if (preg_match_all('/<tbody[^>]*>(.*?)<\/tbody>/s', $table, $tbodies)) {
                echo "<p>Gefundene tbody: " . count($tbodies[1]) . "</p>";
                
                foreach ($tbodies[1] as $tbodyIndex => $tbody) {
                    echo "<h4>tbody " . ($tbodyIndex + 1) . "</h4>";
                    echo "<p>Länge: " . strlen($tbody) . " Zeichen</p>";
                    
                    if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $tbody, $rows)) {
                        echo "<p>Gefundene Zeilen: " . count($rows[1]) . "</p>";
                        
                        foreach ($rows[1] as $rowIndex => $row) {
                            echo "<h5>Zeile " . $rowIndex . "</h5>";
                            echo "<p>Länge: " . strlen($row) . " Zeichen</p>";
                            
                            // Teste verschiedene Zellen-Patterns
                            $cellPatterns = [
                                '/<td[^>]*>(.*?)<\/td>/s',
                                '/<th[^>]*>(.*?)<\/th>/s',
                                '/<td[^>]*class="[^"]*"[^>]*>(.*?)<\/td>/s'
                            ];
                            
                            $cells = [];
                            foreach ($cellPatterns as $patternIndex => $pattern) {
                                if (preg_match_all($pattern, $row, $cellMatches)) {
                                    $cells = $cellMatches[1];
                                    echo "<p>Zellen gefunden mit Pattern " . ($patternIndex + 1) . ": " . count($cells) . "</p>";
                                    break;
                                }
                            }
                            
                            if (empty($cells)) {
                                echo "<p style='color: red;'>Keine Zellen gefunden</p>";
                                echo "<p>Row HTML (erste 200 Zeichen):</p>";
                                echo "<pre>" . htmlspecialchars(substr($row, 0, 200)) . "</pre>";
                            } else {
                                echo "<p>Zellen-Inhalte:</p>";
                                echo "<ul>";
                                foreach ($cells as $cellIndex => $cell) {
                                    $cleanCell = trim(strip_tags($cell));
                                    echo "<li>Zelle $cellIndex: '" . htmlspecialchars($cleanCell) . "'</li>";
                                }
                                echo "</ul>";
                            }
                            
                            if ($rowIndex >= 2) break; // Nur erste 3 Zeilen
                        }
                    }
                }
            } else {
                echo "<p>Keine tbody gefunden</p>";
                
                // Direkte Zeilen-Suche
                if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $table, $rows)) {
                    echo "<p>Gefundene Zeilen (direkt): " . count($rows[1]) . "</p>";
                    
                    foreach ($rows[1] as $rowIndex => $row) {
                        echo "<h5>Zeile " . $rowIndex . "</h5>";
                        
                        if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $row, $cells)) {
                            $cells = $cells[1];
                            echo "<p>Zellen: " . count($cells) . "</p>";
                            
                            echo "<ul>";
                            foreach ($cells as $cellIndex => $cell) {
                                $cleanCell = trim(strip_tags($cell));
                                echo "<li>Zelle $cellIndex: '" . htmlspecialchars($cleanCell) . "'</li>";
                            }
                            echo "</ul>";
                        }
                        
                        if ($rowIndex >= 2) break; // Nur erste 3 Zeilen
                    }
                }
            }
        }
    } else {
        echo "<p style='color: red;'>Keine Tabellen gefunden</p>";
    }
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
