<?php
// Analysiere alle Tabellen in der HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

echo "<h1>Vollständige Tabellen-Analyse</h1>";

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Suche nach allen Tabellen
    $patterns = [
        '/<tbody[^>]*>(.*?)<\/tbody>/s',
        '/<table[^>]*>(.*?)<\/table>/s'
    ];
    
    $totalWheelsets = 0;
    
    foreach ($patterns as $patternIndex => $pattern) {
        echo "<h2>Pattern " . ($patternIndex + 1) . ": " . $pattern . "</h2>";
        
        if (preg_match_all($pattern, $html, $matches)) {
            echo "<p>✅ Gefunden: " . count($matches[1]) . " Tabellen</p>";
            
            foreach ($matches[1] as $tableIndex => $tableHtml) {
                echo "<h3>Tabelle " . ($tableIndex + 1) . " (Länge: " . strlen($tableHtml) . " Zeichen)</h3>";
                
                // Suche nach Zeilen
                if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $tableHtml, $rows)) {
                    echo "<p>Gefundene Zeilen: " . count($rows[1]) . "</p>";
                    
                    $tableWheelsets = 0;
                    
                    foreach ($rows[1] as $rowIndex => $row) {
                        // Suche nach Zellen
                        if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $row, $cells)) {
                            $cells = $cells[1];
                            
                            if (count($cells) >= 19) {
                                $satznummer = trim(strip_tags($cells[2] ?? ''));
                                
                                // Überspringe leere oder Header-Zeilen
                                if (!empty($satznummer) && 
                                    $satznummer !== 'Satznummer' && 
                                    $satznummer !== 'Satznummer:' &&
                                    strpos($satznummer, 'Anz=') === false) {
                                    
                                    $tableWheelsets++;
                                    $totalWheelsets++;
                                    
                                    if ($tableWheelsets <= 5) { // Zeige nur erste 5
                                        echo "<p>Reifensatz $tableWheelsets: " . htmlspecialchars($satznummer) . "</p>";
                                    }
                                }
                            }
                        }
                    }
                    
                    echo "<p><strong>Reifensätze in dieser Tabelle: $tableWheelsets</strong></p>";
                }
            }
        } else {
            echo "<p>❌ Keine Tabellen gefunden</p>";
        }
    }
    
    echo "<h2>Gesamtergebnis:</h2>";
    echo "<p><strong>Gesamte Reifensätze gefunden: $totalWheelsets</strong></p>";
    echo "<p>Erwartet: 266</p>";
    echo "<p>Fehlend: " . (266 - $totalWheelsets) . "</p>";
    
    // Suche nach Paginierung oder "Weitere Ergebnisse"
    echo "<h2>Suche nach Paginierung:</h2>";
    
    if (preg_match('/Seite \d+ von \d+/', $html, $pageMatches)) {
        echo "<p>✅ Paginierung gefunden: " . htmlspecialchars($pageMatches[0]) . "</p>";
    } else {
        echo "<p>❌ Keine Paginierung gefunden</p>";
    }
    
    if (preg_match('/Weitere Ergebnisse/', $html)) {
        echo "<p>✅ 'Weitere Ergebnisse' gefunden</p>";
    } else {
        echo "<p>❌ 'Weitere Ergebnisse' nicht gefunden</p>";
    }
    
    if (preg_match('/Nächste Seite/', $html)) {
        echo "<p>✅ 'Nächste Seite' gefunden</p>";
    } else {
        echo "<p>❌ 'Nächste Seite' nicht gefunden</p>";
    }
    
    // Suche nach LGS_ID-Einträgen
    if (preg_match_all('/LGS_ID[^>]*>([^<]+)</', $html, $lgsMatches)) {
        echo "<p>LGS_ID-Einträge gefunden: " . count($lgsMatches[1]) . "</p>";
        
        // Zähle echte Satznummern
        $realLgsCount = 0;
        foreach ($lgsMatches[1] as $value) {
            $value = trim(strip_tags($value));
            if (preg_match('/^[0-9]+\.[0-9]+\.[0-9]+$/', $value)) {
                $realLgsCount++;
            }
        }
        echo "<p>Echte Satznummern in LGS_ID: $realLgsCount</p>";
    }
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
