<?php foreach ($users as $user): ?>
    <div class="user-card" data-user-id="<?php echo $user['id']; ?>">
        <div class="user-card-header">
            <div class="user-checkbox-container">
                <input type="checkbox" class="user-checkbox" value="<?php echo $user['id']; ?>" onchange="updateBulkActions()">
            </div>
            <div class="user-avatar">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-status">
                <span class="status-badge status-<?php echo $user['status']; ?>">
                    <?php 
                    $status_labels = [
                        'pending' => 'Ausstehend',
                        'approved' => 'Freigeschaltet', 
                        'rejected' => 'Abgelehnt',
                        'suspended' => 'Gesperrt'
                    ]; 
                    echo $status_labels[$user['status']] ?? $user['status']; 
                    ?>
                </span>
            </div>
        </div>
        
        <div class="user-card-body">
            <div class="user-name">
                <?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?>
            </div>
            <div class="user-id">ID: <?php echo $user['id']; ?></div>
            
            <div class="user-details">
                <div class="detail-item">
                    <i class="fas fa-envelope"></i>
                    <span><?php echo htmlspecialchars($user['email']); ?></span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-phone"></i>
                    <span><?php echo htmlspecialchars($user['phone_number']); ?></span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-car"></i>
                    <span><?php echo htmlspecialchars($user['license_plate']); ?></span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-building"></i>
                    <span><?php echo htmlspecialchars($user['dealership_name'] ?? 'Nicht gewählt'); ?></span>
                </div>
            </div>
            
            <div class="user-meta">
                <div class="meta-item">
                    <i class="fas fa-file"></i>
                    <span><?php echo $user['document_count']; ?> Dokumente</span>
                </div>
                <div class="meta-item">
                    <i class="fas fa-calendar"></i>
                    <span><?php echo date('d.m.Y', strtotime($user['created_at'])); ?></span>
                </div>
            </div>
        </div>
        
        <div class="user-card-actions">
            <button class="action-btn btn-info" onclick="viewUserDetails(<?php echo $user['id']; ?>)" title="Details anzeigen">
                <i class="fas fa-eye"></i>
            </button>
            <?php if ($user['status'] === 'pending' || $user['status'] === 'rejected'): ?>
                <button class="action-btn btn-success" onclick="approveUser(<?php echo $user['id']; ?>)" title="Freischalten">
                    <i class="fas fa-check"></i>
                </button>
                <button class="action-btn btn-danger" onclick="rejectUser(<?php echo $user['id']; ?>)" title="Ablehnen">
                    <i class="fas fa-times"></i>
                </button>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>
