<?php
/**
 * Test der Dokumenten-Viewer API
 */

session_start();

// Simuliere Admin-Login für Test
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

echo "<h2>Test der Dokumenten-Viewer API</h2>";

// Teste verschiedene Dateipfade
$test_paths = [
    'C:\\xampp\\htdocs\\boxenstop\\uploads\\verification_documents\\test_document.txt',
    'uploads/verification_documents/test_document.txt',
    '/uploads/verification_documents/test_document.txt'
];

foreach ($test_paths as $path) {
    echo "<h3>Teste Pfad: " . htmlspecialchars($path) . "</h3>";
    
    if (file_exists($path)) {
        echo "<p>✅ Datei existiert</p>";
        echo "<p>MIME-Type: " . mime_content_type($path) . "</p>";
        echo "<p>Größe: " . filesize($path) . " Bytes</p>";
        
        // Teste realpath
        $real_path = realpath($path);
        if ($real_path) {
            echo "<p>Realpath: " . htmlspecialchars($real_path) . "</p>";
        } else {
            echo "<p>❌ Realpath fehlgeschlagen</p>";
        }
    } else {
        echo "<p>❌ Datei existiert nicht</p>";
    }
    
    echo "<hr>";
}

// Teste API direkt
echo "<h3>API-Test</h3>";

// Teste mit absolutem Pfad
$absolute_url = 'api/view_document.php?file=' . urlencode('C:\\xampp\\htdocs\\boxenstop\\uploads\\verification_documents\\test_document.txt');
echo "<p>Absoluter Pfad: <a href='$absolute_url' target='_blank'>$absolute_url</a></p>";

// Teste mit relativem Pfad
$relative_url = 'api/view_document.php?file=' . urlencode('uploads/verification_documents/test_document.txt');
echo "<p>Relativer Pfad: <a href='$relative_url' target='_blank'>$relative_url</a></p>";

// Teste Dokumenten-API
echo "<h3>Dokumenten-API Test</h3>";
$documents_url = 'api/get_user_documents.php?user_id=10';
echo "<p>Dokumenten-API: <a href='$documents_url' target='_blank'>$documents_url</a></p>";

// Teste die API direkt
echo "<h3>API Response Test</h3>";
try {
    $response = file_get_contents($documents_url);
    $data = json_decode($response, true);
    
    if ($data && $data['success']) {
        echo "<p>✅ Dokumenten-API funktioniert</p>";
        echo "<p>Anzahl Dokumente: " . $data['count'] . "</p>";
        
        if (!empty($data['documents'])) {
            echo "<h4>Dokumente:</h4>";
            foreach ($data['documents'] as $doc) {
                echo "<div style='border: 1px solid #ccc; margin: 10px 0; padding: 10px;'>";
                echo "<p><strong>Datei:</strong> " . htmlspecialchars($doc['file_name']) . "</p>";
                echo "<p><strong>Pfad:</strong> " . htmlspecialchars($doc['file_path']) . "</p>";
                echo "<p><strong>MIME-Type:</strong> " . htmlspecialchars($doc['mime_type']) . "</p>";
                echo "<p><strong>Status:</strong> " . htmlspecialchars($doc['review_status']) . "</p>";
                
                // Teste Viewer-URL
                $viewer_url = 'api/view_document.php?file=' . urlencode($doc['file_path']);
                echo "<p><strong>Viewer-URL:</strong> <a href='$viewer_url' target='_blank'>$viewer_url</a></p>";
                echo "</div>";
            }
        }
    } else {
        echo "<p>❌ Dokumenten-API Fehler</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    }
} catch (Exception $e) {
    echo "<p>❌ Fehler beim Testen der API: " . $e->getMessage() . "</p>";
}
?>
