<?php
/**
 * Einheitliche Sidebar-Komponente für alle Admin-Seiten
 * Basierend auf der Performance-Dashboard Sidebar
 */

// Aktuelle Seite ermitteln
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_user_name = $current_user_name ?? 'Administrator';
?>

<!-- 🧭 Smart Sidebar -->
<aside class="smart-sidebar" id="smartSidebar">
    <!-- Sidebar Header -->
    <div class="sidebar-header">
        <div class="logo-section">
            <div class="logo-icon">
                <i class="fas fa-rocket"></i>
            </div>
            <div class="logo-text">
                <h1>Boxenstop</h1>
                <span>Admin Panel</span>
            </div>
        </div>
        
        <!-- 🎛️ Theme Toggle -->
        <form method="POST" style="display: inline;">
            <button type="submit" name="toggle_theme" class="theme-toggle" title="Theme wechseln">
                <i class="fas fa-<?php echo $current_theme === 'light' ? 'moon' : 'sun'; ?>"></i>
            </button>
        </form>
    </div>

    <!-- Smart Navigation -->
    <nav class="smart-nav">
        <!-- Dashboard -->
        <div class="nav-section">
            <a href="index.php" class="nav-item primary-item <?php echo $current_page === 'index' ? 'active' : ''; ?>">
                <div class="nav-item-icon">
                    <i class="fas fa-tachometer-alt"></i>
                </div>
                <span class="nav-item-text">Dashboard</span>
                <div class="nav-item-indicator"></div>
            </a>
        </div>

        <!-- Terminplanung -->
        <div class="nav-section professional-group">
            <div class="nav-group-trigger" data-target="terminplanung">
                <div class="nav-group-label">
                    <span class="nav-group-text">Terminplanung</span>
                    <span class="nav-group-badge">2</span>
                </div>
                <div class="nav-group-toggle">
                    <i class="fas fa-chevron-down"></i>
                </div>
            </div>
            <div class="nav-group-menu" id="terminplanung">
                <a href="events.php" class="nav-item secondary-item <?php echo $current_page === 'events' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Events</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="appointments.php" class="nav-item secondary-item <?php echo $current_page === 'appointments' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Termine</span>
                    <div class="nav-item-status"></div>
                </a>
            </div>
        </div>

        <!-- Lagerverwaltung -->
        <div class="nav-section professional-group">
            <div class="nav-group-trigger" data-target="lagerverwaltung">
                <div class="nav-group-label">
                    <span class="nav-group-text">Lagerverwaltung</span>
                    <span class="nav-group-badge">1</span>
                </div>
                <div class="nav-group-toggle">
                    <i class="fas fa-chevron-down"></i>
                </div>
            </div>
            <div class="nav-group-menu" id="lagerverwaltung">
                <a href="storage.php" class="nav-item secondary-item <?php echo $current_page === 'storage' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Einlagerungen</span>
                    <div class="nav-item-status"></div>
                </a>
            </div>
        </div>

        <!-- Einstellungen -->
        <div class="nav-section professional-group">
            <div class="nav-group-trigger" data-target="einstellungen">
                <div class="nav-group-label">
                    <span class="nav-group-text">Einstellungen</span>
                    <span class="nav-group-badge">4</span>
                </div>
                <div class="nav-group-toggle">
                    <i class="fas fa-chevron-down"></i>
                </div>
            </div>
            <div class="nav-group-menu" id="einstellungen">
                <a href="profile.php" class="nav-item secondary-item <?php echo $current_page === 'profile' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Mein Profil</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="settings.php" class="nav-item secondary-item <?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                    <span class="nav-item-text">System-Einstellungen</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="users.php" class="nav-item secondary-item <?php echo $current_page === 'users' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Benutzer</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="quick_actions_manager.php" class="nav-item secondary-item <?php echo $current_page === 'quick_actions_manager' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Schnellaktionen</span>
                    <div class="nav-item-status"></div>
                </a>
            </div>
        </div>

        <!-- Performance Tools (nur für Admins) -->
        <?php if ($current_user_role === 'admin'): ?>
        <div class="nav-section professional-group dev-section">
            <div class="nav-group-trigger" data-target="performance-tools">
                <div class="nav-group-label">
                    <span class="nav-group-text">Development</span>
                    <span class="nav-group-badge dev-badge">3</span>
                </div>
                <div class="nav-group-toggle">
                    <i class="fas fa-chevron-down"></i>
                </div>
            </div>
            <div class="nav-group-menu" id="performance-tools">
                <a href="performance.php" class="nav-item secondary-item <?php echo $current_page === 'performance' ? 'active' : ''; ?>">
                    <span class="nav-item-text">Performance</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="professional_admin_test.php" class="nav-item secondary-item <?php echo $current_page === 'professional_admin_test' ? 'active' : ''; ?>">
                    <span class="nav-item-text">System Tests</span>
                    <div class="nav-item-status"></div>
                </a>
                <a href="apply_database_indexes.php" class="nav-item secondary-item <?php echo $current_page === 'apply_database_indexes' ? 'active' : ''; ?>">
                    <span class="nav-item-text">DB Optimierung</span>
                    <div class="nav-item-status"></div>
                </a>
            </div>
        </div>
        <?php endif; ?>
    </nav>

    <!-- Sidebar Footer -->
    <div class="sidebar-footer">
        <!-- User Menu -->
        <div class="user-menu-container">
            <button class="user-menu-btn" id="user-menu-btn">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-info">
                    <span class="user-name"><?php echo htmlspecialchars($current_user_name); ?></span>
                    <span class="user-role">Administrator</span>
                </div>
                <i class="fas fa-chevron-down user-chevron"></i>
            </button>
            
            <div class="user-dropdown" id="user-dropdown">
                <a href="profile.php" class="user-dropdown-item">
                    <i class="fas fa-user"></i>
                    <span>Mein Profil</span>
                </a>
                <a href="settings.php" class="user-dropdown-item">
                    <i class="fas fa-cog"></i>
                    <span>Einstellungen</span>
                </a>
                <a href="users.php" class="user-dropdown-item">
                    <i class="fas fa-users"></i>
                    <span>Benutzer</span>
                </a>
                <div class="user-dropdown-divider"></div>
                <a href="logout.php" class="user-dropdown-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Abmelden</span>
                </a>
            </div>
        </div>
    </div>
</aside>
