// Universal Theme Toggle Function
function initializeThemeToggle() {
    const themeToggleBtn = document.getElementById('theme-toggle-btn');
    const themeIcon = document.getElementById('theme-icon');
    const themeText = document.getElementById('theme-text');
    
    if (themeToggleBtn && themeIcon && themeText) {
        // Initialize theme on page load
        const savedTheme = localStorage.getItem('admin-theme') || document.body.getAttribute('data-theme') || 'light';
        document.body.setAttribute('data-theme', savedTheme);
        
        // Update icon and text based on current theme
        updateThemeToggle(savedTheme);
        
        // Add click event listener
        themeToggleBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const currentTheme = document.body.getAttribute('data-theme') || 'light';
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            // Update theme
            document.body.setAttribute('data-theme', newTheme);
            updateThemeToggle(newTheme);
            
            // Save to localStorage
            localStorage.setItem('admin-theme', newTheme);
            
            // Update form select if it exists
            const themeSelect = document.getElementById('admin_theme');
            if (themeSelect) {
                themeSelect.value = newTheme;
            }
            
            console.log('Theme changed to:', newTheme);
        });
    }
    
    function updateThemeToggle(theme) {
        const themeIcon = document.getElementById('theme-icon');
        const themeText = document.getElementById('theme-text');
        
        if (themeIcon && themeText) {
            if (theme === 'dark') {
                themeIcon.className = 'fas fa-sun';
                themeText.textContent = 'Hell';
            } else {
                themeIcon.className = 'fas fa-moon';
                themeText.textContent = 'Dunkel';
            }
        }
    }
}

// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', initializeThemeToggle);
