# 🚀 Quick Actions Manager - Professional Edition

## Übersicht

Der **Quick Actions Manager** ist ein professionelles System zur Verwaltung von Schnellzugriffen im Boxenstop Admin-Panel. Mit Apple-Volvo Design und erweiterten Sharing-Funktionen ermöglicht es Benutzern, ihre Dashboard-Aktionen zu erstellen, zu gestalten und zu teilen.

## ✨ Features

### 🎨 Design & UX
- **Apple-Volvo Design System**: Authentische Apple-Ästhetik mit Volvo-Branding
- **Dark/Light Mode**: Automatischer Theme-Switch mit Benutzerpräferenzen
- **Responsive Design**: Optimiert für Desktop, Tablet und Mobile
- **Smooth Animations**: Cubic-bezier Übergänge und Hover-Effekte
- **Glassmorphism**: Moderne Transparenz-Effekte

### 🔧 Funktionalitäten
- **CRUD Operations**: Erstellen, Bearbeiten, Löschen von Schnellaktionen
- **Drag & Drop**: Sortierung per Drag & Drop mit SortableJS
- **Visual Customization**: 
  - 40+ Icons (Font Awesome)
  - 24 Premium Farben (Apple System Colors + Volvo Brand)
  - Beschreibungen und Ziel-Fenster-Einstellungen
- **Sharing System**: 
  - Generierung von Teilungslinks
  - Import von geteilten Aktionen
  - Öffentliche Share-Seiten
- **Multi-Autohaus Support**: Autohaus-spezifische Aktionen

### 🔒 Sicherheit
- **User Authentication**: Session-basierte Authentifizierung
- **Ownership Verification**: Benutzer können nur eigene Aktionen bearbeiten
- **Secure Tokens**: Kryptographisch sichere Share-Tokens
- **SQL Injection Protection**: Prepared Statements

## 📁 Dateistruktur

```
admin/
├── quick_actions_manager.php          # Hauptverwaltungsinterface
├── share_action.php                   # Öffentliche Share-Seite
├── update_quick_actions_schema.php    # Datenbank-Update-Script
├── api/
│   └── share_action.php               # API für Sharing-Funktionen
└── QUICK_ACTIONS_PROFESSIONAL_README.md
```

## 🗃️ Datenbank-Schema

```sql
CREATE TABLE quick_actions (
    id INT PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(100) NOT NULL,
    description VARCHAR(255) DEFAULT '',
    icon VARCHAR(50) NOT NULL DEFAULT 'fas fa-star',
    url VARCHAR(500) NOT NULL,
    target VARCHAR(10) DEFAULT '_self',
    background_color VARCHAR(7) DEFAULT '#007AFF',
    text_color VARCHAR(7) DEFAULT '#ffffff',
    position_order INT DEFAULT 0,
    is_active TINYINT DEFAULT 1,
    user_id INT,
    autohaus_id INT,
    share_token VARCHAR(32) DEFAULT NULL,
    is_public TINYINT DEFAULT 0,
    created_by VARCHAR(100) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_active_order (is_active, position_order),
    INDEX idx_user_autohaus (user_id, autohaus_id),
    INDEX idx_share_token (share_token),
    INDEX idx_is_public (is_public),
    
    FOREIGN KEY (user_id) REFERENCES admin_users(id) ON DELETE SET NULL,
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE SET NULL
);
```

## 🚀 Installation

### 1. Datenbank-Update
```bash
php admin/update_quick_actions_schema.php
```

### 2. Berechtigungen
Stelle sicher, dass der Webserver Schreibrechte auf die `admin/api/` Verzeichnisse hat.

### 3. Konfiguration
Das System verwendet die bestehende `database_optimized.php` Konfiguration.

## 📖 Benutzerhandbuch

### Schnellaktion erstellen
1. Klicke auf **"Neue Aktion"**
2. Fülle die Felder aus:
   - **Titel**: Name der Aktion
   - **Beschreibung**: Optionale Beschreibung
   - **URL**: Ziel-URL
   - **Ziel**: Gleiches oder neues Fenster
   - **Icon**: Wähle aus 40+ Icons
   - **Farbe**: Wähle aus 24 Premium-Farben
3. Klicke **"Erstellen"**

### Aktion bearbeiten
1. Klicke auf **"Bearbeiten"** bei einer Aktion
2. Ändere die gewünschten Felder
3. Klicke **"Speichern"**

### Aktion teilen
1. Klicke auf **"Teilen"** bei einer eigenen Aktion
2. Kopiere den generierten Link
3. Teile den Link mit anderen Benutzern

### Geteilte Aktion importieren
1. Klicke auf **"Importieren"**
2. Füge den Teilungslink ein
3. Klicke **"Importieren"**

### Sortierung
- Ziehe Aktionen per Drag & Drop an die gewünschte Position
- Die Sortierung wird automatisch gespeichert

## 🎨 Design-System

### Farben
```css
/* Apple System Colors */
--system-blue: #007AFF;
--system-green: #34C759;
--system-indigo: #5856D6;
--system-orange: #FF9500;
--system-pink: #FF2D92;
--system-purple: #AF52DE;
--system-red: #FF3B30;
--system-teal: #30B0C7;
--system-yellow: #FFCC00;

/* Volvo Brand Colors */
--volvo-blue: #005AAA;
--volvo-navy: #1A365D;
--volvo-silver: #C1C8CE;
--volvo-gold: #FFD700;
```

### Typografie
- **Font**: SF Pro Display (Apple System Font)
- **Fallback**: -apple-system, BlinkMacSystemFont, system-ui, sans-serif

### Spacing
- **xs**: 4px
- **sm**: 8px
- **md**: 16px
- **lg**: 24px
- **xl**: 32px
- **xxl**: 48px

## 🔧 API-Endpunkte

### POST /admin/api/share_action.php
Generiert einen Share-Token für eine Aktion.

**Request:**
```json
{
  "action_id": "123"
}
```

**Response:**
```json
{
  "success": true,
  "share_token": "abc123...",
  "share_url": "https://example.com/admin/share_action.php?token=abc123..."
}
```

### GET /admin/api/share_action.php?token=abc123
Ruft eine geteilte Aktion ab.

**Response:**
```json
{
  "success": true,
  "action": {
    "id": "123",
    "title": "Neuer Termin",
    "description": "Termin erstellen",
    "url": "https://example.com/appointments",
    "icon": "fas fa-calendar",
    "background_color": "#007AFF",
    "text_color": "#ffffff",
    "target": "_self"
  }
}
```

## 🛠️ Entwicklung

### Technologien
- **Backend**: PHP 7.4+, PDO, MySQL
- **Frontend**: HTML5, CSS3, JavaScript ES6+
- **Libraries**: SortableJS, Font Awesome 6.5
- **Design**: Apple Human Interface Guidelines

### Browser-Unterstützung
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

### Performance
- **Lazy Loading**: Icons und Assets werden optimiert geladen
- **Caching**: Datenbankabfragen werden gecacht
- **Compression**: CSS und JS werden minifiziert

## 🔒 Sicherheitshinweise

1. **Share-Tokens**: Werden automatisch generiert und sind kryptographisch sicher
2. **User Isolation**: Benutzer können nur eigene Aktionen bearbeiten
3. **Input Validation**: Alle Eingaben werden validiert und escaped
4. **SQL Injection**: Verwendung von Prepared Statements
5. **XSS Protection**: HTML-Escape für alle Ausgaben

## 📝 Changelog

### Version 2.0.0 (Professional Edition)
- ✅ Apple-Volvo Design System implementiert
- ✅ Sharing-System hinzugefügt
- ✅ Erweiterte CRUD-Operationen
- ✅ Drag & Drop Sortierung
- ✅ Dark/Light Mode Support
- ✅ Responsive Design
- ✅ API-Endpunkte für Sharing
- ✅ Öffentliche Share-Seiten
- ✅ Multi-Autohaus Support

### Version 1.0.0 (Basic Edition)
- ✅ Grundlegende CRUD-Funktionen
- ✅ Icon- und Farbauswahl
- ✅ Benutzer-spezifische Aktionen

## 🤝 Support

Bei Fragen oder Problemen:
1. Überprüfe die Browser-Konsole auf Fehler
2. Stelle sicher, dass alle Berechtigungen korrekt sind
3. Überprüfe die Datenbankverbindung
4. Kontaktiere den Systemadministrator

## 📄 Lizenz

Dieses System ist Teil des Boxenstop-Projekts und unterliegt den entsprechenden Lizenzbedingungen.
