# Verifizierungs-System - User-Verifizierung mit Admin-Freischaltung

## Übersicht

Das Boxenstop-System wurde um ein Verifizierungssystem erweitert, bei dem neue Benutzer erst nach Überprüfung durch einen Administrator Zugriff auf die Buchungsfunktionen erhalten.

## Features

- ✅ **Verifizierung erforderlich**: Neue User starten im Status 'pending'
- ✅ **Dokumenten-Upload**: User müssen ein Identitätsdokument hochladen
- ✅ **Admin-Freischaltung**: Admin muss User explizit freischalten
- ✅ **Ablehnungs-System**: Admin kann User mit Begründung ablehnen
- ✅ **Status-Tracking**: Wartend, Freigeschaltet, Abgelehnt

## Installation

### 1. Datenbank aktualisieren

```bash
mysql -u Admin50 -p boxxenstopp < database/add_verification_fields.sql
```

### 2. Upload-Verzeichnis erstellen

```bash
mkdir -p uploads/verification_documents
chmod 755 uploads/verification_documents
```

### 3. Testen

1. Registriere einen neuen User
2. Melde dich mit neuem Account an
3. Du wirst zur Verifizierungsseite weitergeleitet
4. Lade ein Dokument hoch
5. Im Admin-Bereich User freischalten

## Workflow

```
1. User registriert sich (manuell oder per Apple Sign-In)
   ↓
2. User meldet sich an
   ↓
3. Weiterleitung zu verification_pending.php
   ↓
4. User lädt Verifikationsdokument hoch
   ↓
5. Admin prüft im Admin-Dashboard
   ↓
6. Admin schaltet User frei oder lehnt ab
   ↓
7. User kann nun Termine buchen ✅
```

## Neue Dateien

### Frontend
- `verification_pending.php` - Warteseite für nicht-verifizierte User
- `admin/user_verification.php` - Admin-Dashboard für User-Verifizierung

### Backend APIs
- `api/upload_verification_document.php` - Dokumenten-Upload
- `api/admin_approve_user.php` - User freischalten
- `api/admin_reject_user.php` - User ablehnen
- `api/get_pending_users.php` - Pending Users abrufen

### Datenbank
- `database/add_verification_fields.sql` - Erweitert users-Tabelle

## Datenbank-Struktur

```sql
ALTER TABLE users 
ADD COLUMN verification_status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
ADD COLUMN verification_document VARCHAR(500) NULL,
ADD COLUMN verification_reason TEXT NULL,
ADD COLUMN verified_by INT NULL,
ADD COLUMN verified_at DATETIME NULL;
```

**Status-Bedeutung**:
- `pending`: Wartet auf Verifizierung
- `approved`: Freigeschaltet, kann buchen
- `rejected`: Abgelehnt, kann nicht buchen

## Verwendung

### Für Benutzer

1. **Registrierung**:
   - Registriere dich normal über login.php
   - Status: `pending`

2. **Dokumenten-Upload**:
   - Nach Login wird man zu verification_pending.php geleitet
   - Lade ein Identitätsdokument hoch (Ausweis, Führerschein)
   - Warte auf Admin-Freischaltung

3. **Nach Freischaltung**:
   - Kann normal einloggen
   - Kann Termine buchen

### Für Admins

1. **Auf Admin-Dashboard zugreifen**:
   - Besuche `admin/user_verification.php`
   - Sieh alle wartenden User

2. **Dokument prüfen**:
   - Klicke auf "Ansehen" bei einem User
   - Dokument wird in neuem Tab geöffnet

3. **User freischalten**:
   - Klicke auf "Freischalten"
   - User kann nun buchen

4. **User ablehnen**:
   - Klicke auf "Ablehnen"
   - Gib einen Grund an
   - User erhält Benachrichtigung

## API-Integration für iOS

```swift
// Upload Verifikationsdokument
func uploadVerificationDocument(documentData: Data, userId: Int) {
    let url = URL(string: "https://yourdomain.com/api/upload_verification_document.php")!
    var request = URLRequest(url: url)
    request.httpMethod = "POST"
    
    // Multipart form data
    let boundary = UUID().uuidString
    request.setValue("multipart/form-data; boundary=\(boundary)", forHTTPHeaderField: "Content-Type")
    
    // ... implement upload
}
```

## Sicherheit

- ✅ **Admin-Authentifizierung**: Nur Admins können freischalten
- ✅ **Upload-Validierung**: Nur JPEG, PNG, PDF erlaubt
- ✅ **Dateigröße**: Max. 5MB
- ✅ **Nur eigene Dokumente**: User können nur eigene Uploads sehen
- ✅ **Session-basiert**: Alle Aktionen über Sessions

## Einschränkungen

- User im Status `pending` können sich anmelden, aber werden zur Verifizierungsseite geleitet
- User im Status `rejected` können sich erneut anmelden und neuen Upload versuchen
- Standard-Fahrzeug kann nicht gelöscht werden
- Verifizierungsstatus wird beim Login geprüft

## Admin-Bereich

Zugriff auf:
- `admin/user_verification.php` - User-Verifizierung
- Listet alle wartenden/abgelehnten User
- Dokument-Anzeige
- Freischaltung/Ablehnung mit Begründung

## Nächste Schritte

- [ ] E-Mail-Benachrichtigungen bei Freischaltung/Ablehnung
- [ ] Bulk-Aktionen für mehrere User
- [ ] Verifizierungs-Historie
- [ ] Automatische Verifizierung für bestimmte User-Gruppen
- [ ] 2FA für Admins

## Support

Bei Fragen oder Problemen:
- Siehe `PROFILE_SYSTEM_README.md`
- GitHub Issues
- E-Mail: support@beautomobile.de

---

**Erstellt**: 2025-01-26
**Version**: 1.0.0
**Autor**: Boxenstop Development Team

