# SMTP-Konfiguration für Produktion

## ✅ Test-Modus entfernt!

Alle Test-Dateien und Test-Modi wurden vollständig entfernt. Das System verwendet jetzt ausschließlich echte SMTP-Daten aus der Datenbank.

## 🔧 SMTP-Daten konfigurieren

### 1. Datenbank aktualisieren:

```sql
-- Für jedes Autohaus die SMTP-Daten eintragen:
UPDATE autohaus SET 
    email_smtp_host = 'smtp.gmail.com',                    -- SMTP-Server
    email_smtp_port = 587,                                -- SMTP-Port
    email_smtp_username = 'ihre-email@gmail.com',         -- SMTP-Benutzername
    email_smtp_password = 'ihr-app-passwort',             -- SMTP-Passwort
    email_smtp_encryption = 'tls',                        -- Verschlüsselung
    email_from_name = 'B&E Autocentrum'                   -- Absender-Name
WHERE id = [AUTOHAUS_ID];
```

### 2. Beispiel-Konfigurationen:

#### Gmail:
```sql
UPDATE autohaus SET 
    email_smtp_host = 'smtp.gmail.com',
    email_smtp_port = 587,
    email_smtp_username = 'ihre-email@gmail.com',
    email_smtp_password = 'ihr-16-stelliges-app-passwort',
    email_smtp_encryption = 'tls',
    email_from_name = 'B&E Autocentrum'
WHERE id = 1;
```

#### Outlook:
```sql
UPDATE autohaus SET 
    email_smtp_host = 'smtp-mail.outlook.com',
    email_smtp_port = 587,
    email_smtp_username = 'ihre-email@outlook.com',
    email_smtp_password = 'ihr-outlook-passwort',
    email_smtp_encryption = 'tls',
    email_from_name = 'B&E Autocentrum'
WHERE id = 1;
```

## 🚨 Wichtige Hinweise:

### 1. Gmail App-Passwort:
- **2-Faktor-Authentifizierung** aktivieren
- **App-Passwort** für "Mail" generieren
- **Nicht das normale Passwort** verwenden!

### 2. Sicherheit:
- **Passwörter** werden in der Datenbank gespeichert
- **Verschlüsselung** verwenden (TLS/SSL)
- **Regelmäßig** Passwörter ändern

### 3. Testen:
- **Email-Versand** nach Konfiguration testen
- **Logs** bei Problemen prüfen
- **SMTP-Einstellungen** validieren

## 🔍 Fehlerbehebung:

### "SMTP-Konfiguration nicht vollständig":
- Alle SMTP-Felder müssen ausgefüllt sein
- `email_smtp_host` und `email_smtp_username` sind Pflichtfelder

### "Authentication failed":
- Benutzername/Passwort prüfen
- App-Passwort bei Gmail verwenden
- 2-Faktor-Authentifizierung aktivieren

### "Connection timeout":
- SMTP-Host und Port prüfen
- Firewall-Einstellungen kontrollieren
- Netzwerk-Verbindung testen

## 📧 Email-Versand testen:

1. **Angebot erstellen** in `admin/appointments.php`
2. **"E-Mail senden"** klicken
3. **Email-Adresse** eingeben
4. **"E-Mail senden"** klicken
5. **Erfolg/Fehler** prüfen

## 🗄️ Datenbank-Struktur:

```sql
-- Autohaus-Tabelle SMTP-Felder:
email_smtp_host VARCHAR(255)     -- SMTP-Server
email_smtp_port INT(11)          -- SMTP-Port
email_smtp_username VARCHAR(255) -- SMTP-Benutzername
email_smtp_password VARCHAR(255) -- SMTP-Passwort
email_smtp_encryption VARCHAR(10) -- Verschlüsselung (tls/ssl)
email_from_name VARCHAR(255)      -- Absender-Name
```

## ✅ System bereit für Produktion!

Das System ist jetzt vollständig für den produktiven Einsatz konfiguriert:
- ✅ Test-Modi entfernt
- ✅ Echte SMTP-Daten erforderlich
- ✅ PHPMailer installiert und konfiguriert
- ✅ Vollständige Validierung
- ✅ Professionelle Fehlerbehandlung
- ✅ Badge-System funktional
- ✅ PDF-Generierung optimiert

## 🔧 PHPMailer Installation:

PHPMailer wurde manuell installiert:
- **Verzeichnis**: `vendor/phpmailer/`
- **Autoloader**: `vendor/autoload.php`
- **Status**: ✅ Verfügbar und funktionsfähig

## 📧 Email-Versand Status:

- **SMTP-Verbindung**: ✅ Funktioniert
- **Authentifizierung**: ⚠️ Prüfe SMTP-Daten
- **PHPMailer**: ✅ Installiert
- **Fallback**: ❌ Nicht mehr verwendet (nur PHPMailer)
