# RESY-System Update - API-Anpassungen

## Problem
Das RESY-System hat ein Update erhalten, wodurch die bestehende API `resy_data_extraction_breakthrough.php` keine Reifendaten mehr findet. Die Fehlermeldung lautet:

```
Fehler: Breakthrough Login & Navigation fehlgeschlagen: LGS_ID 9877038 nicht im RESY-System gefunden.
```

## Lösung
Die API wurde mit einer mehrstufigen Suchstrategie aktualisiert, die verschiedene Suchmethoden testet:

### 1. Neue Suchfunktion (`searchWithUpdatedResySystem`)
- **Verbesserte URL-Struktur**: Verwendet `http_build_query()` für saubere Parameter-Erstellung
- **Moderne HTTP-Headers**: Aktualisierte User-Agent und Accept-Header für bessere Kompatibilität
- **Intelligente Suchstrategien**: Testet verschiedene LGS_ID-Formate (mit/ohne Punkte, verschiedene Punkt-Positionen)
- **Erweiterte Erfolgs-Indikatoren**: Sucht nach verschiedenen Mustern in der Antwort

### 2. Alternative Suchmethoden (`searchWithAlternativeMethods`)
- **POST-basierte Suche**: Testet POST-Requests statt GET
- **Alternative Parameter**: Testet verschiedene Parameternamen und -strukturen
- **Alternative Module**: Testet andere RESY-Module (`m=search` statt `m=wheelset`)
- **Alternative Aktionen**: Testet andere Aktionen (`a=find` statt `a=search`)

### 3. Fallback-Suchlogik (`searchWithOriginalLogic`)
- **Vereinfachte Strategie**: Verwendet die ursprüngliche Logik als letzten Ausweg
- **Basis-Suchbegriffe**: Testet grundlegende LGS_ID-Variationen
- **Robuste Fehlerbehandlung**: Detaillierte Logging für Debugging

### 4. Intelligente Fallback-Strategie (`searchWithWorkingLgsIds`)
Die Hauptfunktion verwendet jetzt eine intelligente Fallback-Strategie:

1. **Erste Priorität**: Neue Suchfunktion für aktualisiertes RESY-System
2. **Zweite Priorität**: Alternative Suchmethoden für verschiedene System-Versionen
3. **Letzte Priorität**: Ursprüngliche Suchlogik als Fallback

## Verbesserungen

### Debugging & Logging
- **Detaillierte Logs**: Alle Suchversuche werden in `logs/resy_extraction.log` protokolliert
- **HTML-Dumps**: Alle Antworten werden als HTML-Dateien gespeichert für manuelle Analyse
- **Strukturierte Fehlermeldungen**: Hilfreiche Vorschläge bei Fehlern

### Performance
- **Frühe Erfolgs-Erkennung**: Stoppt bei erstem erfolgreichen Fund
- **Effiziente Suchstrategien**: Testet die wahrscheinlichsten Formate zuerst
- **Cache-Integration**: Nutzt bestehende Cache-Mechanismen

### Kompatibilität
- **Rückwärtskompatibilität**: Bestehende API-Aufrufe funktionieren weiterhin
- **Mehrere System-Versionen**: Unterstützt verschiedene RESY-System-Versionen
- **Robuste Fehlerbehandlung**: Graceful Degradation bei Problemen

## Verwendung

Die API kann weiterhin wie gewohnt verwendet werden:

```php
// Bestehender Code funktioniert weiterhin
$searchResult = searchWithWorkingLgsIds($baseUrl, $lgsId);
```

Die neue Implementierung testet automatisch verschiedene Suchmethoden und wählt die beste aus.

## Testing

Ein Test-Script wurde erstellt: `test_resy_updated_search.php`

```bash
php test_resy_updated_search.php
```

Dieses Script testet alle Suchmethoden mit verschiedenen LGS_IDs und zeigt detaillierte Ergebnisse.

## Debugging

Bei Problemen prüfen Sie:

1. **Log-Datei**: `logs/resy_extraction.log`
2. **HTML-Dumps**: `sys_get_temp_dir()/resy_search_updated_*.html`
3. **Alternative HTML-Dumps**: `sys_get_temp_dir()/resy_alternative_*.html`
4. **Fallback HTML-Dumps**: `sys_get_temp_dir()/resy_fallback_*.html`

## Nächste Schritte

1. **Testen Sie die neue Implementierung** mit echten LGS_IDs
2. **Prüfen Sie die Logs** auf erfolgreiche Suchstrategien
3. **Passen Sie die Suchstrategien an**, falls bestimmte Methoden besser funktionieren
4. **Entfernen Sie nicht funktionierende Methoden** nach erfolgreichen Tests

## Support

Bei weiteren Problemen:
1. Prüfen Sie die Debug-Logs für detaillierte Informationen
2. Analysieren Sie die HTML-Dumps für manuelle Suche
3. Testen Sie verschiedene LGS_ID-Formate manuell im RESY-System
4. Kontaktieren Sie den RESY-Support für System-spezifische Informationen
