# Quick Start - Login-System

## Schnelle Einrichtung

### 1. Datenbank-Einrichtung

Falls die `users`-Tabelle noch nicht existiert, importiere das SQL-Schema:

```bash
# Via phpMyAdmin oder MySQL CLI
mysql -u Admin50 -p boxxenstopp < api/users_table.sql
```

### 2. Erster Test-Benutzer

Registriere einen Test-Account:

- Besuche: `http://localhost/boxenstop/login.php`
- Klicke auf "Registrieren"
- Fülle das Formular aus
- Melde dich danach an

### 3. Test-Workflow

```
1. Besuche: login.php
   ↓
2. Registriere dich
   ↓
3. Automatische Weiterleitung zu index.php
   ↓
4. Sieh verfügbare Events
   ↓
5. Wähle Event aus
   ↓
6. Buchen (nur als eingeloggter User)
```

## Wichtige Dateien

```
boxenstop/
├── login.php                    # Login/Registrierungs-Seite
├── includes/
│   └── auth.php                # Auth-Utilities
├── api/
│   ├── login_user.php          # Login-API
│   ├── register_user.php       # Registrierungs-API
│   ├── save_user_session.php   # Session-Speicherung
│   └── logout.php              # Logout-API
└── index.php                   # Erfordert Login
```

## API-Endpunkte für iOS

```php
POST /api/login_user.php        // Login
POST /api/register_user.php     // Registrierung
GET  /api/get_user_profile.php  // Profil
POST /api/logout.php            // Logout
```

## Was wurde geändert?

### Vorher:

```
index.php → booking.php (Ohne Login)
```

### Jetzt:

```
login.php → index.php → booking.php
(Login erforderlich)
```

## Admin-Bereich

Das Admin-Dashboard (`admin/`) funktioniert unabhängig und erfordert **keine** Kunden-Login-Daten.

---

**Viel Erfolg!** 🚀
