# Profil-System mit Mehr-Fahrzeug-Unterstützung

## Übersicht

Das Boxenstop-System wurde um ein professionelles Profil-Management erweitert, das es Benutzern ermöglicht, mehrere Fahrzeuge zu verwalten.

## Features

- ✅ **Profil-Verwaltung**: Übersichtliche Profil-Seite
- ✅ **Mehrere Fahrzeuge**: Kunden können mehrere Kennzeichen hinzufügen
- ✅ **Standard-Fahrzeug**: Ein Fahrzeug kann als Standard markiert werden
- ✅ **Fahrzeug-Details**: Marke, Modell, Baujahr, Notizen
- ✅ **REST APIs**: Vollständige API-Unterstützung für iOS-Apps

## Neue Dateien

### Frontend

- `profile.php` - Profil-Seite mit Fahrzeugverwaltung

### Backend APIs

- `api/add_vehicle.php` - Fahrzeug hinzufügen
- `api/get_vehicle.php` - Fahrzeug abrufen
- `api/update_vehicle.php` - Fahrzeug aktualisieren
- `api/delete_vehicle.php` - Fahrzeug löschen

### Datenbank

- `database/create_user_vehicles_table.sql` - SQL-Schema für Fahrzeuge

## Datenbank-Struktur

```sql
CREATE TABLE IF NOT EXISTS user_vehicles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    license_plate VARCHAR(20) NOT NULL,
    vehicle_brand VARCHAR(100) NULL,
    vehicle_model VARCHAR(100) NULL,
    vehicle_year INT NULL,
    is_default BOOLEAN DEFAULT FALSE,
    is_active BOOLEAN DEFAULT TRUE,
    notes TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);
```

## Installation

### 1. Datenbank-Tabelle erstellen

```bash
mysql -u Admin50 -p boxxenstopp < database/create_user_vehicles_table.sql
```

### 2. Testen

1. Melde dich im System an
2. Klicke auf "Profil" in der Navigation
3. Füge dein erstes Fahrzeug hinzu

## Verwendung

### Für Web-Benutzer

1. **Zum Profil gelangen**:

   - Klicke auf "Profil" in der Navigation (wenn eingeloggt)
   - Oder besuche direkt `profile.php`

2. **Fahrzeug hinzufügen**:

   - Klicke auf "Fahrzeug hinzufügen"
   - Fülle die Formularfelder aus:
     - **Kennzeichen** (erforderlich)
     - **Marke** (optional)
     - **Modell** (optional)
     - **Baujahr** (optional)
     - **Notizen** (optional)
     - **Als Standard-Fahrzeug setzen**
   - Klicke auf "Speichern"

3. **Fahrzeug bearbeiten**:

   - Klicke auf "Bearbeiten" bei einem Fahrzeug
   - Ändere die gewünschten Informationen
   - Klicke auf "Speichern"

4. **Standard-Fahrzeug setzen**:

   - Beim Hinzufügen oder Bearbeiten die Option "Als Standardfahrzeug setzen" aktivieren
   - Es kann nur ein Standard-Fahrzeug pro Benutzer geben

5. **Fahrzeug löschen**:
   - Klicke auf "Löschen" bei einem Fahrzeug
   - Bestätige die Löschung
   - Hinweis: Das Standard-Fahrzeug kann nicht gelöscht werden

### Für iOS-Apps

Das Backend bietet REST APIs:

**Fahrzeug hinzufügen**:

```bash
POST /api/add_vehicle.php
Content-Type: application/json
Authorization: Bearer <token>

{
    "license_plate": "M-AB 123",
    "vehicle_brand": "Volvo",
    "vehicle_model": "XC60",
    "vehicle_year": 2020,
    "is_default": false,
    "vehicle_notes": "Hauptfahrzeug"
}
```

**Fahrzeug abrufen**:

```bash
GET /api/get_vehicle.php?id=123
Authorization: Bearer <token>
```

**Fahrzeug aktualisieren**:

```bash
POST /api/update_vehicle.php
Content-Type: application/json
Authorization: Bearer <token>

{
    "vehicle_id": 123,
    "license_plate": "M-AB 123",
    "vehicle_brand": "Volvo",
    "vehicle_model": "XC90",
    "vehicle_year": 2022,
    "is_default": true,
    "vehicle_notes": "Neues Fahrzeug"
}
```

**Fahrzeug löschen**:

```bash
POST /api/delete_vehicle.php
Content-Type: application/json
Authorization: Bearer <token>

{
    "vehicle_id": 123
}
```

## Profil-Features

### 1. Benutzer-Avatar

- Automatisches Initials-Avatar (z.B. "MU" für Max Mustermann)
- Farbiges Gradient-Design

### 2. Benutzer-Informationen

- Name und E-Mail-Anzeige
- Automatisch aus der Datenbank geladen

### 3. Fahrzeug-Grid

- Responsive Grid-Layout
- Karten-basiertes Design
- Standard-Fahrzeug hervorgehoben

### 4. Modals für Aktionen

- Einfache Bedienung
- Mobile-friendly
- Validierung der Eingaben

## Integration in Booking

Das Standard-Fahrzeug wird automatisch in `booking.php` verwendet:

```php
// Aus getCurrentUser() wird das Standard-Fahrzeug geladen
$user = getCurrentUser();
$default_vehicle = getDefaultVehicle($user['id']);
```

## UI/UX Features

- **Modern Design**: Gradient-Backgrounds, Animationen
- **Responsive**: Funktioniert auf allen Geräten
- **Benutzerfreundlich**: Intuitive Bedienung
- **Feedback**: Alerts für Erfolg/Fehler
- **Validation**: Client- und Server-seitige Validierung

## Sicherheit

- ✅ User-Authentifizierung erforderlich
- ✅ Nur eigene Fahrzeuge können bearbeitet/gelöscht werden
- ✅ Standard-Fahrzeug kann nicht gelöscht werden
- ✅ Session-basierte Authentifizierung
- ✅ SQL-Injection-Schutz (Prepared Statements)

## Nächste Schritte

- [ ] Profilbild-Upload
- [ ] Fahrzeug-Import aus vorherigen Buchungen
- [ ] Favoriten-System
- [ ] Buchungs-Historie im Profil
- [ ] Benachrichtigungen konfigurieren

## Support

Bei Fragen oder Problemen:

- Siehe `LOGIN_SYSTEM_README.md`
- GitHub Issues
- E-Mail: support@beautomobile.de

---

**Erstellt**: 2025-01-26
**Version**: 1.0.0
**Autor**: Boxenstop Development Team
