# Boxenstop Login/Registrierungs-System

## Übersicht

Das Boxenstop-Projekt wurde um ein vollständiges Login/Registrierungs-System erweitert, das es Kunden ermöglicht, sich anzumelden oder zu registrieren, bevor sie Termine buchen können.

## Features

- ✅ **Login/Registrierung**: Benutzer können sich mit E-Mail und Passwort registrieren und anmelden
- ✅ **Apple Sign-In**: Integration von Apple Sign-In für professionelle Anmeldung
- ✅ **Session-Verwaltung**: Sichere Token-basierte Authentifizierung
- ✅ **Login-Requirement**: Termine können nur von eingeloggten Benutzern gebucht werden
- ✅ **iOS-App Unterstützung**: Backend APIs für native iOS-Apps

## Struktur

### Neue Dateien

1. **`login.php`**: Login/Registrierungs-Seite mit Apple Sign-In
2. **`includes/auth.php`**: Authentication Utility für Session-Verwaltung
3. **`api/save_user_session.php`**: API zum Speichern der User-Session
4. **`api/logout.php`**: Logout-Funktionalität

### Angepasste Dateien

1. **`index.php`**: Login-Prüfung hinzugefügt
2. **`booking.php`**: Login-Prüfung hinzugefügt
3. **`api/login_user.php`**: Apple Sign-In Unterstützung erweitert

## Datenbank-Struktur

Die `users` Tabelle unterstützt:

- **Normale Anmeldung**: E-Mail + Passwort
- **Apple Sign-In**: `apple_user_id` + optional Passwort
- **Token-basierte Auth**: `auth_token` mit Ablaufdatum
- **Session-Management**: 30 Tage gültige Token

```sql
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    first_name VARCHAR(100) NOT NULL,
    last_name VARCHAR(100) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    phone_number VARCHAR(20) NOT NULL,
    license_plate VARCHAR(20) NOT NULL,
    password_hash VARCHAR(255) NULL,
    apple_user_id VARCHAR(255) NULL UNIQUE,
    auth_token VARCHAR(500) NULL,
    token_expires_at DATETIME NULL,
    is_active BOOLEAN DEFAULT TRUE,
    email_verified BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

## Verwendung

### Für Web-Benutzer

1. **Registrierung**:

   - Besuche `login.php`
   - Registriere dich mit Name, E-Mail, Telefon, Kennzeichen und Passwort
   - Oder verwende Apple Sign-In

2. **Anmeldung**:

   - Besuche `login.php`
   - Melde dich mit E-Mail und Passwort an
   - Oder verwende Apple Sign-In

3. **Terminbuchung**:
   - Nach erfolgreicher Anmeldung wirst du automatisch zu `index.php` weitergeleitet
   - Buche Termine wie gewohnt

### Für iOS-Apps

Das Backend bietet REST APIs für native iOS-Apps:

**Login**:

```bash
POST /api/login_user.php
Content-Type: application/json

{
    "email": "user@example.com",
    "password": "password123"
}
```

**Registrierung**:

```bash
POST /api/register_user.php
Content-Type: application/json

{
    "first_name": "Max",
    "last_name": "Mustermann",
    "email": "user@example.com",
    "phone_number": "+49 123 456789",
    "license_plate": "M-AB 123",
    "password": "password123"
}
```

**Apple Sign-In**:

```bash
POST /api/login_user.php
Content-Type: application/json

{
    "apple_user_id": "001234.567890abcdef",
    "email": "user@example.com",
    "first_name": "Max",
    "last_name": "Mustermann",
    "phone_number": "+49 123 456789",
    "license_plate": "M-AB 123"
}
```

**Profil abrufen**:

```bash
GET /api/get_user_profile.php
Authorization: Bearer <auth_token>
```

## Apple Sign-In Konfiguration

### 1. Apple Developer Account Setup

- Erstelle eine App-ID in Apple Developer Portal
- Konfiguriere "Sign in with Apple" capability
- Erstelle ein Service-ID für den Backend-Authentifizierungscode

### 2. Konfiguration

Für die vollständige Apple Sign-In Integration benötigen Sie:

```javascript
AppleID.auth.init({
  clientId: "de.beautomobile.boxenstop", // Ihre Bundle-ID
  scope: "name email",
  redirectURI: window.location.origin + "/api/apple_callback.php",
  usePopup: true,
});
```

### 3. Auf iOS

Für die iOS-App verwenden Sie:

```swift
import AuthenticationServices

let provider = ASAuthorizationAppleIDProvider()
let request = provider.createRequest()
request.requestedScopes = [.fullName, .email]

let controller = ASAuthorizationController(authorizationRequests: [request])
controller.delegate = self
controller.presentationContextProvider = self
controller.performRequests()
```

## Sicherheit

- ✅ Passwörter werden mit `password_hash()` gesichert
- ✅ Token sind 30 Tage gültig
- ✅ Sessions werden bei Logout ungültig
- ✅ E-Mail-Validierung
- ✅ Sanitized Inputs

## Entwicklung

### Local Testing

1. Starte den XAMPP Server
2. Öffne `http://localhost/boxenstop/login.php`
3. Registriere einen Test-Account
4. Melde dich an und teste die Buchungsfunktion

### Debugging

Logs befinden sich in:

- PHP Error Log: `php_errors.log`
- Session-Debug: `var_dump($_SESSION)` in `includes/auth.php`

## Admin-Bereich

Das Admin-Dashboard (`admin/`) verwendet ein separates Login-System und ist nicht betroffen.

## iOS App Integration

Das Backend ist vollständig iOS-App-ready:

1. **REST APIs**: Alle Endpoints sind JSON-basiert
2. **Token-Auth**: JWT-ähnliche Token-Struktur
3. **CORS**: Bereits konfiguriert für Cross-Origin Requests
4. **Apple Sign-In**: Bereit für native iOS Integration

## Nächste Schritte

- [ ] Email-Verifizierung implementieren
- [ ] Passwort-Recovery
- [ ] Profilverwaltung für User
- [ ] 2FA für erhöhte Sicherheit
- [ ] Social Login (Google, Facebook)

## Support

Bei Fragen oder Problemen:

- GitHub Issues
- E-Mail: support@beautomobile.de

---

**Erstellt**: 2025-01-26
**Version**: 1.0.0
**Autor**: Boxenstop Development Team
