# E-Mail-Debug Anleitung

## 🔍 Problem

Die E-Mail wird im Frontend als "erfolgreich" angezeigt, aber:

- ❌ E-Mail kommt nicht an
- ❌ Nichts im Postfach vom hinterlegten Postfach

## 🎯 Debug-Schritte

### **1. Debug-Logs prüfen**

Öffnen Sie diese URL im Browser:

```
http://localhost/boxenstop/api/check_email_logs.php
```

**Dies zeigt Ihnen:**

- ✅ Alle E-Mail-Logs
- ✅ PHPMailer-Status
- ✅ SMTP-Konfiguration
- ✅ Mögliche Fehler

### **2. Error Log direkt lesen**

Öffnen Sie diese Datei in einem Text-Editor:

```
C:\xampp\apache\logs\error.log
```

**Suchen Sie nach:**

- "FREISCHALTUNGS-E-MAIL"
- "SMTP Debug:"
- "E-Mail-Fehler"

### **3. Test-E-Mail senden**

Öffnen Sie diese URL (ersetzen Sie die E-Mail-Adresse!):

```
http://localhost/boxenstop/api/test_email_verification.php?email=IhreTestEmail@example.com
```

**Dies versendet eine Test-E-Mail und zeigt:**

- ✅ SMTP-Verbindung
- ✅ Authentifizierung
- ✅ Debug-Ausgabe

### **4. SMTP-Debug aktiviert**

SMTP Debug ist jetzt auf `Level 2` aktiviert in:

- `api/admin_approve_user.php` (Zeile 119)
- Alle SMTP-Kommandos werden geloggt

---

## 📋 Was in den Logs steht

### **Erfolgreicher Versand**:

```
=== FREISCHALTUNGS-E-MAIL ERFOLGREICH ===
Empfänger: user@example.com
Autohaus: Kiel
Betreff: Ihr Konto wurde freigeschaltet - Boxenstop
SMTP Server: smtp-mail.outlook.com:587
```

### **SMTP-Debug (bei Erfolg)**:

```
SMTP Debug: Connecting to smtp-mail.outlook.com:587
SMTP Debug: < 220 mail.outlook.com...
SMTP Debug: Starting TLS
SMTP Debug: EHLO localhost
SMTP Debug: Authenticating...
SMTP Debug: Connected
```

### **Bei Fehler**:

```
=== FREISCHALTUNGS-E-MAIL FEHLER ===
Empfänger: user@example.com
Autohaus: Kiel
Fehler: Could not authenticate
SMTP Server: smtp-mail.outlook.com:587
Username: rentacar-kiel@be-automobile.de
```

---

## 🔧 Häufige Probleme

### **Problem 1: "Could not authenticate"**

**Ursache**: Falsche SMTP-Credentials

**Lösung**:

```sql
-- Prüfen Sie die SMTP-Daten
SELECT id, name, email_smtp_host, email_smtp_username, email_smtp_password
FROM autohaus
WHERE is_active = 1;
```

### **Problem 2: "Connection timeout"**

**Ursache**: Firewall blockiert Port 587

**Lösung**:

- Firewall-Regel für Port 587 hinzufügen
- Prüfen ob Outlook-Server erreichbar ist

### **Problem 3: "SMTP-Konfiguration nicht vollständig"**

**Ursache**: Autohaus hat keine SMTP-Daten

**Lösung**:

```sql
-- SMTP-Daten eintragen
UPDATE autohaus SET
    email_smtp_host = 'smtp-mail.outlook.com',
    email_smtp_port = 587,
    email_smtp_username = 'rentacar-kiel@be-automobile.de',
    email_smtp_password = 'IhrPasswort',
    email_smtp_encryption = 'tls',
    email_from_name = 'Boxenstop'
WHERE id = 1;
```

### **Problem 4: PHPMailer nicht gefunden**

**Ursache**: PHPMailer-Ordner fehlt

**Lösung**:

- Prüfen Sie ob `api/phpmailer/` existiert
- Dateien: `PHPMailer.php`, `SMTP.php`, `Exception.php`

---

## 🎯 Testen

### **1. Debug-Logs prüfen** ✅

```
http://localhost/boxenstop/api/check_email_logs.php
```

### **2. Test-E-Mail senden** ✅

```
http://localhost/boxenstop/api/test_email_verification.php?email=IhreEmail@example.com
```

### **3. Log-Datei lesen** ✅

```
C:\xampp\apache\logs\error.log
```

---

## 📞 Nächste Schritte

1. ✅ Debug-Logs URL öffnen
2. ✅ Error Log lesen
3. ✅ Fehler identifizieren
4. ✅ SMTP-Daten korrigieren
5. ✅ Erneut testen

---

**Status**: Debug aktiviert
**Version**: 1.0.0
