# API Referenz – B&E Gruppe (Boxenstop)

Diese Referenz beschreibt alle in diesem Projekt verwendeten API-Endpunkte. Sie ist praxisnah (aus dem Code ermittelt) und enthält Methoden, Pfade, Authentifizierung, Request-/Response-Schemas, cURL-Beispiele, Fehlerfälle sowie ein Seiten→API-Mapping.

---

## Inhaltsverzeichnis

- Sicherheit & Konventionen
- Authentifizierung (Login/Logout/Apple)
- Benutzer & Profil
- Fahrzeuge
- Termine (Slots, Buchen, Stornieren)
- Benachrichtigungen & Aktivitäten
- Admin: Verifizierung & Benutzer
- Admin: Kundenprofil
- Admin: Einstellungen (Footer-Bild)
- Index/Autohaus-Auswahl, ICS-Download
- Admin-Angebote/RESY-Subsystem (Übersicht)
- Seiten → API Mapping (komplett)
- Fehler & Statuscodes

---

## Sicherheit & Konventionen

- Alle Responses sind JSON, sofern nicht anders angegeben (z. B. ICS/PDF/Proxy).
- Zeitformat: ISO-Like (Datum `YYYY-MM-DD`, Zeit `HH:MM:SS`).
- Authentifizierung:
  - Benutzer: PHP Session (`user_logged_in`/`user_id`).
  - Admin: PHP Session (`admin_logged_in`/`admin_user_id`).
- CORS: Mobile-Apps werden unterstützt (Access-Control-Header in den meisten APIs gesetzt).
- iOS-Kompatibilität: Bei ICS-Download kann die `session_id` als `_session`-Query-Parameter übergeben werden.

---

## Authentifizierung

### POST /api/login_user.php

- Zweck: Benutzer-Anmeldung (E-Mail/Passwort oder Apple-Sign-In)
- Auth: keine (erstellt Session bei Erfolg)
- Body (E-Mail/Passwort):

```json
{
  "email": "user@example.com",
  "password": "secret"
}
```

- Body (Apple):

```json
{
  "provider": "apple",
  "id_token": "<JWT>",
  "datenschutz_accepted": true
}
```

- Response (Erfolg):

```json
{
  "success": true,
  "user": {
    "id": 57,
    "email": "user@example.com",
    "first_name": "Max",
    "last_name": "Mustermann",
    "verification_status": "approved"
  }
}
```

- Fehler (Beispiel):

```json
{ "success": false, "message": "Ungültige Anmeldedaten" }
```

- cURL:

```bash
curl -X POST https://be-automobileapps.de/api/login_user.php \
  -H "Content-Type: application/json" \
  -d '{"email":"user@example.com","password":"secret"}'
```

### POST /api/register_user.php

- Zweck: Registrierung
- Auth: keine
- Body:

```json
{
  "email": "new@example.com",
  "password": "secret",
  "first_name": "Max",
  "last_name": "Mustermann",
  "phone": "+49 1234567",
  "datenschutz_accepted": true
}
```

- Response:

```json
{ "success": true, "message": "Registrierung erfolgreich", "user_id": 58 }
```

### POST /api/apple_callback.php

- Zweck: Apple Sign-In Callback-Handling
- Auth: keine
- Body: (von Apple)
- Response:

```json
{ "success": true, "message": "Anmeldung erfolgreich" }
```

### GET /api/logout.php

- Zweck: Benutzer abmelden
- Auth: Benutzer-Session
- Response:

```json
{ "success": true, "message": "Abgemeldet" }
```

---

## Benutzer & Profil

### GET /api/get_user_profile.php

- Zweck: Benutzerprofil abrufen
- Auth: Benutzer-Session
- Response (Beispiel):

```json
{
  "success": true,
  "user": {
    "id": 57,
    "email": "user@example.com",
    "first_name": "Max",
    "last_name": "Mustermann",
    "phone_number": "+49 111",
    "address": "Musterstr. 1",
    "postal_code": "12345",
    "city": "Berlin",
    "profile_image": "uploads/profile/57.jpg",
    "verification_status": "approved"
  }
}
```

### POST /api/update_profile.php

- Zweck: Profildaten ändern
- Auth: Benutzer-Session
- Body (alle Felder optional):

```json
{
  "first_name": "Max",
  "last_name": "Mustermann",
  "phone_number": "+49 111",
  "address": "Musterstr. 1",
  "postal_code": "12345",
  "city": "Berlin"
}
```

- Response:

```json
{ "success": true, "message": "Profil aktualisiert" }
```

### POST /api/change_password.php

- Zweck: Passwort ändern
- Auth: Benutzer-Session
- Body:

```json
{ "current_password": "old", "new_password": "new" }
```

- Response:

```json
{ "success": true, "message": "Passwort erfolgreich geändert" }
```

### POST /api/upload_verification_document.php

- Zweck: Verifikationsdokument hochladen
- Auth: Benutzer-Session
- Body: multipart/form-data (`document`)
- Response:

```json
{ "success": true, "document_url": "uploads/verification/57/file.pdf" }
```

---

## Fahrzeuge

### GET /api/get_vehicle.php?id={id}

- Zweck: Fahrzeug laden
- Auth: Benutzer-Session
- Response:

```json
{
  "success": true,
  "vehicle": {
    "id": 10,
    "license_plate": "B-AB 123",
    "brand": "Volvo",
    "model": "XC60",
    "year": 2020
  }
}
```

### POST /api/add_vehicle.php

- Zweck: Fahrzeug anlegen
- Auth: Benutzer-Session
- Body:

```json
{ "license_plate": "B-AB 123", "brand": "Volvo", "model": "XC60", "year": 2020 }
```

- Response:

```json
{ "success": true, "vehicle_id": 10 }
```

### POST /api/update_vehicle.php

- Zweck: Fahrzeug ändern
- Auth: Benutzer-Session
- Body:

```json
{ "vehicle_id": 10, "license_plate": "B-AB 456" }
```

- Response:

```json
{ "success": true, "message": "Fahrzeug aktualisiert" }
```

### POST /api/delete_vehicle.php

- Zweck: Fahrzeug löschen
- Auth: Benutzer-Session
- Body:

```json
{ "vehicle_id": 10 }
```

- Response:

```json
{ "success": true, "message": "Fahrzeug gelöscht" }
```

---

## Termine (Slots, Buchen, Stornieren)

### GET /api/get_available_slots.php?event_id={id}&date={YYYY-MM-DD}

- Zweck: Verfügbare Slots
- Auth: keine
- Response:

```json
{
  "success": true,
  "event": {
    "id": 20,
    "name": "Wechsel",
    "slot_duration": 30,
    "max_monteure": 5
  },
  "available_slots": [
    {
      "time": "09:00:00",
      "formatted_time": "09:00",
      "available": true,
      "available_count": 4,
      "booked": 1,
      "max_count": 5
    }
  ],
  "date": "2025-11-01",
  "total_slots": 10,
  "total_available": 25
}
```

- cURL:

```bash
curl "https://be-automobileapps.de/api/get_available_slots.php?event_id=20&date=2025-11-01"
```

### POST /api/appointments.php

- Zweck: Termin buchen
- Auth: optional (wenn eingeloggt, wird user_id/vehicle_id verknüpft)
- Body (Beispiel):

```json
{
  "event_id": 20,
  "slot_time": "09:30:00",
  "slot_date": "2025-11-01",
  "customer_name": "Max Mustermann",
  "license_plate": "B-AB 123",
  "phone": "+49 123",
  "email": "user@example.com",
  "source": "website"
}
```

- Response:

```json
{
  "success": true,
  "appointment_id": 104,
  "message": "Termin erfolgreich gebucht"
}
```

### POST /api/cancel_appointment.php

- Zweck: Termin stornieren
- Auth: Benutzer-Session
- Body:

```json
{ "appointment_id": 104 }
```

- Response:

```json
{ "success": true, "message": "Termin erfolgreich storniert" }
```

---

## Benachrichtigungen & Aktivitäten

### GET /api/get_user_notifications.php?limit={n}&offset={n}

- Zweck: Benachrichtigungen abrufen
- Auth: Benutzer-Session
- Response:

```json
{
  "success": true,
  "notifications": [
    {
      "id": 1,
      "type": "appointment",
      "title": "...",
      "message": "...",
      "is_read": false,
      "created_at": "..."
    }
  ],
  "unread_count": 5
}
```

### POST /api/mark_notification_read.php

- Zweck: Benachrichtigung als gelesen markieren
- Auth: Benutzer-Session
- Body:

```json
{ "notification_id": 1 }
```

- Response:

```json
{ "success": true, "message": "Benachrichtigung als gelesen markiert" }
```

### GET /api/get_activity_log.php?limit={n}&offset={n}

- Zweck: Aktivitäten abrufen
- Auth: Benutzer-Session
- Response:

```json
{
  "success": true,
  "activities": [
    {
      "id": 1,
      "action_type": "appointment_created",
      "description": "...",
      "metadata": { "appointment_id": 104 },
      "created_at": "..."
    }
  ],
  "total_count": 20,
  "stats": [{ "action_type": "appointment_created", "count": 5 }]
}
```

---

## Admin: Verifizierung & Benutzer

### POST /api/admin_approve_user.php

- Zweck: Benutzer freischalten + E-Mail Versand (SMTP per Autohaus)
- Auth: Admin-Session
- Body:

```json
{ "user_id": 57 }
```

- Response:

```json
{ "success": true, "message": "Benutzer freigeschaltet" }
```

### POST /api/admin_reject_user.php

- Zweck: Benutzer ablehnen + E-Mail Versand
- Auth: Admin-Session
- Body:

```json
{ "user_id": 57, "reason": "Dokument unleserlich" }
```

- Response:

```json
{ "success": true, "message": "Benutzer abgelehnt" }
```

### POST /api/link_user_to_admin.php

- Zweck: Kundenkonto mit Admin verknüpfen
- Auth: Admin-Session
- Body:

```json
{ "user_id": 57, "admin_user_id": 3 }
```

- Response:

```json
{ "success": true, "message": "User erfolgreich mit Admin verknüpft" }
```

### GET admin/api/get_user.php?id={id}

- Zweck: Admin-Benutzer laden (für Bearbeiten)
- Auth: Admin-Session
- Response:

```json
{ "success": true, "user": { "id": 3, "username": "admin", "email": "...", "role": "admin", "is_active": 1, ... } }
```

### Dokumente (Admin)

- GET admin/api/get_user_documents.php?user_id={id}
- POST admin/api/admin_document_action.php (approve|reject)
- GET admin/api/view_document.php?file={path}
- Auth: Admin-Session

---

## Admin: Kundenprofil

### GET /api/get_customer_profile.php?user_id={id}

- Zweck: Kundendetails, Fahrzeuge, Termine, Aktivitäten
- Auth: Admin-Session
- Response:

```json
{
  "success": true,
  "user_data": { "id": 57, "first_name": "Max", "verification_status": "approved", ... },
  "vehicles": [ ... ],
  "appointments": [ ... ],
  "activity_log": [ ... ],
  "stats": { "total_appointments": 3, "total_vehicles": 1, "total_activities": 10 }
}
```

---

## Admin: Einstellungen (Footer-Bild)

### POST /api/upload_autohaus_footer_image.php

- Zweck: Footer-Bild pro Autohaus hochladen
- Auth: Admin-Session
- Body: multipart/form-data { autohaus_id, footer_image, image_alt }
- Response:

```json
{ "success": true, "message": "Bild erfolgreich hochgeladen!" }
```

---

## Index/Autohaus-Auswahl & ICS

### POST /api/autohaus_selection.php

- Zweck: Autohaus-Auswahl in Session speichern
- Auth: keine
- Body:

```json
{
  "action": "select_autohaus",
  "autohaus_id": 1,
  "autohaus_name": "Autohaus ABC"
}
```

- Response:

```json
{ "success": true }
```

### GET /download_appointment_ics.php?id={id}&\_session={optional}

- Zweck: ICS-Download für Termin
- Auth: Session (Workaround via `_session` für iOS möglich)
- Response: text/calendar (Datei)

---

## Admin-Angebote/RESY-Subsystem (Übersicht)

Diese Endpunkte werden in `admin/appointments.php` genutzt (PDFs, Angebote, Teams, RESY). Auth: Admin-Session.

- GET ../api/get_available_slots.php – Slots im Edit-Modal
- GET ../api/appointments.php?event_id=..&date=.. – Slot-Counts
- GET ../api/get_autohauser.php – Autohausliste
- POST ../api/tire_order.php – Reifenbestellung (Angebot)
- POST ../api/generate_professional_pdf.php – Angebots-PDF
- GET ../api/get_offer_details.php?appointmentId=.. – Angebotsdetails
- GET ../api/get_customer_selection.php?appointmentId=.. – Kundenauswahl
- POST ../api/track_offer.php – Tracking-Events
- GET ../api/get_autohaus_services.php – Leistungs-Set pro Autohaus
- POST ../api/generate_real_pdf.php – Alternativer PDF-Generator
- GET ../api/get_smtp_data.php?appointmentId=.. – SMTP je Autohaus
- POST ../api/send_offer_email.php – Angebot per E-Mail versenden
- GET ../api/get_tire_suggestions.php?appointmentId=.. – Vorschläge
- POST ../api/save_tire_suggestion.php – Vorschläge speichern
- POST ../api/send_teams_notification.php – Teams Notification anstoßen
- POST ../api/mark_teams_notification_sent.php – Teams-Status setzen
- GET ../api/view_pdf.php?filename=.. – PDF anzeigen (Proxy)
- GET ../api/download_pdf.php?filename=.. – PDF herunterladen
- GET ../api/resy_image_proxy.php?lgfoto_id=.. – Bild-Proxy
- POST ../api/resy_data_extraction_breakthrough.php – RESY Login/Extraktion (Produktiv)
- POST ../api/resy_data_extraction_sample.php – RESY Test

Hinweis: Diese Subsystem-APIs sind umfangreich. Für produktiven Gebrauch stehen die oben genannten produktiv referenzierten Routen zur Verfügung; zahlreiche Varianten/Backups im `api/` Ordner sind nicht aktiv im UI verlinkt.

---

## Seiten → API Mapping (komplett)

### index.php

- POST /api/autohaus_selection.php
- GET /api/logout.php
- GET /download_appointment_ics.php

### booking.php (+ assets/js/booking.js)

- GET /api/get_available_slots.php
- POST /api/appointments.php
- GET /api/settings.php

### profile.php

- GET /api/get_user_profile.php
- POST /api/update_profile.php
- POST /api/change_password.php
- GET /api/get_vehicle.php
- POST /api/add_vehicle.php
- POST /api/update_vehicle.php
- POST /api/delete_vehicle.php
- GET /api/get_user_notifications.php
- POST /api/mark_notification_read.php
- GET /api/get_activity_log.php
- POST /api/cancel_appointment.php

### login.php

- POST /api/login_user.php
- POST /api/register_user.php
- POST /api/apple_callback.php

### admin/admin_dashboard.php (+ Widgets)

- POST /api/admin_approve_user.php
- POST /api/admin_reject_user.php
- GET admin/api/get_user_documents.php
- POST admin/api/admin_document_action.php
- GET admin/api/view_document.php
- GET /api/get_customer_profile.php

### admin/users.php

- GET admin/api/get_user.php
- POST /api/link_user_to_admin.php

### admin/appointments.php

- s. Abschnitt „Admin-Angebote/RESY-Subsystem“

### admin/settings.php

- POST /api/upload_autohaus_footer_image.php

---

## Fehler & Statuscodes

Gemeinsame Statuscodes:

- 200 OK – Erfolg
- 400 Bad Request – Validierungsfehler/Fehlende Parameter
- 401 Unauthorized – Session fehlt/abgelaufen
- 404 Not Found – Ressource nicht gefunden
- 500 Internal Server Error – Unerwarteter Fehler

Fehlerformat (typisch):

```json
{ "success": false, "message": "Fehlerbeschreibung" }
```

---

Stand: 2025-10
