<?php
/**
 * Volvo Connected Vehicle API - Vehicles Liste
 * Route: /volvo/vehicles
 */

session_start();
require_once __DIR__ . '/../util_volvo.php';

header('Content-Type: application/json');

try {
    // Prüfe ob User eingeloggt ist (optional, je nach Anforderung)
    // if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    //     http_response_code(401);
    //     echo json_encode(['error' => 'Nicht autorisiert']);
    //     exit;
    // }
    
    // Access Token sicherstellen (proaktiver Refresh)
    $accessToken = volvoEnsureAccess();
    
    if (!$accessToken) {
        http_response_code(401);
        echo json_encode([
            'error' => 'Kein gültiger Access Token',
            'redirect' => '/auth/volvo/login.php'
        ]);
        exit;
    }
    
    // API-Aufruf: Vehicles
    $vehicles = volvoApiGet('/connected-vehicle/v2/vehicles', $accessToken);
    
    echo json_encode([
        'success' => true,
        'vehicles' => $vehicles,
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log('Volvo Vehicles Error: ' . $e->getMessage());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

