<?php
// CLI helper: Listet einige Events für Tests
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }
require_once __DIR__ . '/../config/database.php';

try {
  $db = new Database();
  $conn = $db->getConnection();
  $stmt = $conn->query("SELECT id, name, event_date, is_active FROM events ORDER BY event_date DESC LIMIT 10");
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
  if (!$rows) { echo "Keine Events gefunden.\n"; exit(0); }
  foreach ($rows as $r) {
    echo sprintf("ID:%d | %s | Datum:%s | aktiv:%s\n", $r['id'], $r['name'] ?? '-', $r['event_date'] ?? '-', ($r['is_active'] ? 'ja' : 'nein'));
  }
} catch (Throwable $e) {
  echo 'ERROR: ' . $e->getMessage() . "\n";
  exit(1);
}


