// ============================================
// TEST-CODE FÜR STANDORTBERECHTIGUNGS-MODAL
// ============================================
// Kopiere diesen Code in die Browser-Konsole (F12) auf der login.php Seite

// Funktion zum Anzeigen des Modals
function showLocationPermissionModal() {
    return new Promise((resolve) => {
        // Erstelle Modal
        const modal = document.createElement('div');
        modal.id = 'location-permission-modal';
        modal.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 10000;
            animation: fadeIn 0.3s ease;
        `;
        
        modal.innerHTML = `
            <div style="
                background: white;
                border-radius: 16px;
                padding: 2rem;
                max-width: 500px;
                width: 90%;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                animation: slideUp 0.3s ease;
            ">
                <div style="text-align: center; margin-bottom: 1.5rem;">
                    <div style="
                        width: 64px;
                        height: 64px;
                        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 1rem;
                        box-shadow: 0 4px 12px rgba(0,123,255,0.3);
                    ">
                        <i class="fas fa-map-marker-alt" style="font-size: 2rem; color: white;"></i>
                    </div>
                    <h3 style="margin: 0 0 0.5rem 0; color: #212529; font-size: 1.5rem; font-weight: 600;">
                        Standortbestimmung
                    </h3>
                    <p style="margin: 0; color: #6c757d; font-size: 0.95rem;">
                        Für eine bessere Service-Erfahrung
                    </p>
                </div>
                
                <div style="background: #f8f9fa; padding: 1.25rem; border-radius: 12px; margin-bottom: 1.5rem; border-left: 4px solid #007bff;">
                    <p style="margin: 0 0 0.75rem 0; color: #495057; line-height: 1.6; font-size: 0.95rem;">
                        <strong>Warum benötigen wir Ihren Standort?</strong>
                    </p>
                    <p style="margin: 0; color: #6c757d; line-height: 1.6; font-size: 0.9rem;">
                        Wir verwenden Ihren Standort, um Ihnen automatisch das richtige Autohaus in Ihrer Nähe zuzuordnen und Ihnen relevante Angebote zu zeigen. Dies hilft uns, Ihnen den bestmöglichen Service zu bieten.
                    </p>
                </div>
                
                <div style="background: #e7f3ff; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #b3d9ff;">
                    <div style="display: flex; align-items: start; gap: 0.75rem;">
                        <i class="fas fa-shield-alt" style="color: #007bff; font-size: 1.2rem; margin-top: 0.2rem;"></i>
                        <div>
                            <p style="margin: 0 0 0.5rem 0; color: #004085; font-weight: 600; font-size: 0.9rem;">
                                Datenschutz
                            </p>
                            <p style="margin: 0; color: #004085; font-size: 0.85rem; line-height: 1.5;">
                                Ihr Standort wird nur lokal auf Ihrem Gerät ermittelt und zur automatischen Zuordnung verwendet. Wir speichern keine präzisen Koordinaten ohne Ihre Zustimmung.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div style="display: flex; gap: 0.75rem;">
                    <button id="location-deny-btn" style="
                        flex: 1;
                        padding: 0.875rem 1.5rem;
                        background: white;
                        border: 2px solid #dee2e6;
                        border-radius: 8px;
                        color: #6c757d;
                        font-weight: 600;
                        font-size: 0.95rem;
                        cursor: pointer;
                        transition: all 0.2s ease;
                    " onmouseover="this.style.background='#f8f9fa'; this.style.borderColor='#adb5bd';" 
                       onmouseout="this.style.background='white'; this.style.borderColor='#dee2e6';">
                        Später
                    </button>
                    <button id="location-allow-btn" style="
                        flex: 1;
                        padding: 0.875rem 1.5rem;
                        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                        border: none;
                        border-radius: 8px;
                        color: white;
                        font-weight: 600;
                        font-size: 0.95rem;
                        cursor: pointer;
                        transition: all 0.2s ease;
                        box-shadow: 0 4px 12px rgba(0,123,255,0.3);
                    " onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 16px rgba(0,123,255,0.4)';" 
                       onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(0,123,255,0.3)';">
                        <i class="fas fa-check"></i> Erlauben
                    </button>
                </div>
            </div>
        `;
        
        document.body.appendChild(modal);
        
        // Event Handler
        document.getElementById('location-allow-btn').addEventListener('click', () => {
            console.log('✅ Standortberechtigung erteilt');
            modal.remove();
            resolve(true);
        });
        
        document.getElementById('location-deny-btn').addEventListener('click', () => {
            console.log('❌ Standortberechtigung verweigert');
            modal.remove();
            resolve(false);
        });
        
        // Klick außerhalb des Modals schließt es
        modal.addEventListener('click', (e) => {
            if (e.target === modal) {
                console.log('❌ Modal geschlossen (Klick außerhalb)');
                modal.remove();
                resolve(false);
            }
        });
    });
}

// CSS-Animationen hinzufügen (falls noch nicht vorhanden)
if (!document.getElementById('location-modal-styles')) {
    const style = document.createElement('style');
    style.id = 'location-modal-styles';
    style.textContent = `
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideUp {
            from {
                transform: translateY(30px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    `;
    document.head.appendChild(style);
}

// Modal anzeigen
console.log('📍 Standortberechtigungs-Modal wird angezeigt...');
showLocationPermissionModal().then(result => {
    console.log('Ergebnis:', result ? '✅ Erlaubt' : '❌ Verweigert');
});

// ============================================
// ALTERNATIVE: Einfacher Aufruf
// ============================================
// Du kannst auch einfach diese Zeile verwenden:
// showLocationPermissionModal();

