<?php
/**
 * Test: Prüft ob getGlobalInventory() alle Radsätze zurückgibt
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/resy_rest_api_complete.php';

header('Content-Type: text/html; charset=utf-8');

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Global Inventory Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .section { margin: 20px 0; padding: 15px; background: #f9f9f9; border-radius: 4px; }
        .success { color: #28a745; font-weight: bold; }
        .error { color: #dc3545; font-weight: bold; }
        .info { color: #17a2b8; }
        pre { background: #f5f5f5; padding: 10px; border-radius: 4px; overflow-x: auto; }
    </style>
</head>
<body>
<div class='container'>
    <h1>🔍 Global Inventory Test</h1>";

try {
    $autohausId = 1; // Test mit Autohaus 1
    $api = new ResyRestAPIComplete($autohausId);
    
    echo "<div class='section'>";
    echo "<h2>1. Global Inventory</h2>";
    
    $globalInventory = $api->getGlobalInventory();
    echo "<div class='info'>Anzahl Items: " . count($globalInventory) . "</div>";
    
    if (count($globalInventory) > 0) {
        echo "<h3>Erste 5 Items:</h3>";
        echo "<pre>" . print_r(array_slice($globalInventory, 0, 5), true) . "</pre>";
        
        // Zähle alle Radsätze
        $totalWheelsets = 0;
        foreach ($globalInventory as $item) {
            if (isset($item['inventoryNumbers']) && is_array($item['inventoryNumbers'])) {
                $totalWheelsets += count($item['inventoryNumbers']);
            }
        }
        echo "<div class='success'>Gesamt Radsätze in Global Inventory: {$totalWheelsets}</div>";
    } else {
        echo "<div class='error'>Global Inventory ist leer!</div>";
    }
    echo "</div>";
    
    echo "<div class='section'>";
    echo "<h2>2. Customer Inventory (Customer No: {$api->customerNo})</h2>";
    
    $customerInventory = $api->getInventory();
    echo "<div class='info'>Anzahl Items: " . count($customerInventory) . "</div>";
    
    if (count($customerInventory) > 0) {
        echo "<h3>Erste 5 Items:</h3>";
        echo "<pre>" . print_r(array_slice($customerInventory, 0, 5), true) . "</pre>";
        
        // Zähle alle Radsätze
        $totalWheelsets = 0;
        foreach ($customerInventory as $item) {
            if (isset($item['inventoryNumbers']) && is_array($item['inventoryNumbers'])) {
                $totalWheelsets += count($item['inventoryNumbers']);
            }
        }
        echo "<div class='success'>Gesamt Radsätze in Customer Inventory: {$totalWheelsets}</div>";
    } else {
        echo "<div class='error'>Customer Inventory ist leer!</div>";
    }
    echo "</div>";
    
    echo "<div class='section'>";
    echo "<h2>3. Vergleich: getAllWheelsetsSmart()</h2>";
    
    $wheelsets = $api->getAllWheelsetsSmart();
    echo "<div class='info'>Anzahl Radsätze: " . count($wheelsets) . "</div>";
    
    if (count($wheelsets) > 0) {
        echo "<h3>Gefundene Satznummern:</h3>";
        $numbers = [];
        foreach ($wheelsets as $ws) {
            $num = $ws['satznummer'] ?? $ws['wheelSetNumber'] ?? 'unbekannt';
            $numbers[] = $num;
        }
        echo "<div class='info'>" . implode(', ', $numbers) . "</div>";
    }
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='error'>Fehler: " . htmlspecialchars($e->getMessage()) . "</div>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

echo "</div></body></html>";
?>



