<?php
/**
 * Test: Versucht alle verfügbaren Radsätze zu finden
 * Prüft verschiedene Satznummern-Bereiche
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/resy_rest_api_complete.php';

$autohausId = 1;
$api = new ResyRestAPIComplete($autohausId);

echo "Suche nach verfügbaren Radsätzen...\n\n";

// Bekannte Satznummern
$knownNumbers = [103379, 103380, 103391, 103405, 103520];

// Prüfe bekannte Nummern
$found = [];
foreach ($knownNumbers as $num) {
    try {
        $details = $api->getWheelsetDetails($num);
        if ($details && !empty($details)) {
            $found[] = [
                'satznummer' => $num,
                'kennzeichen' => $details['licenseNo'] ?? '-',
                'vin' => $details['VIN'] ?? '-'
            ];
            echo "✓ {$num}: " . ($details['licenseNo'] ?? '-') . "\n";
        }
    } catch (Exception $e) {
        // Ignoriere Fehler
    }
}

echo "\nGefundene Radsätze: " . count($found) . "\n";
echo "Bekannte Nummern: " . count($knownNumbers) . "\n";
echo "Nicht gefunden: " . (count($knownNumbers) - count($found)) . "\n\n";

// Prüfe ob es weitere Radsätze in einem Bereich gibt
echo "Prüfe Bereich 103000-104000...\n";
$rangeFound = [];
$testRange = range(103000, 103600, 10); // Prüfe jeden 10. Wert für Performance

foreach ($testRange as $num) {
    try {
        $details = $api->getWheelsetDetails($num);
        if ($details && !empty($details)) {
            $rangeFound[] = [
                'satznummer' => $num,
                'kennzeichen' => $details['licenseNo'] ?? '-',
                'vin' => $details['VIN'] ?? '-'
            ];
            echo "✓ {$num}: " . ($details['licenseNo'] ?? '-') . "\n";
        }
    } catch (Exception $e) {
        // Ignoriere Fehler
    }
}

echo "\nIm Bereich gefunden: " . count($rangeFound) . "\n";
?>



