<?php
/**
 * Einfache Database Updates
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "=== DATABASE UPDATES ANWENDEN ===\n";
    
    // 1. E-Mail-Templates Tabelle
    $conn->exec("CREATE TABLE IF NOT EXISTS email_templates (
        id INT AUTO_INCREMENT PRIMARY KEY,
        template_key VARCHAR(100) UNIQUE NOT NULL,
        subject VARCHAR(255) NOT NULL,
        body TEXT NOT NULL,
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    echo "✅ E-Mail-Templates Tabelle erstellt\n";
    
    // 2. E-Mail-Logs Tabelle
    $conn->exec("CREATE TABLE IF NOT EXISTS email_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        appointment_id INT,
        template_key VARCHAR(100),
        recipient_email VARCHAR(255),
        subject VARCHAR(255),
        status ENUM('sent', 'failed', 'pending') DEFAULT 'pending',
        sent_at DATETIME NULL,
        error_message TEXT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (appointment_id) REFERENCES appointments(id) ON DELETE CASCADE
    )");
    echo "✅ E-Mail-Logs Tabelle erstellt\n";
    
    // 3. Spalten zu appointments hinzufügen (falls nicht vorhanden)
    $columns_to_add = [
        'status' => "ENUM('pending', 'booked', 'vorbereitet', 'completed', 'cancelled', 'rejected') DEFAULT 'pending'",
        'admin_notes' => 'TEXT NULL',
        'approved_by' => 'INT NULL',
        'approved_at' => 'DATETIME NULL',
        'reminder_sent' => 'BOOLEAN DEFAULT FALSE',
        'reminder_sent_at' => 'DATETIME NULL',
        'source' => "ENUM('website', 'hellomateo', 'admin') DEFAULT 'website'"
    ];
    
    foreach ($columns_to_add as $column => $definition) {
        try {
            $conn->exec("ALTER TABLE appointments ADD COLUMN $column $definition");
            echo "✅ Spalte '$column' hinzugefügt\n";
        } catch (Exception $e) {
            if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
                echo "ℹ️  Spalte '$column' bereits vorhanden\n";
            } else {
                echo "❌ Fehler bei Spalte '$column': " . $e->getMessage() . "\n";
            }
        }
    }
    
    // 4. E-Mail-Templates einfügen
    $templates = [
        ['appointment_confirmation', 'Terminbestätigung - Boxenstop', 
         'Liebe/r {{customer_name}},

vielen Dank für Ihre Terminanfrage für den {{event_name}} am {{appointment_date}} um {{appointment_time}}.

Ihre Termindetails:
- Event: {{event_name}}
- Datum: {{appointment_date}}
- Zeit: {{appointment_time}}
- Kennzeichen: {{license_plate}}
- Services: {{services}}

Ihr Termin wird von unserem Team geprüft und bestätigt. Sie erhalten eine weitere E-Mail sobald der Termin bestätigt wurde.

Bei Fragen stehen wir Ihnen gerne zur Verfügung.

Mit freundlichen Grüßen
Ihr Boxenstop Team'],
        
        ['appointment_approved', 'Termin bestätigt - Boxenstop',
         'Liebe/r {{customer_name}},

Ihr Termin für den {{event_name}} am {{appointment_date}} um {{appointment_time}} wurde bestätigt!

Termindetails:
- Event: {{event_name}}
- Datum: {{appointment_date}}
- Zeit: {{appointment_time}}
- Kennzeichen: {{license_plate}}
- Services: {{services}}

Bitte erscheinen Sie pünktlich zum vereinbarten Termin.

Mit freundlichen Grüßen
Ihr Boxenstop Team'],
        
        ['appointment_reminder', 'Erinnerung: Ihr Termin morgen - Boxenstop',
         'Liebe/r {{customer_name}},

dies ist eine freundliche Erinnerung an Ihren Termin morgen:

Termindetails:
- Event: {{event_name}}
- Datum: {{appointment_date}}
- Zeit: {{appointment_time}}
- Kennzeichen: {{license_plate}}
- Services: {{services}}

Bitte erscheinen Sie pünktlich zum vereinbarten Termin.

Mit freundlichen Grüßen
Ihr Boxenstop Team'],
        
        ['appointment_rejected', 'Termin leider nicht verfügbar - Boxenstop',
         'Liebe/r {{customer_name}},

leider können wir Ihren gewünschten Termin für den {{event_name}} am {{appointment_date}} um {{appointment_time}} nicht bestätigen.

Grund: {{rejection_reason}}

Bitte wählen Sie einen anderen verfügbaren Termin aus.

Mit freundlichen Grüßen
Ihr Boxenstop Team']
    ];
    
    foreach ($templates as $template) {
        try {
            $stmt = $conn->prepare("INSERT IGNORE INTO email_templates (template_key, subject, body) VALUES (?, ?, ?)");
            $stmt->execute($template);
            echo "✅ Template '{$template[0]}' eingefügt\n";
        } catch (Exception $e) {
            echo "ℹ️  Template '{$template[0]}' bereits vorhanden\n";
        }
    }
    
    // 5. SMTP-Einstellungen hinzufügen
    $smtp_settings = [
        'email_smtp_host' => 'smtp-mail.outlook.com',
        'email_smtp_port' => '587',
        'email_smtp_username' => 'rentacar-kiel@be-automobile.de',
        'email_smtp_password' => 'W@050373011206af',
        'email_from' => 'rentacar-kiel@be-automobile.de',
        'email_from_name' => 'Boxenstop',
        'email_use_tls' => '1',
        'email_use_ssl' => '0'
    ];
    
    foreach ($smtp_settings as $key => $value) {
        try {
            $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt->execute([$key, $value, $value]);
            echo "✅ Einstellung '$key' gesetzt\n";
        } catch (Exception $e) {
            echo "ℹ️  Einstellung '$key' bereits vorhanden\n";
        }
    }
    
    echo "\n🎉 DATABASE UPDATES ERFOLGREICH ABGESCHLOSSEN!\n";
    
} catch (Exception $e) {
    echo "❌ Kritischer Fehler: " . $e->getMessage() . "\n";
}
?>
