<?php
/**
 * Erstellt p2_tire_offers Tabelle für P2 Reifenangebote
 * Ähnlich wie wheelset_offers, aber für P2 API
 */

require_once 'config/database.php';

$sql = "
CREATE TABLE IF NOT EXISTS p2_tire_offers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kunden_adr_id INT NOT NULL,
    autohaus_id INT NOT NULL,
    customer_name VARCHAR(255),
    customer_vorname VARCHAR(255),
    license_plate VARCHAR(20),
    vin VARCHAR(50),
    auftrag_nr INT,
    offer_data TEXT,
    letter_content TEXT,
    employee_name VARCHAR(255),
    token VARCHAR(64) UNIQUE,
    token_expires_at DATETIME,
    token_used_at DATETIME,
    email_sent TINYINT(1) DEFAULT 0,
    email_sent_at DATETIME,
    pdf_filename VARCHAR(255),
    status ENUM('draft', 'sent', 'accepted', 'declined', 'new_request', 'viewed', 'processed') DEFAULT 'draft',
    customer_selection TEXT,
    total_amount DECIMAL(10,2) DEFAULT 0.00,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_kunden_adr_id (kunden_adr_id),
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_license_plate (license_plate),
    INDEX idx_auftrag_nr (auftrag_nr),
    INDEX idx_status (status),
    INDEX idx_token (token),
    INDEX idx_created_at (created_at),
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE,
    FOREIGN KEY (created_by) REFERENCES admin_users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
";

try {
    $db = new Database();
    $pdo = $db->getConnection();
    $pdo->exec($sql);
    echo "✅ Tabelle p2_tire_offers wurde erstellt!\n";
    
    // Prüfe ob Tabelle existiert
    $stmt = $pdo->query("SHOW TABLES LIKE 'p2_tire_offers'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabelle existiert in der Datenbank\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}

