<?php
/**
 * Setup-Skript für Feedback-Tabelle
 * Führt die SQL-Datei aus oder erstellt die Tabelle direkt
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "=== Feedback-Tabelle Setup ===\n\n";
    
    // Prüfe ob Tabelle bereits existiert
    $checkTable = $conn->query("SHOW TABLES LIKE 'feedback'");
    if ($checkTable->rowCount() > 0) {
        echo "✅ Feedback-Tabelle existiert bereits.\n";
        echo "Spalten:\n";
        $columns = $conn->query("DESCRIBE feedback");
        while ($col = $columns->fetch(PDO::FETCH_ASSOC)) {
            echo "  - {$col['Field']} ({$col['Type']})\n";
        }
    } else {
        echo "📝 Erstelle Feedback-Tabelle...\n";
        
        // Tabelle erstellen
        $conn->exec("
            CREATE TABLE feedback (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id INT NULL,
                autohaus_id INT NULL,
                rating INT NOT NULL,
                feedback_text TEXT NOT NULL,
                feedback_type ENUM('service', 'booking', 'general') DEFAULT 'general',
                page_url VARCHAR(500) NULL,
                is_anonymous BOOLEAN DEFAULT FALSE,
                status ENUM('new', 'read', 'archived') DEFAULT 'new',
                admin_response TEXT NULL,
                admin_response_by INT NULL,
                admin_response_at DATETIME NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                INDEX idx_user_id (user_id),
                INDEX idx_autohaus_id (autohaus_id),
                INDEX idx_status (status),
                INDEX idx_created_at (created_at),
                INDEX idx_feedback_type (feedback_type)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ");
        
        echo "✅ Feedback-Tabelle erfolgreich erstellt!\n";
    }
    
    echo "\n=== Setup abgeschlossen ===\n";
    
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    echo "Error Code: " . $e->getCode() . "\n";
    if ($e->errorInfo) {
        echo "Error Info: " . print_r($e->errorInfo, true) . "\n";
    }
    exit(1);
}









