<?php
/**
 * Setup Script für Feedback Audit Log Tabelle
 * Führt das SQL-Script aus, um die feedback_audit_log Tabelle zu erstellen
 */

require_once __DIR__ . '/config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Lese SQL-Datei
    $sqlFile = __DIR__ . '/database/create_feedback_audit_log.sql';
    
    if (!file_exists($sqlFile)) {
        die("❌ SQL-Datei nicht gefunden: $sqlFile\n");
    }
    
    $sql = file_get_contents($sqlFile);
    
    // Entferne Kommentare und führe SQL aus
    $sql = preg_replace('/--.*$/m', '', $sql);
    $sql = preg_replace('/\/\*.*?\*\//s', '', $sql);
    
    // Führe SQL-Befehle aus
    $conn->exec($sql);
    
    echo "✅ Feedback Audit Log Tabelle erfolgreich erstellt!\n";
    echo "Die Tabelle 'feedback_audit_log' ist jetzt verfügbar.\n";
    
} catch (PDOException $e) {
    echo "❌ Fehler beim Erstellen der Tabelle: " . $e->getMessage() . "\n";
    echo "SQL Error Code: " . $e->getCode() . "\n";
}









