import type { Graph } from './graph.js';
import type { GraphNode } from './graph-node.js';
import type { GraphEdge } from './graph-edge.js';
export interface BaseEvent {
    type: string;
    [attachment: string]: unknown;
}
export interface GraphEvent extends BaseEvent {
    target: Graph<GraphNode>;
}
export interface GraphNodeEvent extends BaseEvent {
    target: GraphNode;
}
export interface GraphEdgeEvent extends BaseEvent {
    target: GraphEdge<GraphNode, GraphNode>;
}
export type EventListener<E> = (event: E) => void;
export declare class EventDispatcher<T extends BaseEvent> {
    private _listeners;
    addEventListener(type: string, listener: EventListener<T>): this;
    removeEventListener(type: string, listener: EventListener<T>): this;
    dispatchEvent(event: T): this;
    dispose(): void;
}
