import { type Accessor, Document, type GLTF, Primitive, type Property, type Texture, type Transform, type TransformContext, type vec2 } from '@gltf-transform/core';
import type { NdArray } from 'ndarray';
/**
 * Prepares a function used in an {@link Document#transform} pipeline. Use of this wrapper is
 * optional, and plain functions may be used in transform pipelines just as well. The wrapper is
 * used internally so earlier pipeline stages can detect and optimize based on later stages.
 * @hidden
 */
export declare function createTransform(name: string, fn: Transform): Transform;
/** @hidden */
export declare function isTransformPending(context: TransformContext | undefined, initial: string, pending: string): boolean;
/**
 * Performs a shallow merge on an 'options' object and a 'defaults' object.
 * Equivalent to `{...defaults, ...options}` _except_ that `undefined` values
 * in the 'options' object are ignored.
 *
 * @hidden
 */
export declare function assignDefaults<Defaults, Options>(defaults: Defaults, options: Options): Defaults & Options;
/**
 * Maps pixels from source to target textures, with a per-pixel callback.
 * @hidden
 */
export declare function rewriteTexture(source: Texture, target: Texture, fn: (pixels: NdArray, i: number, j: number) => void): Promise<Texture | null>;
/** @hidden */
export declare function getGLPrimitiveCount(prim: Primitive): number;
/** @hidden */
export declare class SetMap<K, V> {
    private _map;
    get size(): number;
    has(k: K): boolean;
    add(k: K, v: V): this;
    get(k: K): Set<V>;
    keys(): Iterable<K>;
}
/** @hidden */
export declare function formatBytes(bytes: number, decimals?: number): string;
/** @hidden */
export declare function formatLong(x: number): string;
/** @hidden */
export declare function formatDelta(a: number, b: number, decimals?: number): string;
/** @hidden */
export declare function formatDeltaOp(a: number, b: number): string;
/**
 * Returns a list of all unique vertex attributes on the given primitive and
 * its morph targets.
 * @hidden
 */
export declare function deepListAttributes(prim: Primitive): Accessor[];
/** @hidden */
export declare function deepSwapAttribute(prim: Primitive, src: Accessor, dst: Accessor): void;
/**
 * Disposes of a {@link Primitive} and any {@link Accessor Accesors} for which
 * it is the last remaining parent.
 * @hidden
 */
export declare function deepDisposePrimitive(prim: Primitive): void;
/** @hidden */
export declare function shallowEqualsArray(a: ArrayLike<unknown> | null, b: ArrayLike<unknown> | null): boolean;
/** Clones an {@link Accessor} without creating a copy of its underlying TypedArray data. */
export declare function shallowCloneAccessor(document: Document, accessor: Accessor): Accessor;
/** @hidden */
export declare function createIndices(count: number, maxIndex?: number): Uint16Array | Uint32Array;
/** @hidden */
export declare function createIndicesEmpty(count: number, maxIndex?: number): Uint16Array | Uint32Array;
/** @hidden */
export declare function isUsed(prop: Property): boolean;
/** @hidden */
export declare function isEmptyObject(object: Record<string, unknown>): boolean;
/**
 * Creates a unique key associated with the structure and draw call characteristics of
 * a {@link Primitive}, independent of its vertex content. Helper method, used to
 * identify candidate Primitives for joining.
 * @hidden
 */
export declare function createPrimGroupKey(prim: Primitive): string;
/**
 * Scales `size` NxN dimensions to fit within `limit` NxN dimensions, without
 * changing aspect ratio. If `size` <= `limit` in all dimensions, returns `size`.
 * @hidden
 */
export declare function fitWithin(size: vec2, limit: vec2): vec2;
type ResizePreset = 'nearest-pot' | 'ceil-pot' | 'floor-pot';
/**
 * Scales `size` NxN dimensions to the specified power of two.
 * @hidden
 */
export declare function fitPowerOfTwo(size: vec2, method: ResizePreset): vec2;
export declare function floorPowerOfTwo(value: number): number;
export declare function ceilPowerOfTwo(value: number): number;
/**
 * Mapping from any glTF primitive mode to its equivalent basic mode, as returned by
 * {@link convertPrimitiveMode}.
 * @hidden
 */
export declare const BASIC_MODE_MAPPING: Record<GLTF.MeshPrimitiveMode, GLTF.MeshPrimitiveMode>;
export {};
