import { type Transform } from '@gltf-transform/core';
export interface InstanceOptions {
    /** Minimum number of meshes considered eligible for instancing. Default: 5. */
    min?: number;
}
export declare const INSTANCE_DEFAULTS: Required<InstanceOptions>;
/**
 * Creates GPU instances (with {@link EXTMeshGPUInstancing}) for shared {@link Mesh} references. In
 * engines supporting the extension, reused Meshes will be drawn with GPU instancing, greatly
 * reducing draw calls and improving performance in many cases. If you're not sure that identical
 * Meshes share vertex data and materials ("linked duplicates"), run {@link dedup} first to link them.
 *
 * Example:
 *
 * ```javascript
 * import { dedup, instance } from '@gltf-transform/functions';
 *
 * await document.transform(
 * 	dedup(),
 * 	instance({min: 5}),
 * );
 * ```
 *
 * @category Transforms
 */
export declare function instance(_options?: InstanceOptions): Transform;
