import { Primitive } from '@gltf-transform/core';
/**
 * Converts a LINE_STRIP or LINE_LOOP {@link Primitive} to LINES, which is
 * more widely supported. Any other topology given as input (points or
 * triangles) will throw an error.
 *
 * Example:
 *
 * ```javascript
 * import { convertPrimitiveToLines } from '@gltf-transform/functions';
 *
 * console.log(prim.getMode()); // 2 (LINE_LOOP)
 * convertPrimitiveToLines(prim);
 * console.log(prim.getMode()); // 1 (LINES)
 * ```
 */
export declare function convertPrimitiveToLines(prim: Primitive): void;
/**
 * Converts a TRIANGLE_STRIP or TRIANGLE_LOOP {@link Primitive} to TRIANGLES,
 * which is more widely supported. Any other topology given as input (points or
 * lines) will throw an error.
 *
 * Example:
 *
 * ```javascript
 * import { convertPrimitiveToTriangles } from '@gltf-transform/functions';
 *
 * console.log(prim.getMode()); // 5 (TRIANGLE_STRIP)
 * convertPrimitiveToTriangles(prim);
 * console.log(prim.getMode()); // 4 (TRIANGLES)
 * ```
 */
export declare function convertPrimitiveToTriangles(prim: Primitive): void;
