import { type ILogger, type Transform, type vec2 } from '@gltf-transform/core';
import { TextureResizeFilter } from '@gltf-transform/functions';
/**********************************************************************************************
 * Interfaces.
 */
export declare const Mode: {
    ETC1S: string;
    UASTC: string;
};
export declare const Filter: {
    BOX: string;
    TENT: string;
    BELL: string;
    BSPLINE: string;
    MITCHELL: string;
    LANCZOS3: string;
    LANCZOS4: string;
    LANCZOS6: string;
    LANCZOS12: string;
    BLACKMAN: string;
    KAISER: string;
    GAUSSIAN: string;
    CATMULLROM: string;
    QUADRATIC_INTERP: string;
    QUADRATIC_APPROX: string;
    QUADRATIC_MIX: string;
};
interface GlobalOptions {
    /** Instance of the Sharp encoder, required if resizing textures. */
    encoder: unknown;
    mode: string;
    /** Pattern identifying textures to compress, matched to name or URI. */
    pattern?: RegExp | null;
    /**
     * Pattern matching the material texture slot(s) to be compressed or converted.
     * Passing a string (glob) is deprecated; use a RegExp instead.
     */
    slots?: RegExp | null;
    /** Interpolation used for generating mipmaps. Default: 'lanczos4'. */
    filter?: string;
    filterScale?: number;
    resize?: vec2 | 'nearest-pot' | 'ceil-pot' | 'floor-pot';
    /** Interpolation used if resizing. Default: TextureResizeFilter.LANCZOS3. */
    resizeFilter?: TextureResizeFilter;
    jobs?: number;
    /**
     * Whether to clean up temporary files created during texture compression. See
     * verbose log output for temporary file paths. Default: true.
     */
    cleanup?: boolean;
    /**
     * Attempts to avoid processing images that could exceed memory or other other
     * limits, throwing an error instead. Default: true.
     * @experimental
     */
    limitInputPixels?: boolean;
}
export interface ETC1SOptions extends GlobalOptions {
    quality?: number;
    compression?: number;
    maxEndpoints?: number;
    maxSelectors?: number;
    rdo?: boolean;
    rdoThreshold?: number;
}
export interface UASTCOptions extends GlobalOptions {
    level?: number;
    rdo?: boolean;
    rdoLambda?: number;
    rdoDictionarySize?: number;
    rdoBlockScale?: number;
    rdoStdDev?: number;
    rdoMultithreading?: boolean;
    zstd?: number;
}
export declare const ETC1S_DEFAULTS: Omit<ETC1SOptions, 'encoder' | 'mode'>;
export declare const UASTC_DEFAULTS: Omit<UASTCOptions, 'encoder' | 'mode'>;
/**********************************************************************************************
 * Implementation.
 */
export declare const toktx: (options: ETC1SOptions | UASTCOptions) => Transform;
export declare function checkKTXSoftware(logger: ILogger): Promise<string>;
export {};
