import { type NodeIO, type Transform } from '@gltf-transform/core';
import type { Logger } from './program.js';
/** Helper class for managing a CLI command session. */
export declare class Session {
    private _io;
    private _logger;
    private _input;
    private _output;
    private _outputFormat;
    private _display;
    constructor(_io: NodeIO, _logger: Logger, _input: string, _output: string);
    static create(io: NodeIO, logger: Logger, input: unknown, output: unknown): Session;
    setDisplay(display: boolean): this;
    transform(...transforms: Transform[]): Promise<void>;
}
