/**
 * @packageDocumentation
 * @internal
 */
import type { ParserTypes, Argument, Option } from "../types.js";
import { CaporalValidator } from "../types.js";
export { CaporalValidator };
export declare function validateWithCaporal(validator: CaporalValidator, value: ParserTypes | ParserTypes[], context: Argument | Option, skipArrayValidation?: boolean): ParserTypes | ParserTypes[];
/**
 * The string validator actually just cast the value to string
 *
 * @param value
 * @ignore
 */
export declare function validateBoolFlag(value: ParserTypes, context: Argument | Option): boolean;
export declare function validateNumericFlag(validator: number, value: ParserTypes, context: Argument | Option): number;
export declare function validateArrayFlag(validator: number, value: ParserTypes | ParserTypes[], context: Argument | Option): ParserTypes | ParserTypes[];
/**
 * The string validator actually just cast the value to string
 *
 * @param value
 * @ignore
 */
export declare function validateStringFlag(value: ParserTypes | ParserTypes[]): string;
