/**
 * @packageDocumentation
 * @internal
 */
import type { OptionSynopsis, ParserTypes } from "../types.js";
export declare function getCleanNameFromNotation(str: string, camelCased?: boolean): string;
export declare function getDashedOpt(name: string): string;
export declare function isNumeric(n: string): boolean;
export declare function isOptionStr(str?: string): str is string;
export declare function isConcatenatedOpt(str: string): string[] | false;
export declare function isNegativeOpt(opt: string): boolean;
export declare function isOptArray(flag: ParserTypes | ParserTypes[]): flag is ParserTypes[];
export declare function formatOptName(name: string): string;
/**
 * Parse a option synopsis
 *
 * @example
 * parseSynopsis("-f, --file <path>")
 * // Returns...
 * {
 *    longName: 'file',
 *    longNotation: '--file',
 *    shortNotation: '-f',
 *    shortName: 'f'
 *    valueType: 0, // 0 = optional, 1 = required, 2 = no value
 *    variadic: false
 *    name: 'file'
 *    notation: '--file' // either the long or short notation
 * }
 *
 * @param synopsis
 * @ignore
 */
export declare function parseOptionSynopsis(synopsis: string): OptionSynopsis;
