/**
 * @packageDocumentation
 * @module caporal/option
 */
import { Option, CreateOptionProgramOpts, CreateOptionCommandOpts, Action, GlobalOptions, ParserProcessedResult } from "../types.js";
import type { Command } from "../command/index.js";
import type { Program } from "../program/index.js";
/**
 * Create an Option object
 *
 * @internal
 * @param synopsis
 * @param description
 * @param options
 */
export declare function createOption(synopsis: string, description: string, options?: CreateOptionProgramOpts | CreateOptionCommandOpts): Option;
export { showHelp };
/**
 * Display help. Return false to prevent further processing.
 *
 * @internal
 */
declare const showHelp: Action;
/**
 * Get the list of registered global flags
 *
 * @internal
 */
export declare function getGlobalOptions(): GlobalOptions;
export declare function resetGlobalOptions(): GlobalOptions;
/**
 * Disable a global option
 *
 * @param name Can be the option short/long name or notation
 */
export declare function disableGlobalOption(name: string): boolean;
/**
 * Add a global option to the program.
 * A global option is available at the program level,
 * and associated with one given {@link Action}.
 *
 * @param a {@link Option} instance, for example created using {@link createOption()}
 */
export declare function addGlobalOption(opt: Option, action?: Action): GlobalOptions;
/**
 * Process global options, if any
 * @internal
 */
export declare function processGlobalOptions(parsed: ParserProcessedResult, program: Program, command?: Command): Promise<boolean>;
/**
 * Find a global Option action from the option name (short or long)
 *
 * @param name Short or long name
 * @internal
 */
export declare function findGlobalOptAction(name: string): Action | undefined;
/**
 * Find a global Option by it's name (short or long)
 *
 * @param name Short or long name
 * @internal
 */
export declare function findGlobalOption(name: string): Option | undefined;
export declare function isOptionObject(obj: unknown): obj is Option;
