/**
 * @packageDocumentation
 * @internal
 */
import { BaseError } from "./base.js";
import { Validator, ParserTypes, Argument, Option } from "../types.js";
interface ValidationErrorParameters {
    value: ParserTypes | ParserTypes[];
    error?: Error | string;
    validator: Validator;
    context: Argument | Option;
}
export declare class ValidationError extends BaseError {
    constructor({ value, error, validator, context }: ValidationErrorParameters);
}
export {};
