/**
 * @packageDocumentation
 * @internal
 */
import { BaseError } from "../error/index.js";
import type { ArgumentsRange, ParsedArguments, ParsedArgumentsObject } from "../types.js";
import type { Command } from "../command/index.js";
/**
 * Get the number of required argument for a given command
 *
 * @param cmd
 */
export declare function getRequiredArgsCount(cmd: Command): number;
export declare function getArgsObjectFromArray(cmd: Command, args: ParsedArguments): ParsedArgumentsObject;
/**
 * Check if the given command has at leat one variadic argument
 *
 * @param cmd
 */
export declare function hasVariadicArgument(cmd: Command): boolean;
export declare function getArgsRange(cmd: Command): ArgumentsRange;
export declare function checkRequiredArgs(cmd: Command, args: ParsedArgumentsObject, parsedArgv: ParsedArguments): BaseError[];
export declare function removeCommandFromArgs(cmd: Command, args: ParsedArguments): ParsedArguments;
interface ArgsValidationResult {
    args: ParsedArgumentsObject;
    errors: BaseError[];
}
/**
 *
 * @param cmd
 * @param parsedArgv
 *
 * @todo Bugs:
 *
 *
 * ts-node examples/pizza/pizza.ts cancel my-order jhazd hazd
 *
 * -> result ok, should be too many arguments
 *
 */
export declare function validateArgs(cmd: Command, parsedArgv: ParsedArguments): Promise<ArgsValidationResult>;
export {};
