<?php
/**
 * Neue RESY-Suchfunktion basierend auf dem aktualisierten System
 * Entwickelt eine Suchfunktion, die das neue RESY-System richtig versteht
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== NEUE RESY-SUCHFUNKTION ENTWICKLUNG ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'test_lgs_id' => '9877038'
];

try {
    // Verwende die gleiche cURL-Instanz für Login und Suche
    $ch = curl_init();
    
    // Login durchführen
    echo "--- Login durchführen ---\n";
    $loginUrl = $testConfig['base_url'] . '/index.php?m=login&a=login';
    
    // Lade Login-Seite
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_cookies_breakthrough.txt');
    curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies_breakthrough.txt');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Accept-Encoding: gzip, deflate, br',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1'
    ]);
    
    $loginPageResponse = curl_exec($ch);
    $loginPageCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if ($loginPageCode !== 200) {
        curl_close($ch);
        throw new Exception("Login-Seite nicht erreichbar: HTTP $loginPageCode");
    }
    
    echo "Login-Seite geladen: HTTP $loginPageCode\n";
    
    // Login-Daten senden
    $postData = [
        'FN' => 'login',
        'UserName' => $testConfig['username'],
        'Password' => $testConfig['password'],
        'button' => 'submit'
    ];
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Accept-Encoding: gzip, deflate, br',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $loginUrl
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $loginFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Login-Response: HTTP $loginCode, Final URL: $loginFinalUrl\n";
    
    // Prüfe Login-Erfolg
    $isLoginPage = strpos($loginResponse, 'Anmeldename') !== false ||
                   strpos($loginResponse, 'UserName') !== false ||
                   strpos($loginFinalUrl, 'login') !== false;
    
    if ($isLoginPage) {
        curl_close($ch);
        throw new Exception("Login fehlgeschlagen - immer noch auf Login-Seite");
    }
    
    echo "✅ Login erfolgreich!\n";
    
    // Teste verschiedene Such-URLs mit derselben cURL-Instanz
    echo "\n--- Teste verschiedene Such-URLs ---\n";
    
    $searchVariations = [
        // Originale URL-Struktur
        'original' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&button=submit&FN=WheelsetSearch',
        
        // Ohne button Parameter
        'no_button' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&FN=WheelsetSearch',
        
        // Ohne FN Parameter
        'no_fn' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&button=submit',
        
        // Nur LGS_ID
        'only_lgs_id' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'],
        
        // Mit anderen Parameternamen
        'alt_param_1' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&search_id=' . $testConfig['test_lgs_id'],
        'alt_param_2' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&id=' . $testConfig['test_lgs_id'],
        'alt_param_3' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&number=' . $testConfig['test_lgs_id'],
        
        // Andere Module
        'module_search' => $testConfig['base_url'] . '/index.php?m=search&a=wheelset&LGS_ID=' . $testConfig['test_lgs_id'],
        'module_find' => $testConfig['base_url'] . '/index.php?m=find&a=wheelset&LGS_ID=' . $testConfig['test_lgs_id'],
        
        // Direkte Detailseite
        'direct_detail' => $testConfig['base_url'] . '/index.php?m=wheelset&a=edit&LGS_ID=' . $testConfig['test_lgs_id'],
        'direct_view' => $testConfig['base_url'] . '/index.php?m=wheelset&a=view&LGS_ID=' . $testConfig['test_lgs_id'],
    ];
    
    foreach ($searchVariations as $name => $url) {
        echo "Teste: $name\n";
        echo "URL: $url\n";
        
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, null);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Upgrade-Insecure-Requests: 1',
            'Referer: ' . $loginFinalUrl
        ]);
        
        $searchResponse = curl_exec($ch);
        $searchCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $searchFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
        
        echo "Response Code: " . $searchCode . "\n";
        echo "Final URL: " . $searchFinalUrl . "\n";
        echo "Content Length: " . strlen($searchResponse) . " Zeichen\n";
        
        // Analysiere den Inhalt
        $hasLoginForm = strpos($searchResponse, 'Anmeldename') !== false;
        $hasWheelsetData = strpos($searchResponse, 'WheelHALTERNAME') !== false || 
                          strpos($searchResponse, 'WheelKENNZEICHEN') !== false;
        $hasLgsId = strpos($searchResponse, 'LGS_ID') !== false;
        $hasSearchForm = strpos($searchResponse, 'search') !== false;
        
        echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
        echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
        echo "Enthält LGS_ID: " . ($hasLgsId ? 'Ja' : 'Nein') . "\n";
        echo "Enthält Such-Form: " . ($hasSearchForm ? 'Ja' : 'Nein') . "\n";
        
        if ($hasWheelsetData) {
            echo "🎉 ERFOLG! Wheelset-Daten gefunden!\n";
            
            // Speichere die erfolgreiche Antwort
            file_put_contents(sys_get_temp_dir() . "/resy_success_$name.html", $searchResponse);
            echo "Erfolgreiche Antwort gespeichert in: " . sys_get_temp_dir() . "/resy_success_$name.html\n";
            
            // Extrahiere LGS_ID aus der Antwort
            if (preg_match('/LGS_ID=(\d+)/', $searchResponse, $matches)) {
                echo "Gefundene LGS_ID: " . $matches[1] . "\n";
            }
            
            break; // Stoppe bei erstem Erfolg
        }
        
        echo "\n";
    }
    
    curl_close($ch);
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== NEUE RESY-SUCHFUNKTION ENTWICKLUNG ABGESCHLOSSEN ===\n";
?>
