<?php
/**
 * Füge echte Testdaten hinzu (simuliert RESY-Daten)
 */

require_once 'config/database.php';

$db = new Database();
$pdo = $db->getConnection();

// Lösche alte Testdaten
$pdo->exec("DELETE FROM stored_wheelsets WHERE marke = 'Test' OR kennzeichen LIKE 'TEST%'");

// Füge echte Testdaten hinzu (wie sie von RESY kommen würden)
$testData = [
    ['TEST-AB123', 'Goodyear', 'Eagle F1 Asymmetric 5', '215/50R17 91Y'],
    ['TEST-CD456', 'Bridgestone', 'Potenza RE050', '225/45R18 91W'],
    ['TEST-EF789', 'Michelin', 'Pilot Sport 4', '235/40R18 91Y'],
    ['TEST-GH012', 'Continental', 'PremiumContact 6', '205/55R16 91H'],
    ['TEST-IJ345', 'Pirelli', 'Cinturato P7', '215/55R16 93H'],
    ['TEST-KL678', 'Dunlop', 'Sport Maxx RT2', '225/45R17 91W'],
    ['TEST-MN901', 'Hankook', 'Ventus Prime 3', '205/55R16 91V'],
    ['TEST-OP234', 'Yokohama', 'Advan Sport V105', '225/40R18 92Y'],
];

$count = 0;
foreach ($testData as $data) {
    $stmt = $pdo->prepare("
        INSERT INTO stored_wheelsets 
        (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
        VALUES (?, ?, ?, ?, ?, 'gelagert', NOW())
        ON DUPLICATE KEY UPDATE updated_at = NOW()
    ");
    
    $stmt->execute([
        1, // autohaus_id
        $data[0], // kennzeichen
        $data[1], // marke
        $data[2], // modell
        $data[3], // oe_nummer
    ]);
    
    $count++;
}

echo "✅ $count Test-Reifensätze eingefügt!\n\n";

// Zeige alle
$stmt = $pdo->query("SELECT kennzeichen, marke, modell FROM stored_wheelsets ORDER BY id DESC");
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Alle Reifensätze (" . count($results) . "):\n";
foreach ($results as $i => $r) {
    echo "  " . ($i+1) . ". " . ($r['kennzeichen'] ?: 'N/A') . " - " . $r['marke'] . " " . $r['modell'] . "\n";
}

