<?php
/**
 * Boxenstop - Volvo Autohaus Event Management
 * Hauptseite der Webapp
 */

session_start();
require_once 'config/database.php';
require_once 'includes/auth.php';

// Prüfen ob Einrichtung abgeschlossen ist
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'setup_completed'");

// Wartungsmodus prüfen
$stmt_maintenance = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'maintenance_mode'");
$stmt_maintenance->execute();
$maintenance_mode = $stmt_maintenance->fetchColumn();
if ($maintenance_mode === '1') {
    // Launch-Datum aus DB holen
    $stmt_launch = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date'");
    $stmt_launch->execute();
    $launch_date = $stmt_launch->fetchColumn();
    $stmt_text = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date_text'");
    $stmt_text->execute();
    $launch_date_text = trim($stmt_text->fetchColumn() ?: '');
    if ($launch_date) {
        $launch_date_disp = date('d.m.Y', strtotime($launch_date));
        $headline = "Die neue B&E Onlinewelt<br>kommt am <span class=\"launch-date\">$launch_date_disp</span>";
    } elseif ($launch_date_text) {
        $launch_date_disp = $launch_date_text;
        $headline = "Die neue B&E Onlinewelt<br><span class=\"launch-date\">$launch_date_text</span>";
    } else {
        $launch_date_disp = 'Frühjahr 2026';
        $headline = "Die neue B&E Onlinewelt<br><span class=\"launch-date\">Frühjahr 2026</span>";
    }
    $year = date('Y');
    echo <<<HTML
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bald verfügbar – B&E Gruppe </title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Volvo Shadow Guidelines - 5 Elevation Levels */
            --shadow-1: 0 1px 2px rgba(0, 0, 0, 0.1); /* Content switcher, Tabs */
            --shadow-2: 0 2px 4px rgba(0, 0, 0, 0.12); /* Buttons, Slider, Tooltip */
            --shadow-4: 0 4px 8px rgba(0, 0, 0, 0.15); /* Cards, Dropdown, Search fields, Snackbar */
            --shadow-8: 0 8px 16px rgba(0, 0, 0, 0.2); /* Dialog, Date picker, Time picker */
            --shadow-16: 0 16px 32px rgba(0, 0, 0, 0.25); /* Modal dialog */
        }
        
        /* Button Styles - Volvo Default (4px) */
        .btn,
        button.btn,
        .btn-primary,
        .btn-secondary,
        .btn-book,
        .event-btn,
        .nav-link {
            border-radius: 4px !important;
        }
        
        /* Volvo Design System Button Styles - Volvo Guidelines */
        .btn,
        button.btn {
            padding: 0.625rem 1.25rem;
            border: none;
            border-radius: 4px;
            font-size: 0.9rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            text-decoration: none;
            line-height: 1.5;
            font-family: inherit;
        }
        
        /* Button Style 4: Solid Blue (Primary) - Volvo Guidelines */
        .btn-primary,
        .btn-book,
        .event-btn {
            background: #0056b3;
            color: #ffffff;
            box-shadow: none;
        }
        
        .btn-primary:hover,
        .btn-primary:focus,
        .btn-book:hover,
        .btn-book:focus,
        .event-btn:hover,
        .event-btn:focus {
            background: #0066cc;
            color: #ffffff;
        }
        
        .btn-primary:active,
        .btn-book:active,
        .event-btn:active {
            background: #004c99;
            color: #ffffff;
        }
        
        .btn-primary:focus,
        .btn-book:focus,
        .event-btn:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        /* Button Style 2: Outlined (Secondary) - Volvo Guidelines */
        .btn-secondary {
            background: #ffffff;
            color: #1a1a1a;
            border: 1px solid #dee2e6;
            box-shadow: none;
        }
        
        .btn-secondary:hover,
        .btn-secondary:focus {
            background: #f8f9fa;
            color: #1a1a1a;
            border-color: #adb5bd;
        }
        
        .btn-secondary:active {
            background: #e9ecef;
            color: #1a1a1a;
            border-color: #6c757d;
        }
        
        .btn-secondary:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        /* Disabled State - Volvo Guidelines */
        .btn:disabled,
        button.btn:disabled,
        .btn-primary:disabled,
        .btn-secondary:disabled,
        .btn-book:disabled,
        .event-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none !important;
            box-shadow: none !important;
        }
        
        body{margin:0;padding:0;min-height:100vh;box-sizing:border-box;font-family:Inter,sans-serif;background:#222;}
        .hero-bg{position:fixed;top:0;left:0;width:100vw;height:100vh;object-fit:cover;z-index:0;filter:brightness(0.7);background-image:url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/StartseitenSliderimage-Desktop-1312x514_processed.jpg');background-size:cover;background-position:center;}
        .overlay{position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.45);z-index:1;}
        .center-box{position:relative;z-index:2;display:flex;flex-direction:column;align-items:center;justify-content:center;height:100vh;backdrop-filter:blur(4px);}
        .branding{display:flex;align-items:center;gap:1.5rem;margin-bottom:2rem;}
        .branding img{height:38px;}
        .headline{color:#fff;font-size:2.7rem;font-weight:700;text-align:center;margin-bottom:1rem;letter-spacing:0.01em;}
        .headline .launch-date{display:block;color:#25d366;font-size:1.3rem;font-weight:500;margin-top:0.5rem;}
        .subline{color:#e0e7ef;font-size:1.3rem;text-align:center;margin-bottom:2.2rem;}
        .cta-btn{background:#fff;color:#1a1a1a;font-weight:500;font-size:0.9rem;padding:0.625rem 1.25rem;border:1px solid #dee2e6;border-radius:4px;box-shadow:none;cursor:pointer;transition:all 0.2s cubic-bezier(0.4, 0, 0.2, 1);}
        .cta-btn:hover{background:#f8f9fa;border-color:#adb5bd;}
        .cta-btn:active{background:#e9ecef;border-color:#6c757d;}
        .cta-btn:focus{outline:2px solid #0056b3;outline-offset:2px;}
        .footer{color:#bbb;font-size:1rem;margin-top:2.5rem;text-align:center;}
        @media(max-width:700px){.headline{font-size:1.4rem;}.subline{font-size:1rem;}.branding img{height:28px;}}
        .modal-lead{display:none;position:fixed;z-index:1000;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.55);align-items:center;justify-content:center;}
        .modal-lead.active{display:flex;}
        .modal-lead-content{background:#fff;border-radius:8px;max-width:410px;width:92vw;padding:2.5rem 2rem;box-shadow:var(--shadow-16);display:flex;flex-direction:column;align-items:center;position:relative;}
        .modal-lead-content h2{color:#003057;font-size:1.7rem;margin-bottom:1.2rem;text-align:center;font-weight:700;letter-spacing:0.01em;}
        .modal-lead-content .launch-date-info{color:#25d366;font-size:1.08rem;margin-bottom:0.7rem;text-align:center;}
        .modal-lead-content form{width:100%;display:flex;flex-direction:column;gap:1.1rem;align-items:center;}
        .modal-lead-content input[type=email]{width:100%;padding:0.8rem 1.1rem;border-radius:4px;border:1.5px solid #b0b8c1;font-size:1.08rem;transition:border 0.2s;}
        .modal-lead-content input[type=email]:focus{border:1.5px solid #003057;outline:none;}
        .modal-lead-content button[type=submit]{background:#003057;color:#fff;font-weight:700;padding:0.8rem 1.7rem;border:none;border-radius:4px;font-size:1.08rem;cursor:pointer;box-shadow:var(--shadow-2);transition:background 0.2s;}
        .modal-lead-content button[type=submit]:hover{background:#0056b3;}
        .modal-lead-content .lead-success{display:none;color:#28a745;font-size:1.08rem;margin-top:0.7rem;text-align:center;}
        .modal-lead-content .lead-error{display:none;color:#d00;font-size:1.08rem;margin-top:0.7rem;text-align:center;}
        .modal-lead-content hr{width:80%;margin:1.7rem 0 1.1rem 0;border:0;border-top:1px solid #eee;}
        .modal-lead-content a{color:#003057;font-size:1.08rem;text-decoration:none;transition:color 0.2s;}
        .modal-lead-content a.whatsapp{display:inline-flex;align-items:center;margin-bottom:1.1rem;color:#25d366;font-weight:700;font-size:1.13rem;gap:0.5rem;}
        .modal-lead-content a.whatsapp img{height:24px;vertical-align:middle;margin-right:7px;}
        .modal-lead-content .calendar-btn{display:inline-flex;align-items:center;gap:0.7em;background:#003057;color:#fff;font-weight:700;font-size:1.13rem;padding:0.9em 1.7em;border-radius:4px;margin:1.1em 0 0.5em 0;text-decoration:none;box-shadow:var(--shadow-2);transition:background 0.2s, box-shadow 0.2s;animation:pulse 1.8s infinite;}
        .modal-lead-content .calendar-btn:hover{background:#0056b3;box-shadow:0 4px 20px #25d36644;}
        @keyframes pulse{0%{box-shadow:0 0 0 0 #25d36644;}70%{box-shadow:0 0 0 10px #25d36611;}100%{box-shadow:0 0 0 0 #25d36600;}}
        .modal-lead-content .close-btn{margin-top:1.7rem;background:none;border:none;color:#888;font-size:1.13rem;cursor:pointer;transition:color 0.2s;}
        .modal-lead-content .close-btn:hover{color:#003057;}
        .modal-lead-content .volvo-info{margin-top:1.2rem;color:#003057;font-size:0.98rem;text-align:center;opacity:0.85;}
        .modal-lead-content .volvo-logo-modal{height:32px;margin-bottom:1.1rem;}
    </style>
</head>
<body>
    <div class="hero-bg" aria-hidden="true"></div>
    <div class="overlay" aria-hidden="true"></div>
    <div class="center-box">
        <div class="branding">
            <img src="assets/images/BE-Logo-FINAL_Schwarz-1.png" alt="B&E Gruppe Logo">
            <span style="color:#fff;font-size:1.1rem;letter-spacing:0.1em;">B&E Gruppe</span>
        </div>
    <div class="headline">$headline</div>
    <div class="subline">Wir bereiten alles für Sie vor.<br>Freuen Sie sich auf exklusive Angebote, Serviceleistungen und Probefahrten!</div>
        <button class="cta-btn" onclick="openLeadModal()" aria-haspopup="dialog" aria-controls="lead-modal">Jetzt vormerken</button>
        <div class="footer">&copy; {$year} B&E Gruppe</div>
    </div>
    <div id="lead-modal" class="modal-lead" role="dialog" aria-modal="true" aria-labelledby="lead-modal-title">
        <div class="modal-lead-content">
            <img src="assets/images/BE-Logo-FINAL_Schwarz-1.png" alt="B&E Gruppe Logo" class="volvo-logo-modal">
            <h2 id="lead-modal-title">Jetzt vormerken</h2>
            <div class="launch-date-info">Geplanter Launch: <strong>$launch_date_disp</strong></div>
            <form id="lead-form" autocomplete="email">
                <input type="email" name="email" id="lead-email" placeholder="Ihre E-Mail-Adresse" required aria-label="E-Mail-Adresse">
                <button type="submit">Benachrichtigen lassen</button>
                <div class="lead-success" id="lead-success">Danke! Wir informieren Sie zum Start.</div>
                <div class="lead-error" id="lead-error"></div>
            </form>
            <hr>
            <a href="https://wa.me/?text=Ich%20m%C3%B6chte%20informiert%20werden%2C%20sobald%20die%20neue%20Volvo%20Onlinewelt%20live%20ist!" target="_blank" class="whatsapp" rel="noopener"><img src="/assets/images/whatsapp.svg" alt="WhatsApp"> Per WhatsApp vormerken</a>
            <a href="/download_ics.php" class="calendar-btn" tabindex="0">
                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="none" viewBox="0 0 24 24" style="margin-right:0.5em;"><rect x="3" y="5" width="18" height="16" rx="3" fill="#fff" stroke="#fff" stroke-width="2"/><rect x="3" y="5" width="18" height="16" rx="3" fill="none" stroke="#003057" stroke-width="2"/><path d="M8 3v4M16 3v4" stroke="#003057" stroke-width="2" stroke-linecap="round"/><rect x="7" y="10" width="2" height="2" rx="1" fill="#003057"/><rect x="11" y="10" width="2" height="2" rx="1" fill="#003057"/><rect x="15" y="10" width="2" height="2" rx="1" fill="#003057"/></svg>
                Kalendereintrag speichern
            </a>
            <div class="volvo-info">Ihre Daten werden ausschließlich für die Benachrichtigung zum Launch verwendet.<br>by Deniz Uludag</div>
            <button class="close-btn" onclick="closeLeadModal()">Schließen</button>
        </div>
    </div>
    <script>
        function openLeadModal(){document.getElementById('lead-modal').classList.add('active');document.getElementById('lead-email').focus();}
        function closeLeadModal(){document.getElementById('lead-modal').classList.remove('active');}
        document.addEventListener('DOMContentLoaded',function(){
            var form=document.getElementById('lead-form');
            if(form)form.onsubmit=function(e){
                e.preventDefault();
                var email=document.getElementById('lead-email').value.trim();
                var success=document.getElementById('lead-success');
                var error=document.getElementById('lead-error');
                success.style.display='none';
                error.style.display='none';
                if(!email.match(/^.+@.+\..+$/)){
                    error.textContent='Bitte gültige E-Mail eingeben.';
                    error.style.display='block';
                    return;
                }
                var xhr=new XMLHttpRequest();
                xhr.open('POST','/boxenstop/save_lead.php');
                xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
                xhr.onload=function(){
                    try{var res=JSON.parse(xhr.responseText);}catch(e){res={success:false,error:'Serverfehler'};}
                    if(res.success){
                        success.style.display='block';
                        form.reset();
                    }else{
                        error.textContent=res.error||'Fehler';
                        error.style.display='block';
                    }
                };
                xhr.send('email='+encodeURIComponent(email));
            };
            document.getElementById('lead-modal').onclick=function(e){if(e.target===this)closeLeadModal();};
        });
    </script>
</body>
</html>
HTML;
    exit;
}
$stmt->execute();
$setup_completed = $stmt->fetchColumn();

if (!$setup_completed) {
    header('Location: setup/');
    exit;
}

// Prüfe ob Multi-Autohaus-System aktiviert ist
$stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'multi_autohaus_enabled'");
$stmt->execute();
$multiAutohausEnabled = $stmt->fetchColumn();

// Autohäuser mit Event-Anzahl laden
$stmt = $conn->prepare("
    SELECT a.*, 
           COUNT(e.id) as event_count,
           COUNT(CASE WHEN e.event_date >= CURDATE() AND e.is_active = 1 THEN 1 END) as upcoming_events
    FROM autohaus a
    LEFT JOIN events e ON a.id = e.autohaus_id
    WHERE a.is_active = 1
    GROUP BY a.id, a.name, a.short_name, a.address, a.phone, a.email, a.footer_image, a.footer_image_alt
    ORDER BY a.name ASC
");
$stmt->execute();
$autohauser = $stmt->fetchAll();

// Aktive Events laden (mit Autohaus-Information)
$stmt = $conn->prepare("SELECT e.*, a.name as autohaus_name, a.short_name as autohaus_short_name,
    (SELECT COUNT(*) FROM appointments a WHERE a.event_id=e.id AND a.status IN ('booked','vorbereitet')) AS booked_count
  FROM events e 
  LEFT JOIN autohaus a ON e.autohaus_id = a.id
  WHERE e.is_active = 1 AND e.event_date >= CURDATE() 
  ORDER BY e.event_date ASC");
$stmt->execute();
$events = $stmt->fetchAll();

// Prüfe ob Autohaus-Auswahl erforderlich ist
$autohausSelectionRequired = false;
if ($multiAutohausEnabled) {
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'autohaus_selection_required'");
    $stmt->execute();
    $autohausSelectionRequired = $stmt->fetchColumn() == '1';
}

// Prüfe ob eingeloggter Benutzer ein bevorzugtes Autohaus hat
$userPreferredAutohaus = null;
$userPreferredAutohausId = null;
$userPreferredAutohausName = null;
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] && isset($_SESSION['user_id'])) {
    $current_user = getCurrentUser();
    if ($current_user && !empty($current_user['preferred_dealership_id'])) {
        $userPreferredAutohausId = (int)$current_user['preferred_dealership_id'];
        // Lade Autohaus-Details
        $stmt = $conn->prepare("SELECT id, name, short_name FROM autohaus WHERE id = ? AND is_active = 1");
        $stmt->execute([$userPreferredAutohausId]);
        $userPreferredAutohaus = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($userPreferredAutohaus) {
            $userPreferredAutohausName = $userPreferredAutohaus['name'];
        }
    }
}

// Aktuell ausgewähltes Autohaus für Footer bestimmen
$footerAutohaus = null;
$footerAutohausId = null;
$footerAutohausShortName = null;
$footerWhatsAppLink = null;
$footerImpressumLink = null;

// Prüfe zuerst Session, dann bevorzugtes Autohaus, dann erstes aktives Autohaus
if (isset($_SESSION['selected_autohaus_id'])) {
    $footerAutohausId = (int)$_SESSION['selected_autohaus_id'];
} elseif ($userPreferredAutohausId) {
    $footerAutohausId = $userPreferredAutohausId;
} elseif (!empty($autohauser)) {
    $footerAutohausId = (int)$autohauser[0]['id'];
}

// Lade Autohaus-Details für Footer
if ($footerAutohausId) {
    $stmt = $conn->prepare("SELECT id, name, short_name, phone, whatsapp_phone_number FROM autohaus WHERE id = ? AND is_active = 1");
    $stmt->execute([$footerAutohausId]);
    $footerAutohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($footerAutohaus) {
        $footerAutohausShortName = strtolower(trim($footerAutohaus['short_name']));
        
        // WhatsApp-Link generieren (aus whatsapp_phone_number oder phone)
        $whatsappPhone = !empty($footerAutohaus['whatsapp_phone_number']) 
            ? trim($footerAutohaus['whatsapp_phone_number']) 
            : trim($footerAutohaus['phone']);
        
        if (!empty($whatsappPhone)) {
            // Telefonnummer für WhatsApp formatieren (nur Ziffern und +)
            $whatsappPhoneClean = preg_replace('/[^0-9+]/', '', $whatsappPhone);
            // Entferne führende 0 und ersetze durch +49
            if (substr($whatsappPhoneClean, 0, 1) === '0') {
                $whatsappPhoneClean = '+49' . substr($whatsappPhoneClean, 1);
            } elseif (substr($whatsappPhoneClean, 0, 2) === '49' && substr($whatsappPhoneClean, 0, 1) !== '+') {
                $whatsappPhoneClean = '+' . $whatsappPhoneClean;
            } elseif (substr($whatsappPhoneClean, 0, 1) !== '+') {
                $whatsappPhoneClean = '+49' . $whatsappPhoneClean;
            }
            
            $footerWhatsAppLink = 'https://wa.me/' . $whatsappPhoneClean . '?text=' . urlencode('Hallo, ich habe eine Frage zu Ihren Services!');
        }
        
        // Impressum-Link generieren (basierend auf short_name)
        // Format: https://www.volvocars-haendler.de/b-und-e/{short_name}/impressum
        // Beispiel: Kiel -> https://www.volvocars-haendler.de/b-und-e/kiel/impressum
        if (!empty($footerAutohausShortName)) {
            $footerImpressumLink = 'https://www.volvocars-haendler.de/b-und-e/' . urlencode($footerAutohausShortName) . '/impressum';
        }
    }
}

// Unternehmensdaten aus den Einstellungen laden
$stmt = $conn->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('company_name', 'company_phone', 'company_email', 'company_address', 'company_logo', 'app_name')");
$stmt->execute();
$companySettings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Standardwerte setzen falls keine Einstellungen vorhanden
$companyName = $companySettings['company_name'] ?? 'B&E Gruppe';
$companyPhone = $companySettings['company_phone'] ?? '+49 (0) 123 456 789';
$companyEmail = $companySettings['company_email'] ?? 'info@volvo-autohaus.de';
$companyAddress = $companySettings['company_address'] ?? 'Musterstraße 123, 12345 Musterstadt';
$companyLogo = $companySettings['company_logo'] ?? 'assets/images/BE-Logo-FINAL_Schwarz-1.png';
// Entferne führenden Slash falls vorhanden
$companyLogo = ltrim($companyLogo, '/');
$appName = $companySettings['app_name'] ?? 'B&E Gruppe';
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <meta name="googlebot" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <meta name="bingbot" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#0056b3">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="<?php echo htmlspecialchars($appName); ?>">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="application-name" content="<?php echo htmlspecialchars($appName); ?>">
    <meta name="msapplication-TileColor" content="#0056b3">
    <meta name="msapplication-config" content="/browserconfig.xml">
    
    <title><?php echo htmlspecialchars($appName); ?> - B&E Gruppe</title>
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="manifest.json">
    
    <!-- Apple Touch Icons - iOS (180x180 ist Standard für moderne iOS-Geräte) -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon-precomposed" sizes="180x180" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/images/new-pwa_icon.png">
    
    <!-- Favicons - Alle Browser -->
    <link rel="icon" type="image/png" sizes="512x512" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="384x384" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="152x152" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="144x144" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="128x128" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="72x72" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="48x48" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/new-pwa_icon.png">
    <link rel="shortcut icon" href="assets/images/new-pwa_icon.png">
    <link rel="icon" href="assets/images/new-pwa_icon.png">
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/volvo-theme.css">
    
    <!-- Error Handling Script - MUSS SEHR FRÜH GELADEN WERDEN (im head) -->
    <script>
        (function() {
            'use strict';
            
            // Liste der gültigen MIME-Types für preload
            const validPreloadTypes = [
                'text/css', 'application/javascript', 'text/javascript',
                'font/woff', 'font/woff2', 'font/ttf', 'font/otf',
                'image/jpeg', 'image/jpg', 'image/png', 'image/webp', 'image/svg+xml',
                'video/mp4', 'video/webm', 'audio/mpeg', 'audio/ogg',
                'application/font-woff', 'application/font-woff2'
            ];
            
            // Prüfe ob ein type gültig ist
            function isValidPreloadType(type) {
                if (!type) return false;
                const lowerType = type.toLowerCase();
                return validPreloadTypes.some(valid => lowerType.includes(valid.toLowerCase()));
            }
            
            // Blockiere die Erstellung problematischer Links durch Überschreiben von createElement
            const originalCreateElement = document.createElement;
            document.createElement = function(tagName, options) {
                const element = originalCreateElement.call(this, tagName, options);
                
                // Wenn es ein LINK-Element ist, überwache setAttribute
                if (tagName.toLowerCase() === 'link') {
                    const originalSetAttribute = element.setAttribute;
                    element.setAttribute = function(name, value) {
                        // Wenn rel="preload" gesetzt wird, prüfe sofort
                        if (name.toLowerCase() === 'rel' && value && value.toLowerCase().includes('preload')) {
                            // Prüfe type-Attribut
                            const type = element.getAttribute('type');
                            const href = element.getAttribute('href') || '';
                            
                            // Wenn type ungültig oder fehlt, entferne das Element sofort
                            if (!type || !isValidPreloadType(type) || 
                                href.includes('supabase') || href.includes('contact-widget')) {
                                // Verhindere das Hinzufügen zum DOM
                                setTimeout(() => {
                                    if (element.parentNode) {
                                        element.remove();
                                    }
                                }, 0);
                                return; // Setze rel nicht
                            }
                        }
                        
                        // Wenn type gesetzt wird und rel bereits preload ist
                        if (name.toLowerCase() === 'type') {
                            const rel = element.getAttribute('rel');
                            if (rel && rel.toLowerCase().includes('preload')) {
                                if (!value || !isValidPreloadType(value)) {
                                    setTimeout(() => {
                                        if (element.parentNode) {
                                            element.remove();
                                        }
                                    }, 0);
                                    return; // Setze type nicht
                                }
                            }
                        }
                        
                        return originalSetAttribute.call(this, name, value);
                    };
                }
                
                return element;
            };
            
            // Entferne ALLE problematischen preload-Links
            function removeBadPreloadLinks() {
                const links = document.querySelectorAll('link[rel="preload"], link[rel*="preload"]');
                links.forEach(link => {
                    const type = link.getAttribute('type');
                    const href = link.getAttribute('href') || '';
                    
                    // Entferne Links ohne type oder mit ungültigem type
                    if (!type || !isValidPreloadType(type) || 
                        href.includes('supabase') || href.includes('contact-widget')) {
                        link.remove();
                    }
                });
            }
            
            // MutationObserver mit höchster Priorität und sofortiger Reaktion
            const preloadObserver = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    mutation.addedNodes.forEach(function(node) {
                        if (node.nodeType === 1) {
                            if (node.tagName === 'LINK') {
                                const rel = node.getAttribute('rel');
                                if (rel && (rel === 'preload' || rel.includes('preload'))) {
                                    const type = node.getAttribute('type');
                                    const href = node.getAttribute('href') || '';
                                    
                                    if (!type || !isValidPreloadType(type) || 
                                        href.includes('supabase') || href.includes('contact-widget')) {
                                        // Entferne sofort, bevor Browser es verarbeitet
                                        node.remove();
                                        return;
                                    }
                                }
                            }
                            // Prüfe auch in childNodes
                            if (node.querySelectorAll) {
                                const badLinks = node.querySelectorAll('link[rel="preload"], link[rel*="preload"]');
                                badLinks.forEach(link => {
                                    const type = link.getAttribute('type');
                                    const href = link.getAttribute('href') || '';
                                    if (!type || !isValidPreloadType(type) || 
                                        href.includes('supabase') || href.includes('contact-widget')) {
                                        link.remove();
                                    }
                                });
                            }
                        }
                    });
                });
                // Zusätzliche Bereinigung nach Mutationen
                removeBadPreloadLinks();
            });
            
            // Starte sofort
            function initErrorHandling() {
                if (document.head) {
                    removeBadPreloadLinks();
                    preloadObserver.observe(document.head, { 
                        childList: true, 
                        subtree: true,
                        attributes: true,
                        attributeFilter: ['rel', 'type', 'href']
                    });
                } else {
                    const headCheck = setInterval(function() {
                        if (document.head) {
                            clearInterval(headCheck);
                            removeBadPreloadLinks();
                            preloadObserver.observe(document.head, { 
                                childList: true, 
                                subtree: true,
                                attributes: true,
                                attributeFilter: ['rel', 'type', 'href']
                            });
                        }
                    }, 1); // Sehr schnelle Prüfung
                }
            }
            
            // Starte sofort
            initErrorHandling();
            
            // Kontinuierliche Bereinigung
            const cleanupInterval = setInterval(removeBadPreloadLinks, 50);
            setTimeout(() => clearInterval(cleanupInterval), 5000); // Stoppe nach 5 Sekunden
            
            // Event-Listener für verschiedene Phasen
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    removeBadPreloadLinks();
                    initErrorHandling();
                });
            }
            
            window.addEventListener('load', function() {
                removeBadPreloadLinks();
                setTimeout(removeBadPreloadLinks, 50);
                setTimeout(removeBadPreloadLinks, 200);
                setTimeout(removeBadPreloadLinks, 500);
            });
            
            // Unterdrücke Console-Warnungen
            const originalWarn = console.warn;
            const originalError = console.error;
            console.warn = function(...args) {
                const message = args.join(' ');
                if (message.includes('preload') && 
                    (message.includes('unsupported') || 
                     message.includes('not used') || 
                     message.includes('type value'))) {
                    return;
                }
                originalWarn.apply(console, args);
            };
            console.error = function(...args) {
                const message = args.join(' ');
                if (message.includes('supabase.co/storage/v1/object/public/profile_images/') && 
                    message.includes('400')) {
                    return;
                }
                originalError.apply(console, args);
            };
            
            // Fehlerbehandlung für fehlende Profilbilder
            window.addEventListener('error', function(event) {
                if (event.target && event.target.tagName === 'IMG') {
                    const src = event.target.src || '';
                    if (src.includes('supabase.co/storage/v1/object/public/profile_images/')) {
                        event.preventDefault();
                        event.stopPropagation();
                        event.target.style.display = 'none';
                        event.target.onerror = null;
                        return false;
                    }
                }
            }, true);
            
            // Fetch-Interceptor für Bilder
            const originalFetch = window.fetch;
            window.fetch = function(...args) {
                const url = args[0];
                if (typeof url === 'string' && url.includes('supabase.co/storage/v1/object/public/profile_images/')) {
                    return originalFetch.apply(this, args).catch(function() {
                        return Promise.reject(new Error('Image not found (suppressed)'));
                    });
                }
                return originalFetch.apply(this, args);
            };
            
            // XMLHttpRequest-Interceptor
            const originalXHROpen = XMLHttpRequest.prototype.open;
            const originalXHRSend = XMLHttpRequest.prototype.send;
            XMLHttpRequest.prototype.open = function(method, url, ...rest) {
                this._url = url;
                return originalXHROpen.apply(this, [method, url, ...rest]);
            };
            XMLHttpRequest.prototype.send = function(...args) {
                if (this._url && this._url.includes('supabase.co/storage/v1/object/public/profile_images/')) {
                    this.addEventListener('error', function(e) {
                        e.stopPropagation();
                    }, true);
                    this.addEventListener('load', function() {
                        if (this.status === 400) {
                            this.dispatchEvent = function() {};
                        }
                    });
                }
                return originalXHRSend.apply(this, args);
            };
        })();
    </script>
    
    <style>
        /* Autohaus-Auswahl Styles */
        .autohaus-selection-section {
            padding: 4rem 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .autohaus-selection-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
            margin-top: 2rem;
        }
        
        .autohaus-selection-card {
            background: white;
            border-radius: 8px;
            padding: 2rem;
            box-shadow: var(--shadow-4);
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }
        
        .autohaus-selection-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-8);
            border-color: #007bff;
        }
        
        .autohaus-selection-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .autohaus-selection-card:hover::before {
            transform: scaleX(1);
        }
        
        .autohaus-card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1.5rem;
        }
        
        .autohaus-card-header h3 {
            margin: 0;
            color: #495057;
            font-size: 1.25rem;
            font-weight: 600;
        }
        
        .autohaus-short {
            background: #007bff;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 4px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .autohaus-card-info {
            margin-bottom: 1.5rem;
        }
        
        .autohaus-card-image {
            margin-bottom: 1.5rem;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .autohaus-card-info .info-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 0.75rem;
            color: #6c757d;
            font-size: 0.9rem;
        }
        
        .autohaus-card-info .info-item i {
            width: 16px;
            color: #007bff;
        }
        
        .autohaus-card-action {
            text-align: center;
            color: #007bff;
            font-size: 1.2rem;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .autohaus-selection-card:hover .autohaus-card-action {
            opacity: 1;
        }
        
        /* Autohaus-Filter */
        .autohaus-filter {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-top: 1rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        
        .autohaus-filter label {
            font-weight: 500;
            color: #495057;
            margin: 0;
        }
        
        .autohaus-filter select {
            padding: 0.5rem 1rem;
            border: 1px solid #ced4da;
            border-radius: 4px;
            background: white;
            font-size: 0.9rem;
            min-width: 200px;
        }
        
        /* Event-Autohaus-Info */
        .event-autohaus {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 0.5rem 0;
            padding: 0.5rem 0.75rem;
            background: #e3f2fd;
            border-radius: 4px;
            color: #1976d2;
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .event-autohaus i {
            color: #1976d2;
        }
        
        /* Animationen für Notifications */
        @keyframes slideInRight {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        @keyframes slideOutRight {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(100%);
                opacity: 0;
            }
        }
        
        /* Ausgewähltes Autohaus Info */
        .selected-autohaus-info {
            margin-top: 1rem;
        }
        
        .autohaus-info-badge {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: #e3f2fd;
            border: 1px solid #bbdefb;
            border-radius: 8px;
            color: #1976d2;
        }
        
        .autohaus-info-badge i {
            font-size: 1.2rem;
        }
        
        .autohaus-info-badge span {
            flex: 1;
            font-weight: 500;
        }
        
        .btn-change-autohaus {
            background: #1976d2;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.9rem;
            transition: background 0.3s ease;
        }
        
        .btn-change-autohaus:hover {
            background: #1565c0;
        }
        
        .btn-change-autohaus i {
            margin-right: 0.5rem;
        }
        
        /* Keine Events Nachricht */
        .no-events-message {
            grid-column: 1 / -1;
            text-align: center;
            padding: 3rem 2rem;
            background: #f8f9fa;
            border-radius: 8px;
            border: 2px dashed #dee2e6;
            margin: 2rem 0;
        }
        
        .no-events-message .no-events-icon {
            font-size: 3rem;
            color: #6c757d;
            margin-bottom: 1rem;
        }
        
        .no-events-message h3 {
            color: #495057;
            margin-bottom: 1rem;
        }
        
        .no-events-message p {
            color: #6c757d;
            margin-bottom: 0.5rem;
        }
        
        @media (max-width: 768px) {
            .autohaus-selection-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
            
            .autohaus-selection-card {
                padding: 1.5rem;
            }
            
            .autohaus-filter {
                flex-direction: column;
                align-items: stretch;
            }
            
            .autohaus-filter select {
                min-width: auto;
            }
            
            /* Hero Section Mobile Optimierung */
            .hero {
                min-height: 60vh;
            }
            
            .hero-container {
                max-width: 90%;
                padding: 1.5rem;
            }
            
            .hero-title {
                font-size: 1.75rem;
                line-height: 1.2;
            }
            
            .hero-description {
                font-size: 0.95rem;
                line-height: 1.5;
            }
            
            .hero-stats {
                flex-direction: column;
                gap: 0.75rem;
            }
            
            /* Event Cards Mobile Optimierung */
            .event-card {
                padding: 1.5rem;
                margin-bottom: 1rem;
            }
            
            .event-card-header {
                flex-direction: column;
                gap: 1rem;
                align-items: flex-start;
            }
            
            .event-card-header h3 {
                font-size: 1.25rem;
            }
            
            .event-info-grid {
                grid-template-columns: 1fr;
                gap: 0.75rem;
            }
            
            .event-actions {
                flex-direction: column;
                gap: 0.75rem;
            }
            
            .btn-book {
                width: 100%;
                justify-content: center;
            }
            
            /* Stat Cards Mobile */
            .stat-card {
                padding: 1rem;
                min-height: auto;
            }
            
            /* Autohaus Footer Mobile */
            .autohaus-footer-image {
                max-width: 100%;
                height: auto;
                margin-top: 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .hero-title {
                font-size: 1.5rem;
            }
            
            .hero-description {
                font-size: 0.875rem;
            }
            
            .autohaus-selection-card {
                padding: 1rem;
            }
            
            .event-card {
                padding: 1rem;
            }
        }
        
        /* Verbessertes Navigation Design - Volvo Style */
        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            border-radius: 4px;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.9rem;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid #dee2e6;
            box-shadow: none;
        }
        
        .nav-link i {
            font-size: 0.9rem;
        }
        
        /* Navigation Links - Volvo Design System */
        .user-link {
            background: #0056b3;
            color: #ffffff;
            border-color: #0056b3;
        }
        
        .user-link:hover,
        .user-link:focus {
            background: #0066cc;
            color: #ffffff;
            border-color: #0066cc;
        }
        
        .user-link:active {
            background: #004c99;
            color: #ffffff;
            border-color: #004c99;
        }
        
        .user-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        /* User Profile Dropdown - Volvo Design System */
        .user-profile-dropdown {
            position: relative;
        }
        
        .user-profile-trigger {
            background: transparent;
            color: #1a1a1a;
            border: none;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 1rem;
            cursor: pointer;
            border-radius: 4px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            font-family: inherit;
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .user-profile-trigger:hover,
        .user-profile-trigger:focus {
            background: #f8f9fa;
            color: #1a1a1a;
        }
        
        .user-profile-trigger:active {
            background: #e9ecef;
            color: #1a1a1a;
        }
        
        .user-profile-trigger:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .user-profile-trigger.active {
            background: #f8f9fa;
        }
        
        .user-dropdown-icon {
            font-size: 0.75rem;
            color: #6c757d;
            transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .user-profile-trigger.active .user-dropdown-icon {
            transform: rotate(180deg);
        }
        
        .user-dropdown-menu {
            position: absolute;
            top: calc(100% + 0.5rem);
            right: 0;
            background: #ffffff;
            border-radius: 4px;
            box-shadow: var(--shadow-8);
            min-width: 200px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1000;
            border: 1px solid #e9ecef;
            overflow: hidden;
        }
        
        .user-dropdown-menu.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        
        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: #1a1a1a;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            border: none;
            background: none;
            width: 100%;
            text-align: left;
        }
        
        .dropdown-item:hover {
            background: #f8f9fa;
            color: #1a1a1a;
        }
        
        .dropdown-item:active {
            background: #e9ecef;
        }
        
        .dropdown-item i {
            width: 18px;
            text-align: center;
            color: #6c757d;
        }
        
        .dropdown-item:hover i {
            color: #0056b3;
        }
        
        /* Logout Item - Rot */
        .logout-item {
            color: #dc3545 !important;
        }
        
        .logout-item i {
            color: #dc3545 !important;
        }
        
        .logout-item:hover {
            background-color: #f8f9fa;
            color: #c82333 !important;
        }
        
        .logout-item:hover i {
            color: #c82333 !important;
        }
        
        /* User Avatar in Navbar - Volvo Design System */
        .user-avatar-nav {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            overflow: hidden;
            background: linear-gradient(135deg, #0056b3 0%, #003057 100%);
            position: relative;
        }
        
        .user-avatar-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%;
        }
        
        .user-avatar-initials {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ffffff;
            font-weight: 600;
            font-size: 0.875rem;
            letter-spacing: 0.01em;
            background: linear-gradient(135deg, #0056b3 0%, #003057 100%);
        }
        
        .user-name-nav {
            font-weight: 500;
            font-size: 0.9rem;
            white-space: nowrap;
        }
        
        @media (max-width: 768px) {
            .user-name-nav {
                display: none;
            }
            
            .user-profile-trigger {
                padding: 0.5rem;
                min-width: 44px;
                justify-content: center;
            }
            
            .user-dropdown-menu {
                right: 0;
                left: auto;
            }
        }
        
        .logout-link {
            background: #1a1a1a;
            color: #ffffff;
            border-color: #1a1a1a;
        }
        
        .logout-link:hover,
        .logout-link:focus {
            background: #2d2d2d;
            color: #ffffff;
            border-color: #2d2d2d;
        }
        
        .logout-link:active {
            background: #0d0d0d;
            color: #ffffff;
            border-color: #0d0d0d;
        }
        
        .logout-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .login-link {
            background: #0056b3;
            color: #ffffff;
            border-color: #0056b3;
        }
        
        .login-link:hover,
        .login-link:focus {
            background: #0066cc;
            color: #ffffff;
            border-color: #0066cc;
        }
        
        .login-link:active {
            background: #004c99;
            color: #ffffff;
            border-color: #004c99;
        }
        
        .login-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .admin-link {
            background: #ffffff;
            color: #1a1a1a;
            border-color: #dee2e6;
        }
        
        .admin-link:hover,
        .admin-link:focus {
            background: #f8f9fa;
            color: #1a1a1a;
            border-color: #adb5bd;
        }
        
        .admin-link:active {
            background: #e9ecef;
            color: #1a1a1a;
            border-color: #6c757d;
        }
        
        .admin-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        /* Mobile Menu Button (Burger Menu) - Volvo Design */
        .mobile-menu-btn {
            display: none;
            background: #1a1a1a !important;
            border: 1px solid #1a1a1a !important;
            color: #ffffff !important;
            font-size: 1.25rem;
            cursor: pointer;
            padding: 0.625rem;
            border-radius: 4px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            width: 44px;
            height: 44px;
            align-items: center;
            justify-content: center;
            box-shadow: none;
            flex-shrink: 0;
            margin-left: auto;
        }
        
        .mobile-menu-btn i {
            color: #ffffff !important;
        }
        
        .mobile-menu-btn:hover {
            background: #2d2d2d;
            border-color: #2d2d2d;
            color: #ffffff;
        }
        
        .mobile-menu-btn:active {
            background: #0d0d0d;
            border-color: #0d0d0d;
        }
        
        .mobile-menu-btn:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .mobile-menu-btn.active {
            background: #0056b3;
            border-color: #0056b3;
        }
        
        .mobile-menu-btn.active:hover {
            background: #0066cc;
            border-color: #0066cc;
        }
        
        @media (max-width: 768px) {
            .nav-container {
                position: relative;
            }
            
            .mobile-menu-btn {
                display: flex !important;
                order: 2;
            }
            
            .nav-menu {
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: #ffffff;
                flex-direction: column;
                padding: 1rem;
                gap: 0.5rem;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                border-radius: 0 0 4px 4px;
                border-top: 1px solid #e9ecef;
                transform: translateY(-100%);
                opacity: 0;
                visibility: hidden;
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                z-index: 999;
                order: 3;
            }
            
            .nav-menu.mobile-open {
                transform: translateY(0);
                opacity: 1;
                visibility: visible;
            }
            
            .nav-link {
                width: 100%;
                padding: 0.75rem 1rem;
                font-size: 0.9rem;
                justify-content: flex-start;
            }
            
            .nav-link span {
                display: inline;
            }
        }
        
        /* Hero Slideshow Styles werden jetzt aus style.css geladen */
        
        /* Verbesserte Event-Info Styles - Präsenter aber dezent, barrierefrei */
        .event-info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.25rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            border-radius: 8px;
            border: 1px solid #e9ecef;
        }
        
        .event-info-grid .info-item {
            display: flex;
            align-items: flex-start;
            gap: 0.875rem;
            padding: 0.75rem;
            background: #ffffff;
            border-radius: 6px;
            border: 1px solid #e9ecef;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .event-info-grid .info-item:hover {
            border-color: #0056b3;
            box-shadow: 0 2px 8px rgba(0, 86, 179, 0.1);
            transform: translateY(-1px);
        }
        
        .event-info-grid .info-icon {
            width: 40px;
            height: 40px;
            min-width: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #0056b3 0%, #003057 100%);
            color: #ffffff;
            border-radius: 6px;
            font-size: 1rem;
            flex-shrink: 0;
        }
        
        .event-info-grid .info-content {
            display: flex;
            flex-direction: column;
            gap: 0.375rem;
            flex: 1;
            min-width: 0;
        }
        
        .event-info-grid .info-label {
            font-size: 0.75rem;
            color: #6c757d;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            line-height: 1.4;
        }
        
        .event-info-grid .info-value {
            font-size: 1rem;
            color: #1a1a1a;
            font-weight: 600;
            line-height: 1.5;
            letter-spacing: -0.01em;
        }
        
        /* Mobile Optimierung für Event-Info */
        @media (max-width: 768px) {
            .event-info-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
                padding: 0.875rem;
            }
            
            .event-info-grid .info-item {
                padding: 0.875rem;
            }
            
            .event-info-grid .info-icon {
                width: 36px;
                height: 36px;
                min-width: 36px;
                font-size: 0.9rem;
            }
            
            .event-info-grid .info-value {
                font-size: 0.95rem;
            }
        }
        
        /* Barrierefreiheit: Fokus-Styles für Tastaturnavigation */
        .event-info-grid .info-item:focus-within {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
            border-color: #0056b3;
        }
        
        /* Hoher Kontrast für bessere Lesbarkeit (WCAG AA konform) */
        @media (prefers-contrast: high) {
            .event-info-grid {
                background: #ffffff;
                border: 2px solid #1a1a1a;
            }
            
            .event-info-grid .info-item {
                border: 2px solid #1a1a1a;
            }
            
            .event-info-grid .info-label {
                color: #1a1a1a;
                font-weight: 700;
            }
            
            .event-info-grid .info-value {
                color: #000000;
                font-weight: 700;
            }
        }
        
        /* Verbesserte "Nächster freier Slot" Styles - Präsenter aber dezent, barrierefrei */
        .next-slot {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem 1.25rem;
            background: linear-gradient(135deg, #e3f2fd 0%, #f0f7ff 100%);
            border: 1.5px solid #0056b3;
            border-radius: 8px;
            font-size: 0.95rem;
            color: #003057;
            font-weight: 500;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 8px rgba(0, 86, 179, 0.1);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .next-slot:hover {
            background: linear-gradient(135deg, #d0e7ff 0%, #e3f2fd 100%);
            border-color: #0066cc;
            box-shadow: 0 4px 12px rgba(0, 86, 179, 0.15);
            transform: translateY(-1px);
        }
        
        .next-slot i {
            color: #0056b3;
            font-size: 1.1rem;
            flex-shrink: 0;
        }
        
        .next-slot span {
            line-height: 1.5;
            letter-spacing: -0.01em;
        }
        
        .next-slot strong {
            color: #0056b3;
            font-weight: 700;
            font-size: 1.05rem;
            letter-spacing: 0.01em;
        }
        
        /* Mobile Optimierung für Nächster freier Slot */
        @media (max-width: 768px) {
            .next-slot {
                padding: 0.875rem 1rem;
                font-size: 0.9rem;
                gap: 0.625rem;
            }
            
            .next-slot i {
                font-size: 1rem;
            }
            
            .next-slot strong {
                font-size: 1rem;
            }
        }
        
        /* Barrierefreiheit: Fokus-Styles für Nächster freier Slot */
        .next-slot:focus-within {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        /* Hoher Kontrast für Nächster freier Slot */
        @media (prefers-contrast: high) {
            .next-slot {
                background: #ffffff;
                border: 2px solid #1a1a1a;
                color: #000000;
            }
            
            .next-slot i {
                color: #0056b3;
            }
            
            .next-slot strong {
                color: #0056b3;
                font-weight: 700;
            }
        }
        
        /* Features Section - Klassisches Design */
        .features-section {
            padding: 5rem 0;
            background: #ffffff;
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }
        
        .feature-card {
            background: #ffffff;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-2);
        }
        
        .feature-card:hover {
            box-shadow: var(--shadow-4);
            border-color: #0056b3;
            transform: translateY(-4px);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            margin: 0 auto 1.5rem;
            background: #0056b3;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ffffff;
            font-size: 2rem;
        }
        
        .feature-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #003057;
            margin: 0 0 1rem 0;
        }
        
        .feature-description {
            font-size: 0.95rem;
            line-height: 1.6;
            color: #6c757d;
            margin: 0;
        }
        
        /* Mobile Optimierung für Features */
        @media (max-width: 768px) {
            .features-section {
                padding: 3rem 0;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
                margin-top: 2rem;
            }
            
            .feature-card {
                padding: 1.5rem;
            }
        }
        
        /* ============================================
           ÜBERARBEITETER FOOTER - VOLVO DESIGN SYSTEM
           ============================================ */
        
        .footer {
            background: linear-gradient(180deg, #1a1a1a 0%, #0d0d0d 100%);
            color: #ffffff;
            padding: 4rem 0 0;
            margin-top: 4rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, transparent, #0056b3, transparent);
        }
        
        .footer-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
        }
        
        .footer-main {
            display: grid;
            grid-template-columns: 1.2fr 2fr;
            gap: 4rem;
            padding-bottom: 3rem;
            margin-bottom: 2rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        /* Brand Section */
        .footer-brand-section {
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        
        .footer-brand {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }
        
        .footer-logo {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .footer-logo-img {
            height: 48px;
            width: auto;
            filter: brightness(0) invert(1);
            transition: transform 0.3s ease;
        }
        
        .footer-logo:hover .footer-logo-img {
            transform: scale(1.05);
        }
        
        .footer-brand-text {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }
        
        .footer-brand-text h3 {
            font-family: 'Inter', sans-serif;
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0;
            color: #ffffff;
            letter-spacing: -0.01em;
        }
        
        .footer-subtitle {
            font-size: 0.875rem;
            color: #6c757d;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }
        
        .footer-description {
            color: #adb5bd;
            line-height: 1.7;
            font-size: 0.95rem;
            margin: 0;
            max-width: 400px;
        }
        
        /* Social Media Section */
        .footer-social-section {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
        
        .footer-social-title {
            font-size: 1rem;
            font-weight: 600;
            color: #ffffff;
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-size: 0.875rem;
        }
        
        .footer-social {
            display: flex;
            gap: 0.75rem;
            flex-wrap: wrap;
        }
        
        .social-link {
            width: 44px;
            height: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            color: #adb5bd;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-size: 1.1rem;
            position: relative;
            overflow: hidden;
        }
        
        .social-link::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(0, 86, 179, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }
        
        .social-link:hover::before {
            width: 100%;
            height: 100%;
        }
        
        .social-link:hover {
            background: rgba(0, 86, 179, 0.15);
            border-color: #0056b3;
            color: #ffffff;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 86, 179, 0.3);
        }
        
        .social-link:active {
            transform: translateY(0);
        }
        
        .social-link i {
            position: relative;
            z-index: 1;
        }
        
        .social-link-disabled {
            opacity: 0.4;
            cursor: not-allowed !important;
            pointer-events: none;
        }
        
        /* Links Grid */
        .footer-links-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 3rem;
        }
        
        .footer-column {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }
        
        .footer-column-title {
            font-size: 1.125rem;
            font-weight: 700;
            color: #ffffff;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-size: 0.95rem;
        }
        
        .footer-column-title i {
            font-size: 1rem;
            color: #0056b3;
        }
        
        .footer-list {
            list-style: none;
            padding: 0;
            margin: 0;
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .footer-list li {
            margin: 0;
        }
        
        .footer-link,
        .footer-contact-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: #adb5bd;
            text-decoration: none;
            font-size: 0.95rem;
            font-weight: 400;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            padding: 0.5rem 0;
            position: relative;
        }
        
        .footer-link::before,
        .footer-contact-link::before {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 0;
            height: 2px;
            background: #0056b3;
            transition: width 0.3s ease;
        }
        
        .footer-link:hover::before,
        .footer-contact-link:hover::before {
            width: 100%;
        }
        
        .footer-link:hover,
        .footer-contact-link:hover {
            color: #ffffff;
            transform: translateX(4px);
        }
        
        .footer-link i,
        .footer-contact-link i {
            width: 18px;
            text-align: center;
            color: #6c757d;
            transition: color 0.3s ease;
            font-size: 0.9rem;
        }
        
        .footer-link:hover i,
        .footer-contact-link:hover i {
            color: #0056b3;
        }
        
        .footer-whatsapp:hover {
            color: #25d366 !important;
        }
        
        .footer-whatsapp:hover i {
            color: #25d366 !important;
        }
        
        .footer-address {
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
            color: #adb5bd;
            font-size: 0.95rem;
            line-height: 1.6;
        }
        
        .footer-address i {
            width: 18px;
            color: #6c757d;
            margin-top: 2px;
            flex-shrink: 0;
        }
        
        /* Footer Bottom */
        .footer-bottom {
            padding: 2rem 0;
            background: rgba(0, 0, 0, 0.3);
        }
        
        .footer-bottom-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1.5rem;
        }
        
        .footer-copyright-section {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .footer-copyright {
            color: #6c757d;
            font-size: 0.875rem;
            margin: 0;
            font-weight: 400;
        }
        
        .footer-credits {
            color: #495057;
            font-size: 0.75rem;
            margin: 0;
            font-weight: 400;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .footer-bottom-links {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex-wrap: wrap;
        }
        
        .footer-bottom-link {
            color: #6c757d;
            text-decoration: none;
            font-size: 0.875rem;
            transition: color 0.3s ease;
            font-weight: 400;
        }
        
        .footer-bottom-link:hover {
            color: #ffffff;
        }
        
        .footer-separator {
            color: #495057;
            font-size: 0.875rem;
        }
        
        /* Responsive Design für Footer */
        @media (max-width: 1024px) {
            .footer-main {
                grid-template-columns: 1fr;
                gap: 3rem;
            }
            
            .footer-links-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 2rem;
            }
        }
        
        @media (max-width: 768px) {
            .footer {
                padding: 3rem 0 0;
                margin-top: 3rem;
            }
            
            .footer-container {
                padding: 0 1.5rem;
            }
            
            .footer-main {
                gap: 2.5rem;
                padding-bottom: 2rem;
            }
            
            .footer-links-grid {
                grid-template-columns: 1fr;
                gap: 2.5rem;
            }
            
            .footer-brand-text h3 {
                font-size: 1.5rem;
            }
            
            .footer-bottom-content {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .footer-bottom-links {
                width: 100%;
                justify-content: flex-start;
            }
            
            .social-link {
                width: 40px;
                height: 40px;
                font-size: 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .footer {
                padding: 2.5rem 0 0;
            }
            
            .footer-container {
                padding: 0 1rem;
            }
            
            .footer-logo-img {
                height: 40px;
            }
            
            .footer-brand-text h3 {
                font-size: 1.25rem;
            }
            
            .footer-description {
                font-size: 0.9rem;
            }
        }
        
        /* Barrierefreiheit: Fokus-Styles */
        .footer-link:focus,
        .footer-contact-link:focus,
        .social-link:focus,
        .footer-bottom-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
            border-radius: 4px;
        }
        
        /* Hoher Kontrast für bessere Lesbarkeit */
        @media (prefers-contrast: high) {
            .footer {
                background: #000000;
                border-top: 2px solid #ffffff;
            }
            
            .footer-link,
            .footer-contact-link {
                color: #ffffff;
            }
            
            .footer-link:hover,
            .footer-contact-link:hover {
                color: #0056b3;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <div class="logo-wrapper">
                    <img src="<?php echo htmlspecialchars($companyLogo); ?>" alt="<?php echo htmlspecialchars($companyName); ?>" class="nav-logo">
                    <div class="brand-text">
                        <h1><?php echo htmlspecialchars($appName); ?></h1>
                        <span class="brand-subtitle">B&E Gruppe - Volvo Service<?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?> - Willkommen, <?php echo htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?><?php endif; ?></span>
                    </div>
                </div>
            </div>
            <div class="nav-menu">
                <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): 
                    $current_user = getCurrentUser();
                    $user_profile_image = $current_user ? getUserProfileImage($current_user) : null;
                    $user_initials = $current_user ? getUserInitials($current_user) : '?';
                    $user_display_name = $current_user ? getUserDisplayName($current_user) : 'User';
                    
                    // Prüfe ob der eingeloggte User ein Admin ist
                    $is_admin = false;
                    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] && isset($_SESSION['user_id'])) {
                        // Lade User-Daten
                        $stmt = $conn->prepare("SELECT id, email, admin_user_id FROM users WHERE id = ? AND is_active = 1");
                        $stmt->execute([$_SESSION['user_id']]);
                        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                        if ($user_data) {
                            // Prüfe ob User direkt mit Admin verknüpft ist
                            if (!empty($user_data['admin_user_id'])) {
                                // Prüfe ob verknüpfter Admin aktiv ist
                                $stmt = $conn->prepare("SELECT id FROM admin_users WHERE id = ? AND is_active = 1");
                                $stmt->execute([$user_data['admin_user_id']]);
                                $admin_user = $stmt->fetch();
                                $is_admin = (bool)$admin_user;
                            } else {
                                // Fallback: Suche nach E-Mail in admin_users
                                $user_email = $user_data['email'] ?? '';
                                if (!empty($user_email)) {
                                    $stmt = $conn->prepare("SELECT id FROM admin_users WHERE email = ? AND is_active = 1");
                                    $stmt->execute([$user_email]);
                                    $admin_user = $stmt->fetch();
                                    $is_admin = (bool)$admin_user;
                                }
                            }
                        }
                    }
                    // Oder prüfe ob der User bereits als Admin eingeloggt ist
                    if (!$is_admin && isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in']) {
                        $is_admin = true;
                    }
                ?>
                    <div class="user-profile-dropdown">
                        <button type="button" class="user-profile-trigger" onclick="toggleUserDropdown(event)">
                            <div class="user-avatar-nav">
                                <?php if ($user_profile_image): ?>
                                    <img src="<?php echo htmlspecialchars($user_profile_image); ?>" 
                                         alt="<?php echo htmlspecialchars($user_display_name); ?>" 
                                         class="user-avatar-img"
                                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                    <div class="user-avatar-initials" style="display: none;">
                                        <?php echo htmlspecialchars($user_initials); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="user-avatar-initials">
                                        <?php echo htmlspecialchars($user_initials); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <span class="user-name-nav"><?php echo htmlspecialchars($user_display_name); ?></span>
                            <i class="fas fa-chevron-down user-dropdown-icon"></i>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="profile.php" class="dropdown-item">
                                <i class="fas fa-user"></i>
                                <span>Profil</span>
                            </a>
                            <?php if ($is_admin): ?>
                            <a href="admin/" class="dropdown-item">
                                <i class="fas fa-cog"></i>
                                <span>Admin</span>
                            </a>
                            <?php endif; ?>
                            <a href="api/logout.php" class="dropdown-item logout-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Abmelden</span>
                            </a>
                        </div>
                    </div>
                <?php else: ?>
                    <a href="login.php" class="nav-link login-link">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Anmelden</span>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Suspension Banner - Volvo Design (Höchste Priorität) -->
    <?php
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']) {
        $current_user = getCurrentUser();
        if ($current_user) {
            $is_suspended = ($current_user['status'] ?? 'pending') === 'suspended' || ($current_user['is_active'] ?? 1) == 0;
            $suspension_details = null;
            
            if ($is_suspended) {
                // Lade die neueste Suspension-Aktion aus admin_actions
                try {
                    $stmt = $conn->prepare("
                        SELECT 
                            aa.*,
                            au.username as admin_username,
                            au.email as admin_email
                        FROM admin_actions aa
                        LEFT JOIN admin_users au ON aa.admin_id = au.id
                        WHERE aa.user_id = ? 
                        AND aa.action = 'suspend'
                        ORDER BY aa.created_at DESC
                        LIMIT 1
                    ");
                    $stmt->execute([$current_user['id']]);
                    $suspension_details = $stmt->fetch(PDO::FETCH_ASSOC);
                } catch (PDOException $e) {
                    // Tabelle existiert möglicherweise nicht, das ist OK
                    error_log("Could not load suspension details: " . $e->getMessage());
                }
            }
            
            if ($is_suspended):
    ?>
    <div class="status-banner status-suspended" style="background: #c62828; border-left: 4px solid #b71c1c; padding: 1.5rem 2rem; margin: 2rem auto; max-width: 1200px; border-radius: 8px; box-shadow: 0 4px 12px rgba(198, 40, 40, 0.2); display: flex; align-items: center; gap: 1.5rem; color: #ffffff;">
        <i class="fas fa-ban" style="font-size: 1.5rem; color: #ffffff; flex-shrink: 0;"></i>
        <div style="flex: 1; min-width: 0;">
            <div style="font-size: 1rem; font-weight: 700; margin-bottom: 0.5rem; color: #ffffff;">
                Konto gesperrt
            </div>
            <div style="font-size: 0.9rem; line-height: 1.6; color: rgba(255, 255, 255, 0.95);">
                <?php if ($suspension_details): ?>
                    <div style="margin-bottom: 0.5rem;">
                        <strong style="color: #ffffff;">Grund:</strong> <?php echo htmlspecialchars($suspension_details['reason'] ?? 'Nicht angegeben'); ?>
                    </div>
                    <div style="margin-bottom: 0.5rem; opacity: 0.9;">
                        <i class="fas fa-calendar-alt" style="margin-right: 0.5rem;"></i>
                        <strong style="color: #ffffff;">Gesperrt am:</strong> <?php echo date('d.m.Y H:i', strtotime($suspension_details['created_at'])); ?>
                    </div>
                    <?php if ($suspension_details['admin_username'] || $suspension_details['admin_email']): ?>
                    <div style="opacity: 0.9;">
                        <i class="fas fa-user-shield" style="margin-right: 0.5rem;"></i>
                        <strong style="color: #ffffff;">Von:</strong> <?php echo htmlspecialchars($suspension_details['admin_username'] ?? $suspension_details['admin_email'] ?? 'Administrator'); ?>
                    </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div>Ihr Konto wurde von einem Administrator gesperrt. Bitte kontaktieren Sie den Support für weitere Informationen.</div>
                <?php endif; ?>
            </div>
        </div>
        <div style="flex-shrink: 0;">
            <a href="index.php?contact=support" class="btn-main-action" style="white-space: nowrap; background: transparent; border: 1px solid #ffffff; color: #ffffff; padding: 0.5rem 1rem; border-radius: 4px; font-size: 0.85rem; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 0.4rem; transition: all 0.2s;">
                <i class="fas fa-envelope"></i>
                Support kontaktieren
            </a>
        </div>
    </div>
    <?php
            endif;
        }
    }
    ?>

    <!-- Verifizierungs-Hinweis Banner -->
    <?php
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']) {
        $current_user = getCurrentUser();
        if ($current_user) {
            $is_suspended = ($current_user['status'] ?? 'pending') === 'suspended' || ($current_user['is_active'] ?? 1) == 0;
            $verification_status = $current_user['verification_status'] ?? 'pending';
            
            // Verifizierungs-Banner nur anzeigen wenn NICHT gesperrt
            if (!$is_suspended && ($verification_status === 'pending' || $verification_status === 'rejected')): 
    ?>
    <div class="verification-alert" style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); border-left: 4px solid #ffc107; padding: 1.5rem 2rem; margin: 2rem auto; max-width: 1200px; border-radius: 8px; box-shadow: var(--shadow-4); display: flex; align-items: center; gap: 1.5rem;">
        <div style="font-size: 2rem; color: #ffc107;">
            <i class="fas fa-hourglass-half"></i>
        </div>
        <div style="flex: 1;">
            <h3 style="margin: 0 0 0.5rem 0; color: #856404; font-weight: 700; font-size: 1.2rem;">
                Verifizierung erforderlich
            </h3>
            <p style="margin: 0; color: #856404; line-height: 1.6;">
                <?php if ($verification_status === 'pending'): ?>
                    Ihr Konto wartet noch auf Verifizierung. Bitte laden Sie ein Identitätsdokument in Ihrem <strong><a href="profile.php" style="color: #856404; text-decoration: underline;">Profil</a></strong> hoch, um Termine buchen zu können.
                <?php else: ?>
                    Ihr Konto wurde abgelehnt. Grund: <?php echo htmlspecialchars($current_user['verification_reason'] ?? 'Nicht angegeben'); ?>. Bitte laden Sie ein neues Dokument in Ihrem <strong><a href="profile.php" style="color: #856404; text-decoration: underline;">Profil</a></strong> hoch.
                <?php endif; ?>
            </p>
        </div>
        <div>
            <a href="verification_pending.php" class="btn" style="background: #ffc107; color: #856404; font-weight: 700; padding: 0.875rem 2rem; border-radius: 4px; text-decoration: none; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.3s;">
                <i class="fas fa-arrow-right"></i>
                <span><?php echo $verification_status === 'rejected' ? 'Neues Dokument hochladen' : 'Dokument hochladen'; ?></span>
            </a>
        </div>
    </div>
    <?php
            endif;
        }
    }
    ?>

    <?php
    // Success Banner für Buchungsbestätigung - VOR der Hero Section
    if (isset($_GET['success']) && ($_GET['success'] === 'request' || $_GET['success'] === 'request_created')) {
        // Lade den letzten Appointment für den eingeloggten User
        if (isLoggedIn()) {
            $current_user = getCurrentUser();
            if ($current_user) {
                $stmt = $conn->prepare("
                    SELECT a.id, a.slot_date, a.slot_time, a.license_plate, a.status, e.name as event_name,
                           ah.name as autohaus_name, ah.address as autohaus_address
                    FROM appointments a
                    LEFT JOIN events e ON a.event_id = e.id
                    LEFT JOIN autohaus ah ON a.autohaus_id = ah.id
                    WHERE a.user_id = ? AND a.status IN ('pending', 'booked')
                    ORDER BY a.created_at DESC
                    LIMIT 1
                ");
                $stmt->execute([$current_user['id']]);
                $last_appointment = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($last_appointment):
    ?>
    <style>
    @media (max-width: 768px) {
        .success-banner .banner-container { 
            flex-direction: column !important;
            align-items: flex-start !important;
            gap: 1rem !important;
            padding: 0 1rem !important;
        }
        .success-banner .banner-actions { 
            width: 100% !important;
            flex-direction: column !important;
        }
        .success-banner .btn-download,
        .success-banner .btn-later {
            width: 100% !important;
            justify-content: center !important;
        }
        .success-banner {
            margin-top: 70px !important;
            padding: 0.75rem 0 !important;
        }
    }
    </style>
    <div class="success-banner" style="background: rgba(40, 167, 69, 0.1); border-top: 2px solid rgba(40, 167, 69, 0.3); border-bottom: 2px solid rgba(40, 167, 69, 0.3); padding: 1rem 0; margin-top: 80px; margin-bottom: 0; width: 100%; display: block; position: relative; z-index: 100;">
        <div class="banner-container" style="max-width: 1200px; margin: 0 auto; padding: 0 2rem; display: flex; align-items: center; gap: 1.5rem; flex-wrap: wrap;">
            <div class="banner-content" style="flex: 1; min-width: 200px;">
                <div class="banner-header" style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.5rem;">
                    <i class="fas fa-check-circle" style="font-size: 1.5rem; color: #28a745;"></i>
                    <h3 style="margin: 0; color: #155724; font-weight: 600; font-size: 1.1rem;">
                        <?php 
                        if ($last_appointment['status'] === 'pending') {
                            echo 'Terminanfrage erfolgreich erstellt';
                        } else {
                            echo 'Termin erfolgreich gebucht';
                        }
                        ?>
                    </h3>
                </div>
                <p class="banner-text" style="margin: 0; color: #6c757d; font-size: 0.95rem; line-height: 1.4;">
                    <strong style="color: #003057;"><?php echo htmlspecialchars($last_appointment['license_plate']); ?></strong> 
                    am <?php echo date('d.m.Y', strtotime($last_appointment['slot_date'])); ?> 
                    um <?php echo date('H:i', strtotime($last_appointment['slot_time'])); ?> Uhr
                    <?php if ($last_appointment['status'] === 'pending'): ?>
                        <br><small style="color: #ffc107; font-weight: 500; margin-top: 0.5rem; display: block;">
                            <i class="fas fa-clock"></i> Ihre Anfrage wartet auf Bestätigung. Sie erhalten eine Benachrichtigung, sobald der Termin bestätigt wurde.
                        </small>
                    <?php endif; ?>
                </p>
            </div>
            
            <div class="banner-actions" style="display: flex; gap: 0.75rem; flex-wrap: wrap;">
                <a href="download_appointment_ics.php?id=<?php echo $last_appointment['id']; ?>&_session=<?php echo session_id(); ?>" class="btn-download" style="background: #28a745; color: white; border: none; padding: 0.5rem 1rem; border-radius: 4px; text-decoration: none; font-weight: 500; font-size: 0.9rem; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.2s ease;">
                    <i class="fas fa-download"></i>
                    In Kalender eintragen
                </a>
                <a href="profile.php#appointments" class="btn-later" style="background: transparent; color: #6c757d; border: 1px solid #dee2e6; padding: 0.5rem 1rem; border-radius: 4px; text-decoration: none; font-weight: 500; font-size: 0.9rem; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.2s ease;">
                    <i class="fas fa-clock"></i>
                    Später
                </a>
            </div>
        </div>
    </div>
    <?php
                endif;
            }
        }
    }
    ?>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-slideshow">
            <!-- Slide 1: EX90 Video -->
            <div class="slide slide-video active" data-video="assets/videos/EX90_hero_16-9.mp4">
                <video class="slide-video-element" muted autoplay playsinline preload="auto">
                    <source src="assets/videos/EX90_hero_16-9.mp4" type="video/mp4">
                </video>
                <div class="video-poster"></div>
                <div class="video-controls">
                    <button class="video-play-btn" aria-label="Video abspielen" style="display: none;">
                        <i class="fas fa-play"></i>
                    </button>
                    <button class="video-pause-btn" aria-label="Video pausieren">
                        <i class="fas fa-pause"></i>
                    </button>
                </div>
            </div>
            
            <!-- Slide 2: Bild -->
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/Startseitenslider-Image-Desktop_processed.jpg'); background-position: center center;"></div>
            
            <!-- Slide 3: XC60 Video -->
            <div class="slide slide-video" data-video="assets/videos/16s_16x9_exteriorgallery_XC60.mp4">
                <video class="slide-video-element" muted playsinline preload="auto">
                    <source src="assets/videos/16s_16x9_exteriorgallery_XC60.mp4" type="video/mp4">
                </video>
                <div class="video-poster"></div>
                <div class="video-controls">
                    <button class="video-play-btn" aria-label="Video abspielen" style="display: none;">
                        <i class="fas fa-play"></i>
                    </button>
                    <button class="video-pause-btn" aria-label="Video pausieren">
                        <i class="fas fa-pause"></i>
                    </button>
                </div>
            </div>
            
            <!-- Slide 4: Bild -->
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/editionsmodellehome_processed.webp'); background-position: center center;"></div>
            
            <!-- Slide 5: Bild -->
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/StartseitenSliderimage-Desktop_processed.jpg'); background-position: center center;"></div>
            
            <!-- Slide 6: Bild -->
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/volvo_model_teaser/1963/Slider-BG3x_processed.png'); background-position: center center;"></div>
            
            <!-- Slide 7: Bild -->
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/backgroundimage2x_processed.jpg'); background-position: center center;"></div>
        </div>
        <div class="hero-container">
            <div class="hero-content">
                <div class="hero-badge">
                    <i class="fas fa-shield-alt"></i>
                    <span>Professioneller Volvo Service</span>
                </div>
                <h1 class="hero-title">
                    <span class="title-line"><?php echo htmlspecialchars($appName); ?></span>
                    <span class="title-line">Service</span>
                </h1>
                <p class="hero-description">
                    Professioneller Reifenwechsel-Service für Ihren Volvo. 
                    Präzise, zuverlässig und mit höchster Qualität.
                </p>
                <div class="hero-stats">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-stopwatch"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">30</span>
                            <span class="stat-label">Minuten</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">2x</span>
                            <span class="stat-label">Jährlich</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Sicherheit</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Autohaus-Auswahl Section (nur wenn Multi-Autohaus aktiviert) -->
    <?php if ($multiAutohausEnabled && $autohausSelectionRequired): ?>
    <section class="autohaus-selection-section" <?php echo $userPreferredAutohaus ? 'style="display: none;"' : ''; ?>>
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Wählen Sie Ihr Autohaus</h2>
                <p class="section-subtitle">Bitte wählen Sie das Autohaus aus, für das Sie einen Termin buchen möchten</p>
            </div>
            
            <div class="autohaus-selection-grid">
                <?php foreach ($autohauser as $autohaus): ?>
                    <div class="autohaus-selection-card" 
                         data-autohaus-id="<?php echo $autohaus['id']; ?>"
                         onclick="selectAutohaus(<?php echo $autohaus['id']; ?>, '<?php echo htmlspecialchars($autohaus['name']); ?>', event)">
                        <div class="autohaus-card-header">
                            <h3><?php echo htmlspecialchars($autohaus['name']); ?></h3>
                            <span class="autohaus-short"><?php echo htmlspecialchars($autohaus['short_name']); ?></span>
                        </div>
                        <div class="autohaus-card-info">
                            <div class="info-item">
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo htmlspecialchars($autohaus['address']); ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-phone"></i>
                                <span><?php echo htmlspecialchars($autohaus['phone']); ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-calendar-alt"></i>
                                <span>
                                    <?php if ($autohaus['upcoming_events'] > 0): ?>
                                        <strong><?php echo $autohaus['upcoming_events']; ?></strong> Event<?php echo $autohaus['upcoming_events'] > 1 ? 's' : ''; ?> geplant
                                    <?php else: ?>
                                        Keine Events geplant
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        <?php if (!empty($autohaus['footer_image'])): ?>
                        <div class="autohaus-card-image">
                            <?php 
                            // Extrahiere Dateinamen aus dem Pfad
                            $footer_filename = basename($autohaus['footer_image']); 
                            ?>
                            <img src="api/view_footer_image.php?file=<?php echo urlencode($footer_filename); ?>" 
                                 alt="<?php echo htmlspecialchars($autohaus['footer_image_alt'] ?? $autohaus['name']); ?>" 
                                 style="width: 100%; max-height: 150px; object-fit: cover; border-radius: 8px;">
                        </div>
                        <?php endif; ?>
                        <div class="autohaus-card-action">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Events Section -->
    <section class="events-section" id="events-section" <?php 
        // Events-Sektion ausblenden nur wenn Autohaus-Auswahl erforderlich ist UND kein bevorzugtes Autohaus vorhanden ist
        $hideEventsSection = ($multiAutohausEnabled && $autohausSelectionRequired && !$userPreferredAutohaus);
        echo $hideEventsSection ? 'style="display: none;"' : ''; 
    ?>>
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Verfügbare Events</h2>
                <p class="section-subtitle">Buchen Sie Ihren Termin bei der B&E Gruppe</p>
                <?php if ($multiAutohausEnabled && !$autohausSelectionRequired): ?>
                    <div class="autohaus-filter">
                        <label for="autohaus-filter">Autohaus filtern:</label>
                        <select id="autohaus-filter" onchange="filterEventsByAutohaus()">
                            <option value="">Alle Autohäuser</option>
                            <?php foreach ($autohauser as $autohaus): ?>
                                <option value="<?php echo $autohaus['id']; ?>"><?php echo htmlspecialchars($autohaus['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if (empty($events)): ?>
                <div class="no-events">
                    <div class="no-events-icon">
                        <i class="fas fa-calendar-times"></i>
                    </div>
                    <h3>Keine Events verfügbar</h3>
                    <p>Derzeit sind keine Events der B&E Gruppe geplant.</p>
                    <p>Kontaktieren Sie uns für weitere Informationen.</p>
                </div>
            <?php else: ?>
                <div class="events-grid">
                    <?php foreach ($events as $event): ?>
                        <?php
                        $totalSlots = floor((strtotime($event['end_time'])-strtotime($event['start_time']))/($event['slot_duration']*60)) * (int)$event['max_monteure'];
                        $booked = (int)($event['booked_count'] ?? 0);
                        $ratio = $totalSlots>0 ? round($booked/$totalSlots*100) : 0;
                        
                        // Nächster freier Slot ermitteln
                        $nextFree = null;
                        $countsStmt = $conn->prepare("SELECT slot_time, COUNT(*) as c FROM appointments WHERE event_id = ? AND slot_date = ? AND status IN ('booked','vorbereitet') GROUP BY slot_time");
                        $countsStmt->execute([$event['id'], $event['event_date']]);
                        $counts = [];
                        foreach ($countsStmt->fetchAll() as $row) { $counts[$row['slot_time']] = (int)$row['c']; }
                        $slotDur = ((int)$event['slot_duration']) * 60;
                        for ($t = strtotime($event['start_time']); $t < strtotime($event['end_time']); $t += $slotDur) {
                            $tStr = date('H:i:s', $t);
                            $b = $counts[$tStr] ?? 0;
                            if ($b < (int)$event['max_monteure']) { $nextFree = date('H:i', $t); break; }
                        }
                        ?>
                        <div class="event-card" data-autohaus-id="<?php echo $event['autohaus_id'] ?? ''; ?>">
                            <div class="event-card-header">
                                <div class="event-status">
                                    <span class="status-badge <?php echo $ratio >= 90 ? 'status-full' : ($ratio >= 70 ? 'status-busy' : 'status-available'); ?>">
                                        <?php echo $ratio >= 90 ? 'Ausgebucht' : ($ratio >= 70 ? 'Fast voll' : 'Verfügbar'); ?>
                                    </span>
                                </div>
                                <div class="event-date-badge">
                                    <i class="fas fa-calendar"></i>
                                    <span><?php echo date('d.m', strtotime($event['event_date'])); ?></span>
                                </div>
                            </div>
                            
                            <div class="event-card-content">
                                <h3 class="event-title"><?php echo htmlspecialchars($event['name']); ?></h3>
                                
                                <?php if (!empty($event['autohaus_name'])): ?>
                                <div class="event-autohaus">
                                    <i class="fas fa-building"></i>
                                    <span><?php echo htmlspecialchars($event['autohaus_name']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <div class="event-info-grid">
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Zeit</span>
                                            <span class="info-value"><?php echo date('H:i', strtotime($event['start_time'])); ?> - <?php echo date('H:i', strtotime($event['end_time'])); ?></span>
                                        </div>
                                    </div>
                                    
                                    <!-- <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-users"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Monteure</span>
                                            <span class="info-value"><?php echo $event['max_monteure']; ?></span>
                                        </div>
                                    </div> -->
                                    
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-stopwatch"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Ungefähre Arbeitsdauer</span>
                                            <span class="info-value"><?php echo $event['slot_duration']; ?> Min</span>
                                        </div>
                                    </div>
                                    
                                    <!-- <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-chart-pie"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Auslastung</span>
                                            <span class="info-value"><?php echo $booked; ?>/<?php echo $totalSlots; ?></span>
                                        </div>
                                    </div> -->
                                </div>
                                
                                <div class="event-progress">
                                    <div class="progress-header">
                                        <span class="progress-label">Belegung</span>
                                        <span class="progress-percentage"><?php echo $ratio; ?>%</span>
                                    </div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: <?php echo $ratio; ?>%"></div>
                                    </div>
                                </div>
                                
                                <?php if ($nextFree): ?>
                                <div class="next-slot">
                                    <i class="fas fa-clock-rotate-left"></i>
                                    <span>Nächster freier Slot: <strong><?php echo $nextFree; ?></strong></span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="event-card-footer">
                                <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
                                    <?php 
                                    // Prüfe ob User verifiziert ist
                                    $current_user = getCurrentUser();
                                    $is_verified = $current_user && isset($current_user['verification_status']) && $current_user['verification_status'] === 'approved';
                                    $verification_status = $current_user['verification_status'] ?? 'pending';
                                    ?>
                                    <?php if ($is_verified): ?>
                                <a href="booking.php?event=<?php echo $event['id']; ?>" class="btn btn-primary event-btn">
                                    <i class="fas fa-calendar-plus"></i>
                                    <span>Termin buchen</span>
                                </a>
                                    <?php else: ?>
                                        <?php if ($verification_status === 'rejected'): ?>
                                            <div style="background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; padding: 1rem; text-align: center;">
                                                <i class="fas fa-times-circle" style="color: #dc3545; font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                                <div style="font-weight: 700; color: #721c24; margin-bottom: 0.25rem;">Konto wurde abgelehnt</div>
                                                <div style="font-size: 0.9rem; color: #856404;">
                                                    <a href="profile.php" style="color: #856404; text-decoration: underline;">Profil öffnen</a> und neues Dokument hochladen
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 1rem; text-align: center;">
                                                <i class="fas fa-hourglass-half" style="color: #ffc107; font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                                <div style="font-weight: 700; color: #856404; margin-bottom: 0.25rem;">Verifizierung erforderlich</div>
                                                <div style="font-size: 0.9rem; color: #856404;">
                                                    <a href="profile.php" style="color: #856404; text-decoration: underline;">Profil öffnen</a> und Dokument hochladen
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <a href="login.php?redirect=booking.php&event=<?php echo $event['id']; ?>" class="btn btn-primary event-btn">
                                        <i class="fas fa-sign-in-alt"></i>
                                        <span>Anmelden zum Buchen</span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Warum B&E Gruppe?</h2>
                <p class="section-subtitle">Professioneller Service für Ihren Volvo</p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h3 class="feature-title">Professioneller Service</h3>
                    <p class="feature-description">
                        Schneller, präziser Reifenwechsel in nur 30 Minuten. 
                        Zertifizierte Volvo-Techniker sorgen für höchste Qualität.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="feature-title">Volvo Qualität</h3>
                    <p class="feature-description">
                        Original Volvo Teile und zertifizierte Techniker für maximale Sicherheit. 
                        Vertrauen Sie auf bewährte Volvo-Standards.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <h3 class="feature-title">Terminvereinbarung</h3>
                    <p class="feature-description">
                        Einfache Online-Terminvereinbarung für Ihren Reifenwechsel. 
                        Komfortabel und zeitsparend.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <h3 class="feature-title">Reifenlagerung</h3>
                    <p class="feature-description">
                        Sichere Einlagerung Ihrer Sommer- oder Winterreifen. 
                        Professionelle Lagerung in unserem klimatisierten Lager.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="cta-container">
            <div class="cta-content">
                <h2 class="cta-title">Bereit für Ihren Reifenwechsel?</h2>
                <p class="cta-description">
                    Buchen Sie jetzt Ihren Termin für einen professionellen Reifenwechsel-Service.
                </p>
                <a href="#events-section" class="btn btn-cta">
                    <i class="fas fa-calendar-plus"></i>
                    <span>Jetzt buchen</span>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <!-- Footer Hauptbereich -->
            <div class="footer-main">
                <!-- Brand & Beschreibung -->
                <div class="footer-brand-section">
                    <div class="footer-brand">
                        <div class="footer-logo">
                            <img src="<?php echo htmlspecialchars($companyLogo); ?>" alt="<?php echo htmlspecialchars($companyName); ?>" class="footer-logo-img">
                            <div class="footer-brand-text">
                                <h3><?php echo htmlspecialchars($appName); ?></h3>
                                <span class="footer-subtitle">Volvo Service</span>
                            </div>
                        </div>
                        <p class="footer-description">
                            Ihr vertrauensvoller Partner für professionelle Reifenwechsel-Services. 
                            Qualität und Sicherheit für Ihren Volvo.
                        </p>
                    </div>
                    
                    <!-- Social Media -->
                    <div class="footer-social-section">
                        <h4 class="footer-social-title">Folgen Sie uns</h4>
                        <div class="footer-social">
                            <a href="https://www.facebook.com/volvobegruppe" target="_blank" rel="noopener noreferrer" class="social-link" title="Facebook" aria-label="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://www.instagram.com/volvo_be_gruppe/" target="_blank" rel="noopener noreferrer" class="social-link" title="Instagram" aria-label="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-link social-link-disabled" title="TikTok (bald verfügbar)" aria-label="TikTok" onclick="return false;">
                                <i class="fab fa-tiktok"></i>
                            </a>
                            <a href="#" class="social-link social-link-disabled" title="LinkedIn (deaktiviert)" aria-label="LinkedIn" onclick="return false;">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Footer Links Grid -->
                <div class="footer-links-grid">
                    <!-- Service Spalte -->
                    <div class="footer-column">
                        <h4 class="footer-column-title">
                            <i class="fas fa-tools"></i>
                            Service
                        </h4>
                        <ul class="footer-list">
                            <li>
                                <a href="<?php echo ($multiAutohausEnabled && $autohausSelectionRequired) ? '#autohaus-selection' : '#events-section'; ?>" class="footer-link">
                                    <i class="fas fa-calendar-alt"></i>
                                    <span>Events & Termine</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo ($multiAutohausEnabled && $autohausSelectionRequired) ? '#autohaus-selection' : '#events-section'; ?>" class="footer-link">
                                    <i class="fas fa-calendar-plus"></i>
                                    <span>Termin buchen</span>
                                </a>
                            </li>
                            <li>
                                <a href="#features-section" class="footer-link">
                                    <i class="fas fa-concierge-bell"></i>
                                    <span>Unsere Services</span>
                                </a>
                            </li>
                            <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
                            <li>
                                <a href="profile.php" class="footer-link">
                                    <i class="fas fa-user-circle"></i>
                                    <span>Mein Profil</span>
                                </a>
                            </li>
                            <?php else: ?>
                            <li>
                                <a href="login.php" class="footer-link">
                                    <i class="fas fa-sign-in-alt"></i>
                                    <span>Anmelden</span>
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    
                    <!-- Kontakt Spalte -->
                    <div class="footer-column">
                        <h4 class="footer-column-title">
                            <i class="fas fa-address-card"></i>
                            Kontakt
                        </h4>
                        <ul class="footer-list">
                            <li>
                                <a href="tel:<?php echo htmlspecialchars(preg_replace('/[^0-9+]/', '', $companyPhone)); ?>" class="footer-contact-link">
                                    <i class="fas fa-phone-alt"></i>
                                    <span><?php echo htmlspecialchars($companyPhone); ?></span>
                                </a>
                            </li>
                            <li>
                                <a href="mailto:<?php echo htmlspecialchars($companyEmail); ?>" class="footer-contact-link">
                                    <i class="fas fa-envelope"></i>
                                    <span><?php echo htmlspecialchars($companyEmail); ?></span>
                                </a>
                            </li>
                            <li>
                                <div class="footer-address">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span><?php echo nl2br(htmlspecialchars($companyAddress)); ?></span>
                                </div>
                            </li>
                            <li>
                                <?php if ($footerWhatsAppLink): ?>
                                <a href="<?php echo htmlspecialchars($footerWhatsAppLink); ?>" target="_blank" rel="noopener noreferrer" class="footer-contact-link footer-whatsapp">
                                    <i class="fab fa-whatsapp"></i>
                                    <span>WhatsApp Kontakt</span>
                                </a>
                                <?php else: ?>
                                <span class="footer-contact-link footer-whatsapp" style="opacity: 0.6; cursor: not-allowed;">
                                    <i class="fab fa-whatsapp"></i>
                                    <span>WhatsApp Kontakt (nicht verfügbar)</span>
                                </span>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                    
                    <!-- Rechtliches Spalte -->
                    <div class="footer-column">
                        <h4 class="footer-column-title">
                            <i class="fas fa-gavel"></i>
                            Rechtliches
                        </h4>
                        <ul class="footer-list">
                            <?php if ($footerImpressumLink): ?>
                            <li>
                                <a href="<?php echo htmlspecialchars($footerImpressumLink); ?>" target="_blank" rel="noopener noreferrer" class="footer-link">
                                    <i class="fas fa-file-alt"></i>
                                    <span>Impressum</span>
                                </a>
                            </li>
                            <?php else: ?>
                            <li>
                                <span class="footer-link" style="opacity: 0.6; cursor: not-allowed;">
                                    <i class="fas fa-file-alt"></i>
                                    <span>Impressum (nicht verfügbar)</span>
                                </span>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <div class="footer-copyright-section">
                        <p class="footer-copyright">
                            &copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($companyName); ?>. Alle Rechte vorbehalten.
                        </p>
                        <p class="footer-credits">
                            Entwickelt mit <i class="fas fa-heart" style="color: #e74c3c;"></i> für Volvo Service von <strong>Deniz Uludag</strong> &copy; <?php echo date('Y'); ?> Deniz Uludag
                        </p>
                    </div>
                    <div class="footer-bottom-links">
                        <?php if ($footerImpressumLink): ?>
                        <a href="<?php echo htmlspecialchars($footerImpressumLink); ?>" target="_blank" rel="noopener noreferrer" class="footer-bottom-link">Impressum</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
    
    <script>
        // Bevorzugtes Autohaus des eingeloggten Benutzers (falls vorhanden)
        const userPreferredAutohaus = <?php echo json_encode([
            'id' => $userPreferredAutohausId,
            'name' => $userPreferredAutohausName
        ]); ?>;
        
        // User Dropdown Toggle Funktion
        function toggleUserDropdown(event) {
            event.stopPropagation();
            const menu = document.getElementById('userDropdownMenu');
            const trigger = event.currentTarget;
            
            if (menu && trigger) {
                const isOpen = menu.classList.contains('show');
                
                // Schließe alle anderen Dropdowns
                document.querySelectorAll('.user-dropdown-menu').forEach(m => {
                    m.classList.remove('show');
                });
                document.querySelectorAll('.user-profile-trigger').forEach(t => {
                    t.classList.remove('active');
                });
                
                // Toggle aktuelles Dropdown
                if (!isOpen) {
                    menu.classList.add('show');
                    trigger.classList.add('active');
                } else {
                    menu.classList.remove('show');
                    trigger.classList.remove('active');
                }
            }
        }
        
        // Schließe Dropdown beim Klick außerhalb
        document.addEventListener('click', function(event) {
            if (!event.target.closest('.user-profile-dropdown')) {
                document.querySelectorAll('.user-dropdown-menu').forEach(menu => {
                    menu.classList.remove('show');
                });
                document.querySelectorAll('.user-profile-trigger').forEach(trigger => {
                    trigger.classList.remove('active');
                });
            }
        });
        
        // ============================================
        // INTELLIGENTE LINK-FUNKTIONSLOGIK
        // ============================================
        
        /**
         * Zentrale Funktion für intelligentes Scrollen zu Anker-Links
         * Behandelt alle möglichen Szenarien und Fallbacks
         */
        function handleAnchorLink(href, event) {
            if (!href || !href.startsWith('#')) {
                return false; // Kein Anker-Link
            }
            
            const targetId = href.substring(1);
            if (!targetId || targetId === 'contact') {
                return false; // Leerer Link oder Contact (wird anders behandelt)
            }
            
            // Verhindere Standard-Verhalten
            if (event) {
                event.preventDefault();
            }
            
            const headerOffset = 80; // Offset für fixierte Navigation
            let targetElement = null;
            let scrollTarget = null;
            
            // Mapping für verschiedene Link-Varianten
            const linkMapping = {
                'events': 'events-section',
                'events-section': 'events-section',
                'autohaus-selection': 'autohaus-selection',
                'services': 'features-section', // Features = Services
                'features': 'features-section',
                'features-section': 'features-section'
            };
            
            // Prüfe zuerst direkte ID
            targetElement = document.getElementById(targetId);
            
            // Wenn nicht gefunden, prüfe Mapping
            if (!targetElement && linkMapping[targetId]) {
                targetElement = document.getElementById(linkMapping[targetId]);
            }
            
            // Spezielle Logik für autohaus-selection
            if (targetId === 'autohaus-selection' && !targetElement) {
                // Wenn Autohaus-Auswahl nicht existiert, gehe zu Events
                targetElement = document.getElementById('events-section');
            }
            
            // Spezielle Logik für services
            if (targetId === 'services' && !targetElement) {
                // Versuche Features-Sektion
                targetElement = document.getElementById('features-section');
            }
            
            // Wenn immer noch nicht gefunden, versuche generische Suche
            if (!targetElement) {
                // Suche nach Section mit ähnlichem Namen
                const sections = document.querySelectorAll('section[id], div[id]');
                for (let section of sections) {
                    const sectionId = section.id.toLowerCase();
                    if (sectionId.includes(targetId.toLowerCase()) || targetId.toLowerCase().includes(sectionId)) {
                        targetElement = section;
                        break;
                    }
                }
            }
            
            // Scroll zu gefundenem Element
            if (targetElement) {
                const elementPosition = targetElement.getBoundingClientRect().top;
                const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
                
                window.scrollTo({
                    top: Math.max(0, offsetPosition), // Stelle sicher, dass nicht negativ
                    behavior: 'smooth'
                });
                
                // Fokus für Barrierefreiheit
                targetElement.setAttribute('tabindex', '-1');
                targetElement.focus();
                
                return true;
            }
            
            // Fallback: Scroll zum Anfang der Seite
            console.warn(`Link-Ziel nicht gefunden: #${targetId}`);
            return false;
        }
        
        // Smooth Scrolling für alle Links initialisieren
        document.addEventListener('DOMContentLoaded', function() {
            // Footer-Links
            const footerLinks = document.querySelectorAll('.footer-link, .footer-bottom-link');
            footerLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    handleAnchorLink(href, e);
                });
            });
            
            // Alle Anker-Links auf der Seite (inkl. CTA-Buttons)
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    handleAnchorLink(href, e);
                });
            });
            
            // Spezielle Behandlung für CTA-Buttons
            const ctaButtons = document.querySelectorAll('.btn-cta, .btn[href^="#"]');
            ctaButtons.forEach(btn => {
                btn.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (handleAnchorLink(href, e)) {
                        // Optional: Analytics-Tracking hier einfügen
                        console.log('CTA-Button geklickt:', href);
                    }
                });
            });
        });
        
        // Haptisches Feedback (Vibration)
        // Hinweis: Vibration funktioniert nur nach User-Interaktion (Chrome-Sicherheitsrichtlinie)
        function triggerHapticFeedback(type = 'success') {
            // Prüfe ob Vibration unterstützt wird
            if ('vibrate' in navigator) {
                try {
                    let pattern;
                    if (type === 'success') {
                        // Erfolgreiche Auswahl: deutlich spürbare Vibration (300ms)
                        pattern = 300;
                    } else if (type === 'error') {
                        // Fehler: längere Vibration mit Pause
                        pattern = [300, 150, 300];
                    } else if (type === 'select') {
                        // Auswahl: spürbare Vibration (150ms)
                        pattern = 150;
                    } else {
                        // Standard: 200ms
                        pattern = 200;
                    }
                    
                    // Prüfe ob iOS (Safari unterstützt Vibration API nicht)
                    const isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) || 
                                  (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1);
                    
                    if (isIOS) {
                        console.log('[Vibration] iOS erkannt - Vibration API wird nicht unterstützt');
                        // Auf iOS können wir nur visuelles Feedback geben
                        // Haptic Feedback ist nur in nativen Apps verfügbar
                        return false;
                    }
                    
                    // Für Android und andere Geräte: Vibration ausführen
                    const result = navigator.vibrate(pattern);
                    console.log('[Vibration] Typ:', type, 'Pattern:', pattern, 'Erfolg:', result, 'UserAgent:', navigator.userAgent);
                    
                    // Wenn Vibration fehlschlägt, versuche es mit einem längeren Pattern
                    if (!result && pattern < 500) {
                        console.log('[Vibration] Erster Versuch fehlgeschlagen, versuche längeres Pattern...');
                        const longerPattern = type === 'success' ? 500 : (type === 'error' ? [500, 200, 500] : 300);
                        const retryResult = navigator.vibrate(longerPattern);
                        console.log('[Vibration] Retry Pattern:', longerPattern, 'Erfolg:', retryResult);
                        return retryResult;
                    }
                    
                    return result;
                } catch (e) {
                    console.warn('[Vibration] Fehler:', e.message);
                    return false;
                }
            } else {
                console.log('[Vibration] Nicht unterstützt auf diesem Gerät - UserAgent:', navigator.userAgent);
                return false;
            }
        }
        
        // Finde nächstes Autohaus basierend auf Koordinaten
        async function findNearestAutohaus(latitude, longitude) {
            try {
                const response = await fetch('api/find_nearest_autohaus.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        latitude: latitude,
                        longitude: longitude
                    })
                });
                
                const data = await response.json();
                if (data.success && data.nearest_autohaus) {
                    return data.nearest_autohaus;
                }
                return null;
            } catch (error) {
                console.warn('Fehler beim Finden des nächsten Autohauses:', error);
                return null;
            }
        }
        
        // Automatische Autohaus-Auswahl basierend auf Standort
        async function autoSelectAutohausByLocation() {
            if (!navigator.geolocation) {
                return false;
            }
            
            return new Promise((resolve) => {
                const timeout = setTimeout(() => {
                    resolve(false);
                }, 5000);
                
                navigator.geolocation.getCurrentPosition(
                    async (position) => {
                        clearTimeout(timeout);
                        const lat = position.coords.latitude;
                        const lng = position.coords.longitude;
                        
                        const nearestAutohaus = await findNearestAutohaus(lat, lng);
                        
                        if (nearestAutohaus) {
                            const autohausId = nearestAutohaus.id;
                            const autohausName = nearestAutohaus.name;
                            const distance = nearestAutohaus.distance_km;
                            
                            // Visuell auswählen - warte kurz, damit Cards geladen sind
                            setTimeout(() => {
                                const cards = document.querySelectorAll('.autohaus-selection-card');
                                
                                if (cards.length === 0) {
                                    return;
                                }
                                
                                cards.forEach(card => {
                                    const cardId = card.getAttribute('data-autohaus-id');
                                    
                                    card.classList.remove('selected');
                                    const cardIcon = card.querySelector('.autohaus-card-action i');
                                    if (cardIcon) {
                                        cardIcon.className = 'fas fa-arrow-right';
                                    }
                                    
                                    if (cardId && parseInt(cardId) === parseInt(autohausId)) {
                                        card.classList.add('selected');
                                        if (cardIcon) {
                                            cardIcon.className = 'fas fa-check-circle';
                                        }
                                        
                                        // Smooth scroll zu ausgewähltem Autohaus
                                        setTimeout(() => {
                                            card.scrollIntoView({ behavior: 'smooth', block: 'center' });
                                        }, 300);
                                        
                                        // Haptisches Feedback wird NICHT automatisch aufgerufen
                                        // (Vibration funktioniert nur nach User-Interaktion - wird bei manueller Auswahl aufgerufen)
                                    }
                                });
                            }, 100);
                            
                            resolve(true);
                        } else {
                            resolve(false);
                        }
                    },
                    (error) => {
                        clearTimeout(timeout);
                        resolve(false);
                    },
                    {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0
                    }
                );
            });
        }
        
        // Autohaus-Auswahl Funktionen
        function selectAutohaus(autohausId, autohausName, event) {
            // Event-Objekt bekommen falls nicht übergeben
            if (!event) {
                event = window.event;
            }
            
            // Haptisches Feedback nur bei tatsächlichem User-Klick (nicht bei automatischer Auswahl)
            const isUserClick = event && (event.type === 'click' || event.type === 'touchstart');
            if (isUserClick) {
                triggerHapticFeedback('select');
            }
            
            // Alle Cards deselektieren
            const cards = document.querySelectorAll('.autohaus-selection-card');
            cards.forEach(card => {
                card.classList.remove('selected');
                const cardIcon = card.querySelector('.autohaus-card-action i');
                if (cardIcon) {
                    cardIcon.className = 'fas fa-arrow-right';
                }
            });
            
            // Gewählte Card selektieren
            const selectedCard = event?.currentTarget || event?.target?.closest('.autohaus-selection-card') || 
                                 document.querySelector(`.autohaus-selection-card[data-autohaus-id="${autohausId}"]`);
            
            if (selectedCard) {
                selectedCard.classList.add('selected');
                const cardIcon = selectedCard.querySelector('.autohaus-card-action i');
                if (cardIcon) {
                    cardIcon.className = 'fas fa-check-circle';
                }
                
                // Animation für visuelles Feedback
                selectedCard.style.transform = 'scale(0.98)';
                setTimeout(() => {
                    selectedCard.style.transform = 'scale(1)';
                }, 150);
            }
            // Autohaus in Session speichern
            fetch('api/autohaus_selection.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    action: 'select_autohaus',
                    autohaus_id: autohausId,
                    autohaus_name: autohausName
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Erfolgreiches Feedback - mit kurzer Verzögerung, damit User-Interaktion-Context noch aktiv ist
                    // Vibration muss innerhalb von ~1 Sekunde nach User-Interaktion erfolgen
                    setTimeout(() => {
                        triggerHapticFeedback('success');
                    }, 50);
                    
                    // Events-Sektion anzeigen und nach Autohaus filtern
                    const eventsSection = document.getElementById('events-section');
                    eventsSection.style.display = 'block';
                    
                    // Warte kurz, dann filtere die Events
                    setTimeout(() => {
                        filterEventsByAutohaus(autohausId);
                    }, 100);
                    
                    // Autohaus-Auswahl-Sektion ausblenden
                    const autohausSelectionSection = document.querySelector('.autohaus-selection-section');
                    if (autohausSelectionSection) {
                        autohausSelectionSection.style.display = 'none';
                    }
                    
                    // Autohaus-Info in der Events-Sektion anzeigen
                    const eventsHeader = document.querySelector('#events-section .section-header');
                    const autohausInfo = document.createElement('div');
                    autohausInfo.className = 'selected-autohaus-info';
                    autohausInfo.innerHTML = `
                        <div class="autohaus-info-badge">
                            <i class="fas fa-building"></i>
                            <span>Ausgewähltes Autohaus: <strong>${autohausName}</strong></span>
                            <button type="button" onclick="changeAutohaus()" class="btn-change-autohaus">
                                <i class="fas fa-exchange-alt"></i> Wechseln
                            </button>
                        </div>
                    `;
                    eventsHeader.appendChild(autohausInfo);
                    
                    // Scroll zur Events-Sektion
                    setTimeout(() => {
                        const headerOffset = 80;
                        const elementPosition = eventsSection.getBoundingClientRect().top;
                        const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
                        window.scrollTo({
                            top: offsetPosition,
                            behavior: 'smooth'
                        });
                    }, 200);
                } else {
                    // Fehler-Feedback
                    triggerHapticFeedback('error');
                    alert('Fehler bei der Autohaus-Auswahl: ' + (data.error || 'Unbekannter Fehler'));
                }
            })
            .catch(error => {
                console.error('Fehler:', error);
                triggerHapticFeedback('error');
                alert('Fehler bei der Autohaus-Auswahl');
            });
        }
        
        // Automatische Autohaus-Auswahl beim Laden der Seite
        document.addEventListener('DOMContentLoaded', function() {
            // Warte etwas länger, damit alle Elemente geladen sind
            setTimeout(() => {
                // Prüfe zuerst ob Benutzer ein bevorzugtes Autohaus hat
                if (userPreferredAutohaus && userPreferredAutohaus.id && userPreferredAutohaus.name) {
                    // Bevorzugtes Autohaus automatisch auswählen
                    console.log('Bevorzugtes Autohaus gefunden:', userPreferredAutohaus);
                    
                    // Autohaus in Session speichern
                    fetch('api/autohaus_selection.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            action: 'select_autohaus',
                            autohaus_id: userPreferredAutohaus.id,
                            autohaus_name: userPreferredAutohaus.name
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Events-Sektion anzeigen und nach Autohaus filtern
                            const eventsSection = document.getElementById('events-section');
                            if (eventsSection) {
                                eventsSection.style.display = 'block';
                                
                                // Warte kurz, dann filtere die Events
                                setTimeout(() => {
                                    filterEventsByAutohaus(userPreferredAutohaus.id);
                                }, 100);
                            }
                            
                            // Autohaus-Auswahl-Sektion ausblenden
                            const autohausSelectionSection = document.querySelector('.autohaus-selection-section');
                            if (autohausSelectionSection) {
                                autohausSelectionSection.style.display = 'none';
                            }
                            
                            // Autohaus-Info in der Events-Sektion anzeigen
                            const eventsHeader = document.querySelector('#events-section .section-header');
                            if (eventsHeader) {
                                // Prüfe ob Info bereits vorhanden ist
                                let autohausInfo = document.querySelector('.selected-autohaus-info');
                                if (!autohausInfo) {
                                    autohausInfo = document.createElement('div');
                                    autohausInfo.className = 'selected-autohaus-info';
                                    autohausInfo.innerHTML = `
                                        <div class="autohaus-info-badge">
                                            <i class="fas fa-building"></i>
                                            <span>Ausgewähltes Autohaus: <strong>${userPreferredAutohaus.name}</strong></span>
                                            <button type="button" onclick="changeAutohaus()" class="btn-change-autohaus">
                                                <i class="fas fa-exchange-alt"></i> Wechseln
                                            </button>
                                        </div>
                                    `;
                                    eventsHeader.appendChild(autohausInfo);
                                }
                            }
                            
                            // Visuell markieren in der Autohaus-Auswahl (falls sichtbar)
                            const selectedCard = document.querySelector(`.autohaus-selection-card[data-autohaus-id="${userPreferredAutohaus.id}"]`);
                            if (selectedCard) {
                                selectedCard.classList.add('selected');
                                const cardIcon = selectedCard.querySelector('.autohaus-card-action i');
                                if (cardIcon) {
                                    cardIcon.className = 'fas fa-check-circle';
                                }
                            }
                        }
                    })
                    .catch(error => {
                        console.error('Fehler beim Laden des bevorzugten Autohauses:', error);
                    });
                } else {
                    // Prüfe ob Autohaus-Auswahl-Sektion vorhanden ist
                    const autohausSelectionSection = document.querySelector('.autohaus-selection-section');
                    // Standort-Erkennung nur für eingeloggte Nutzer
                    const isLoggedIn = <?php echo isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] ? 'true' : 'false'; ?>;
                    if (autohausSelectionSection && autohausSelectionSection.style.display !== 'none' && isLoggedIn) {
                        // Falls kein bevorzugtes Autohaus vorhanden, versuche Standort-Erkennung
                        autoSelectAutohausByLocation();
                    }
                }
            }, 500); // Warte 500ms, damit alles geladen ist
        });
        
        function filterEventsByAutohaus(autohausId = null) {
            const eventCards = document.querySelectorAll('.event-card');
            const filterSelect = document.getElementById('autohaus-filter');
            
            if (autohausId === null && filterSelect) {
                autohausId = filterSelect.value;
            }
            
            // Konvertiere autohausId zu String für Vergleich
            const targetAutohausId = String(autohausId);
            
            let visibleCount = 0;
            
            eventCards.forEach(card => {
                const cardAutohausId = card.getAttribute('data-autohaus-id');
                
                // Zeige alle Events wenn kein Filter gesetzt ist, oder zeige nur Events des gewählten Autohauses
                if (!targetAutohausId || targetAutohausId === '' || targetAutohausId === 'null' || cardAutohausId === targetAutohausId) {
                    card.style.display = 'block';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });
            
            // Debug-Information
            console.log('Filtering events for autohaus ID:', targetAutohausId);
            console.log('Found event cards:', eventCards.length);
            console.log('Visible event cards:', visibleCount);
            
            // Prüfe ob Events sichtbar sind
            if (visibleCount === 0) {
                console.log('No events visible for autohaus ID:', targetAutohausId);
                // Zeige eine Meldung wenn keine Events gefunden werden
                showNoEventsMessage(targetAutohausId);
            } else {
                hideNoEventsMessage();
            }
        }
        
        function showNoEventsMessage(autohausId) {
            // Entferne existierende Nachricht
            hideNoEventsMessage();
            
            const eventsGrid = document.querySelector('.events-grid');
            if (eventsGrid) {
                const noEventsDiv = document.createElement('div');
                noEventsDiv.className = 'no-events-message';
                noEventsDiv.innerHTML = `
                    <div class="no-events-icon">
                        <i class="fas fa-calendar-times"></i>
                    </div>
                    <h3>Keine Events verfügbar</h3>
                    <p>Für das ausgewählte Autohaus sind derzeit keine Events geplant.</p>
                    <p>Kontaktieren Sie uns für weitere Informationen.</p>
                `;
                eventsGrid.appendChild(noEventsDiv);
            }
        }
        
        function hideNoEventsMessage() {
            const existingMessage = document.querySelector('.no-events-message');
            if (existingMessage) {
                existingMessage.remove();
            }
        }
        
        function changeAutohaus() {
            // Zurück zur Autohaus-Auswahl
            document.querySelector('.autohaus-selection-section').style.display = 'block';
            document.getElementById('events-section').style.display = 'none';
            
            // Autohaus-Info entfernen
            const autohausInfo = document.querySelector('.selected-autohaus-info');
            if (autohausInfo) {
                autohausInfo.remove();
            }
        }
        
        // Event-Listener für Autohaus-Filter
        document.addEventListener('DOMContentLoaded', function() {
            const filterSelect = document.getElementById('autohaus-filter');
            if (filterSelect) {
                filterSelect.addEventListener('change', function() {
                    filterEventsByAutohaus();
                });
            }
            
            // Hero Slideshow initiieren
            initHeroSlideshow();
        });
        
        function initHeroSlideshow() {
            const slides = document.querySelectorAll('.hero-slideshow .slide');
            if (slides.length === 0) return;
            
            let currentSlide = 0;
            const totalSlides = slides.length;
            let slideshowInterval = null;
            const IMAGE_DISPLAY_DURATION = 5000; // 5 Sekunden für Bilder
            
            // Alle Slides initial ausblenden
            slides.forEach(slide => slide.classList.remove('active'));
            
            // Event-Delegation für Video-Controls (robuster)
            document.addEventListener('click', function(e) {
                // Prüfe ob auf Button oder Icon geklickt wurde
                let playBtn = e.target.closest('.video-play-btn');
                let pauseBtn = e.target.closest('.video-pause-btn');
                
                // Falls auf Icon geklickt wurde, finde den Button
                if (!playBtn && !pauseBtn) {
                    const icon = e.target.closest('i');
                    if (icon) {
                        const parentBtn = icon.closest('.video-play-btn, .video-pause-btn');
                        if (parentBtn) {
                            if (parentBtn.classList.contains('video-play-btn')) {
                                playBtn = parentBtn;
                            } else {
                                pauseBtn = parentBtn;
                            }
                        }
                    }
                }
                
                if (playBtn || pauseBtn) {
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    
                    console.log('Button clicked:', playBtn ? 'play' : 'pause');
                    
                    const slide = (playBtn || pauseBtn).closest('.slide-video');
                    if (!slide) {
                        console.warn('Slide not found');
                        return;
                    }
                    
                    const video = slide.querySelector('.slide-video-element');
                    const poster = slide.querySelector('.video-poster');
                    const playButton = slide.querySelector('.video-play-btn');
                    const pauseButton = slide.querySelector('.video-pause-btn');
                    
                    if (!video) {
                        console.warn('Video not found');
                        return;
                    }
                    
                    if (playBtn) {
                        // Play Button geklickt
                        console.log('Playing video');
                        video.play().then(() => {
                            if (playButton) playButton.style.display = 'none';
                            if (pauseButton) pauseButton.style.display = 'flex';
                            if (poster) {
                                setTimeout(() => {
                                    poster.style.opacity = '0';
                                }, 300);
                            }
                        }).catch(error => {
                            console.warn('Video play failed:', error);
                        });
                    } else if (pauseBtn) {
                        // Pause Button geklickt
                        console.log('Pausing video');
                        video.pause();
                        if (playButton) playButton.style.display = 'flex';
                        if (pauseButton) pauseButton.style.display = 'none';
                        if (poster) {
                            poster.style.opacity = '1';
                        }
                    }
                }
            }, true); // useCapture = true für frühere Event-Erfassung
            
            // Video-Slides initialisieren
            const videoSlides = document.querySelectorAll('.slide-video');
            videoSlides.forEach(slide => {
                const video = slide.querySelector('.slide-video-element');
                const poster = slide.querySelector('.video-poster');
                const playBtn = slide.querySelector('.video-play-btn');
                const pauseBtn = slide.querySelector('.video-pause-btn');
                
                if (video) {
                    // Erstes Frame als Poster extrahieren
                    video.addEventListener('loadedmetadata', function() {
                        extractVideoFrame(video, poster);
                    });
                    
                    // Video geladen - Übergang zum Video
                    video.addEventListener('canplay', function() {
                        if (slide.classList.contains('active')) {
                            setTimeout(() => {
                                if (poster) poster.style.opacity = '0';
                            }, 500);
                        }
                    });
                    
                    // Video startet automatisch - Poster ausblenden
                    video.addEventListener('play', function() {
                        setTimeout(() => {
                            if (poster) poster.style.opacity = '0';
                        }, 300);
                        if (playBtn) playBtn.style.display = 'none';
                        if (pauseBtn) pauseBtn.style.display = 'flex';
                    });
                    
                    // Video pausiert - Poster wieder anzeigen
                    video.addEventListener('pause', function() {
                        if (poster) poster.style.opacity = '1';
                        if (playBtn) playBtn.style.display = 'flex';
                        if (pauseBtn) pauseBtn.style.display = 'none';
                    });
                    
                    // Video Ende - Wechsel zum nächsten Slide
                    video.addEventListener('ended', function() {
                        nextSlide();
                    });
                }
            });
            
            // Erstes Slide anzeigen
            if (slides.length > 0) {
                showSlide(0);
            }
            
            // Automatischer Wechsel für Bilder
            function startSlideshow() {
                if (slideshowInterval) clearInterval(slideshowInterval);
                
                const currentSlideElement = slides[currentSlide];
                
                // Wenn es ein Bild-Slide ist, Timer starten
                if (!currentSlideElement.classList.contains('slide-video')) {
                    slideshowInterval = setInterval(() => {
                        nextSlide();
                    }, IMAGE_DISPLAY_DURATION);
                }
                // Bei Video-Slides wird der Timer durch das 'ended' Event gesteuert
            }
            
            function nextSlide() {
                // Aktuelles Video stoppen wenn es ein Video-Slide ist
                const currentSlideElement = slides[currentSlide];
                if (currentSlideElement.classList.contains('slide-video')) {
                    const video = currentSlideElement.querySelector('.slide-video-element');
                    const playBtn = currentSlideElement.querySelector('.video-play-btn');
                    const pauseBtn = currentSlideElement.querySelector('.video-pause-btn');
                    if (video) {
                        video.pause();
                        video.currentTime = 0;
                        pauseVideo(video, playBtn, pauseBtn);
                    }
                }
                
                slides[currentSlide].classList.remove('active');
                currentSlide = (currentSlide + 1) % totalSlides;
                showSlide(currentSlide);
            }
            
            function showSlide(index) {
                const slide = slides[index];
                slide.classList.add('active');
                
                // Wenn es ein Video-Slide ist
                if (slide.classList.contains('slide-video')) {
                    const video = slide.querySelector('.slide-video-element');
                    const poster = slide.querySelector('.video-poster');
                    
                    if (video && poster) {
                        // Poster anzeigen
                        poster.style.opacity = '1';
                        
                        // Video automatisch starten
                        video.currentTime = 0;
                        video.play().then(() => {
                            // Video startet erfolgreich
                            setTimeout(() => {
                                poster.style.opacity = '0';
                            }, 500);
                        }).catch(error => {
                            console.warn('Autoplay failed:', error);
                            // Bei Autoplay-Fehler Play-Button anzeigen
                            const playBtn = slide.querySelector('.video-play-btn');
                            const pauseBtn = slide.querySelector('.video-pause-btn');
                            if (playBtn) playBtn.style.display = 'flex';
                            if (pauseBtn) pauseBtn.style.display = 'none';
                        });
                    }
                    
                    // Kein Timer für Videos - warte auf 'ended' Event
                    if (slideshowInterval) {
                        clearInterval(slideshowInterval);
                        slideshowInterval = null;
                    }
                } else {
                    // Bild-Slide - Timer starten
                    startSlideshow();
                }
            }
            
            startSlideshow();
        }
        
        // Video Frame extrahieren
        function extractVideoFrame(video, posterElement) {
            try {
                // Warte bis Video-Metadaten geladen sind
                if (video.readyState >= 1) {
                    extractFrame();
                } else {
                    video.addEventListener('loadedmetadata', extractFrame, { once: true });
                }
                
                function extractFrame() {
                    const canvas = document.createElement('canvas');
                    canvas.width = video.videoWidth || 1920;
                    canvas.height = video.videoHeight || 1080;
                    const ctx = canvas.getContext('2d');
                    
                    // Video auf Frame 0 setzen
                    const originalTime = video.currentTime;
                    video.currentTime = 0.1; // Kleine Verzögerung für besseres Frame
                    
                    video.addEventListener('seeked', function onSeeked() {
                        try {
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                            const dataURL = canvas.toDataURL('image/jpeg', 0.9);
                            posterElement.style.backgroundImage = `url(${dataURL})`;
                            posterElement.style.backgroundSize = 'cover';
                            posterElement.style.backgroundPosition = 'center';
                            video.currentTime = originalTime;
                        } catch (error) {
                            console.warn('Frame extraction error:', error);
                            posterElement.style.background = '#000';
                        }
                        video.removeEventListener('seeked', onSeeked);
                    }, { once: true });
                }
            } catch (error) {
                console.warn('Frame extraction failed:', error);
                // Fallback: Dunkler Hintergrund
                posterElement.style.background = '#000';
            }
        }
        
        // Video abspielen
        function playVideo(video, playBtn, pauseBtn, slide) {
            if (video) {
                video.play().then(() => {
                    if (playBtn) playBtn.style.display = 'none';
                    if (pauseBtn) pauseBtn.style.display = 'flex';
                    
                    // Poster ausblenden
                    const poster = slide.querySelector('.video-poster');
                    if (poster) {
                        setTimeout(() => {
                            poster.style.opacity = '0';
                        }, 300);
                    }
                }).catch(error => {
                    console.warn('Video play failed:', error);
                });
            }
        }
        
        // Video pausieren
        function pauseVideo(video, playBtn, pauseBtn) {
            if (video) {
                video.pause();
                if (playBtn) playBtn.style.display = 'flex';
                if (pauseBtn) pauseBtn.style.display = 'none';
                
                // Poster wieder anzeigen
                const slide = video.closest('.slide-video');
                if (slide) {
                    const poster = slide.querySelector('.video-poster');
                    if (poster) {
                        poster.style.opacity = '1';
                    }
                }
            }
        }
    </script>
    
    <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
        <?php include 'includes/feedback_form.php'; ?>
    <?php endif; ?>
    
    <!-- WhatsApp Widget (hellomateo) -->
    <div data-widget-host="mateo">
        <script type="text/props">
            { "web_widget_id": "c075bb95-f054-4583-85fa-9f1f5fb6d18d" }
        </script>
        <script 
            async 
            src="https://uagvwyhbnlutltxparir.supabase.in/storage/v1/object/public/contact_widget/contact-widget.js" 
            type="text/javascript" 
            crossorigin="anonymous" 
            charset="UTF-8"
        >
        </script>
    </div>
    
    <!-- PWA Service Worker Registration -->
    <script>
        // Service Worker registrieren
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/service-worker.js')
                    .then((registration) => {
                        console.log('[Service Worker] Registriert:', registration.scope);
                        
                        // Prüfe auf Updates
                        registration.addEventListener('updatefound', () => {
                            const newWorker = registration.installing;
                            newWorker.addEventListener('statechange', () => {
                                if (newWorker.state === 'installed' && navigator.serviceWorker.controller) {
                                    // Neuer Service Worker verfügbar
                                    console.log('[Service Worker] Neuer Service Worker verfügbar');
                                    // Optional: Benutzer benachrichtigen
                                }
                            });
                        });
                    })
                    .catch((error) => {
                        console.error('[Service Worker] Registrierung fehlgeschlagen:', error);
                    });
            });
        }
    </script>
    
    <!-- PWA Install Prompt -->
    <script src="assets/js/pwa-install.js?v=<?php echo filemtime(__DIR__ . '/assets/js/pwa-install.js'); ?>"></script>
    
    <!-- Push Notifications (für Push-Angebot nach Installation) -->
    <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
    <script src="assets/js/push-notifications.js"></script>
    <?php endif; ?>
</body>
</html>
