// Generiert VAPID Keys für Push-Benachrichtigungen
// Verwendet web-push npm package

const webpush = require('web-push');

try {
    console.log('=== GENERIERE VAPID KEYS ===\n');
    
    const vapidKeys = webpush.generateVAPIDKeys();
    
    console.log('✅ Keys erfolgreich generiert!\n');
    console.log('=== VAPID KEYS ===\n');
    console.log('Public Key:');
    console.log(vapidKeys.publicKey);
    console.log('\nPrivate Key:');
    console.log(vapidKeys.privateKey);
    console.log('\n=== SQL BEFEHL ZUM SPEICHERN ===\n');
    console.log('Führe diesen SQL-Befehl in deiner Datenbank aus:\n');
    console.log(`INSERT INTO settings (setting_key, setting_value) VALUES`);
    console.log(`('vapid_public_key', '${vapidKeys.publicKey}'),`);
    console.log(`('vapid_private_key', '${vapidKeys.privateKey}')`);
    console.log(`ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value);\n`);
    
    // Speichere auch in Datei
    const fs = require('fs');
    fs.writeFileSync('vapid_keys.txt', 
        `Public Key: ${vapidKeys.publicKey}\n` +
        `Private Key: ${vapidKeys.privateKey}\n`
    );
    console.log('✅ Keys auch in \'vapid_keys.txt\' gespeichert\n');
    
} catch (error) {
    console.error('❌ Fehler:', error.message);
    console.error('\nVersuche web-push zu installieren:');
    console.error('npm install web-push');
    process.exit(1);
}

