<?php
/**
 * UMFASSENDE SUCHE nach "PRT17" - Alles was damit zu tun haben könnte:
 * - Drucker
 * - Treiber
 * - Ports
 * - Freigaben
 * - Warteschlangen
 * - Virtuelle Drucker
 * - Registry-Einträge
 * - Dateien/Ordner
 * - Netzwerk-Freigaben
 */

echo "=== UMFASSENDE SUCHE NACH 'PRT17' ===\n";
echo "Suche nach: Druckern, Treibern, Ports, Freigaben, Warteschlangen, etc.\n\n";

$found_anything = false;

// ============================================
// 1. DRUCKER (alle Varianten)
// ============================================
echo "1. DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,driverName,portName,shared,network,status /format:list', $printers);
$current = [];
foreach ($printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            if (stripos($name, 'PRT17') !== false || 
                stripos($current['driver'] ?? '', 'PRT17') !== false ||
                stripos($current['port'] ?? '', 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Drucker: $name\n";
                echo "   Treiber: " . ($current['driver'] ?? 'N/A') . "\n";
                echo "   Port: " . ($current['port'] ?? 'N/A') . "\n";
                echo "   Shared: " . ($current['shared'] ?? 'N/A') . "\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'driverName=') === 0) $current['driver'] = substr($line, 11);
    elseif (strpos($line, 'portName=') === 0) $current['port'] = substr($line, 9);
    elseif (strpos($line, 'Shared=') === 0) $current['shared'] = substr($line, 7);
    elseif (strpos($line, 'Network=') === 0) $current['network'] = substr($line, 8);
    elseif (strpos($line, 'Status=') === 0) $current['status'] = substr($line, 7);
}

// ============================================
// 2. DRUCKERTREIBER
// ============================================
echo "\n2. DRUCKERTREIBER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printerdriver get name,driverpath,version /format:list', $drivers);
$current = [];
foreach ($drivers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $path = $current['path'] ?? '';
            if (stripos($name, 'PRT17') !== false || stripos($path, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Treiber: $name\n";
                echo "   Pfad: " . ($path ?? 'N/A') . "\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'DriverPath=') === 0) $current['path'] = substr($line, 12);
    elseif (strpos($line, 'Version=') === 0) $current['version'] = substr($line, 9);
}

// ============================================
// 3. DRUCKERPORTS
// ============================================
echo "\n3. DRUCKERPORTS:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printerport get name,description /format:list', $ports);
$current = [];
foreach ($ports as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            if (stripos($name, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Port: $name\n";
                echo "   Beschreibung: " . ($current['desc'] ?? 'N/A') . "\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'Description=') === 0) $current['desc'] = substr($line, 12);
}

// ============================================
// 4. DRUCKERFREIGABEN (Shared Printers)
// ============================================
echo "\n4. DRUCKERFREIGABEN:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer where "shared=true" get name,sharename /format:list', $shared);
$current = [];
foreach ($shared as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $share = $current['share'] ?? '';
            if (stripos($name, 'PRT17') !== false || stripos($share, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Freigabe: $share (Drucker: $name)\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
}

// ============================================
// 5. DRUCKERWARTESCHLANGEN (Print Queues)
// ============================================
echo "\n5. DRUCKERWARTESCHLANGEN:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printjob get name,printername,status /format:list', $queues);
$current = [];
foreach ($queues as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $printer = $current['printer'] ?? '';
            if (stripos($name, 'PRT17') !== false || stripos($printer, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Warteschlange: $name (Drucker: $printer)\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'PrinterName=') === 0) $current['printer'] = substr($line, 13);
    elseif (strpos($line, 'Status=') === 0) $current['status'] = substr($line, 7);
}

// ============================================
// 6. REGISTRY - Alle Drucker-bezogenen Einträge
// ============================================
echo "\n6. REGISTRY (Drucker-Einträge):\n";
echo str_repeat("-", 50) . "\n";

$registry_paths = [
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Printers',
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Monitors',
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Environments',
    'HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print',
];

foreach ($registry_paths as $path) {
    exec("reg query \"$path\" /s 2>nul", $reg_output);
    foreach ($reg_output as $line) {
        if (stripos($line, 'PRT17') !== false) {
            echo "✅ GEFUNDEN - Registry: $line\n";
            $found_anything = true;
        }
    }
}

// ============================================
// 7. DATEIEN UND ORDNER mit PRT17
// ============================================
echo "\n7. DATEIEN/ORDNER mit 'PRT17':\n";
echo str_repeat("-", 50) . "\n";

$search_paths = [
    'C:\\Windows\\System32\\spool\\drivers',
    'C:\\Windows\\System32\\spool\\PRINTERS',
    'C:\\Windows\\System32\\DriverStore',
    'C:\\Program Files',
    'C:\\Program Files (x86)',
];

foreach ($search_paths as $path) {
    if (is_dir($path)) {
        exec("dir /s /b \"$path\" 2>nul | findstr /i \"PRT17\"", $files);
        foreach ($files as $file) {
            echo "✅ GEFUNDEN - Datei/Ordner: $file\n";
            $found_anything = true;
        }
    }
}

// ============================================
// 8. NETZWERK-FREIGABEN
// ============================================
echo "\n8. NETZWERK-FREIGABEN:\n";
echo str_repeat("-", 50) . "\n";

exec('net share', $shares);
foreach ($shares as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Freigabe: $line\n";
        $found_anything = true;
    }
}

// ============================================
// 9. DRUCKER-INSTALLATIONEN (Setup Information)
// ============================================
echo "\n9. DRUCKER-INSTALLATIONEN:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printerconfig get name,printername /format:list', $configs);
$current = [];
foreach ($configs as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $printer = $current['printer'] ?? '';
            if (stripos($name, 'PRT17') !== false || stripos($printer, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Konfiguration: $name (Drucker: $printer)\n";
                $found_anything = true;
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    elseif (strpos($line, 'PrinterName=') === 0) $current['printer'] = substr($line, 13);
}

// ============================================
// 10. ALLE WMI-DRUCKER-OBJEKTE
// ============================================
echo "\n10. ALLE WMI-DRUCKER-OBJEKTE:\n";
echo str_repeat("-", 50) . "\n";

$wmi_classes = [
    'printer',
    'printerdriver',
    'printerport',
    'printerconfig',
    'printjob',
];

foreach ($wmi_classes as $class) {
    exec("wmic $class get /format:list 2>nul", $wmi_output);
    foreach ($wmi_output as $line) {
        if (stripos($line, 'PRT17') !== false) {
            echo "✅ GEFUNDEN - WMI $class: $line\n";
            $found_anything = true;
        }
    }
}

// ============================================
// 11. DRUCKER-SERVICES
// ============================================
echo "\n11. DRUCKER-SERVICES:\n";
echo str_repeat("-", 50) . "\n";

exec('sc query type= service | findstr /i "PRT17"', $services);
foreach ($services as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Service: $line\n";
        $found_anything = true;
    }
}

// ============================================
// 12. PROZESSE mit PRT17
// ============================================
echo "\n12. PROZESSE:\n";
echo str_repeat("-", 50) . "\n";

exec('tasklist | findstr /i "PRT17"', $processes);
foreach ($processes as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Prozess: $line\n";
        $found_anything = true;
    }
}

// ============================================
// ZUSAMMENFASSUNG
// ============================================
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if ($found_anything) {
    echo "✅ ES WURDEN EINTRÄGE MIT 'PRT17' GEFUNDEN!\n";
    echo "\nDie oben aufgeführten Einträge können verwendet werden.\n";
} else {
    echo "❌ KEINE EINTRÄGE MIT 'PRT17' GEFUNDEN\n\n";
    echo "Mögliche nächste Schritte:\n";
    echo "1. Prüfen Sie, ob 'PRT17' ein Netzwerkdrucker ist:\n";
    echo "   - Versuchen Sie: \\\\SERVERNAME\\PRT17\n";
    echo "   - Oder: \\\\IP-ADRESSE\\PRT17\n";
    echo "\n";
    echo "2. Prüfen Sie alternative Namen:\n";
    echo "   - PRT-17, PRT_17, Printer17, etc.\n";
    echo "\n";
    echo "3. Installieren Sie den Drucker/Treiber:\n";
    echo "   - Systemsteuerung > Geräte und Drucker > Drucker hinzufügen\n";
    echo "\n";
    echo "4. Prüfen Sie Druckerserver oder Netzwerk-Freigaben\n";
}

echo "\n";
echo "💡 TIPP: Wenn 'PRT17' ein Netzwerkdrucker ist, können Sie ihn\n";
echo "   als UNC-Pfad verwenden: \\\\SERVER\\PRT17\n";
echo "   Oder als IP: \\\\192.168.1.100\\PRT17\n";

?>

