<?php
/**
 * Sucht nach einem Drucker mit "PRT17" im Namen
 */

echo "=== Suche nach Drucker mit 'PRT17' im Namen ===\n\n";

$found_printers = [];

// Methode 1: WMI - Alle Drucker auflisten
echo "Methode 1: WMI (Windows Management Instrumentation)\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,driverName,portName /format:list', $output);

$current_printer = [];
foreach ($output as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current_printer)) {
            if (isset($current_printer['name']) && stripos($current_printer['name'], 'PRT17') !== false) {
                $found_printers[] = $current_printer;
            }
            $current_printer = [];
        }
        continue;
    }
    
    if (strpos($line, 'Name=') === 0) {
        $current_printer['name'] = substr($line, 5);
    } elseif (strpos($line, 'driverName=') === 0) {
        $current_printer['driver'] = substr($line, 11);
    } elseif (strpos($line, 'portName=') === 0) {
        $current_printer['port'] = substr($line, 9);
    }
}

if (!empty($current_printer) && isset($current_printer['name']) && stripos($current_printer['name'], 'PRT17') !== false) {
    $found_printers[] = $current_printer;
}

// Methode 2: PowerShell - Alle Drucker auflisten
echo "\nMethode 2: PowerShell\n";
echo str_repeat("-", 50) . "\n";

exec('powershell -Command "Get-Printer | Format-List Name, DriverName, PortName"', $ps_output);

foreach ($ps_output as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo $line . "\n";
    }
}

// Methode 3: Registry durchsuchen
echo "\nMethode 3: Registry\n";
echo str_repeat("-", 50) . "\n";

exec('reg query "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print\Printers" /s', $reg_output);

foreach ($reg_output as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo $line . "\n";
    }
}

// Methode 4: Alle Drucker auflisten und durchsuchen
echo "\nMethode 4: Alle Drucker auflisten\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name', $all_printers);

echo "Alle verfügbaren Drucker:\n";
foreach ($all_printers as $printer) {
    $printer = trim($printer);
    if (!empty($printer) && $printer !== 'Name') {
        $highlight = stripos($printer, 'PRT17') !== false ? ' ⭐ GEFUNDEN!' : '';
        echo "  - $printer$highlight\n";
    }
}

// Ergebnis
echo "\n" . str_repeat("=", 50) . "\n";
echo "ERGEBNIS:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found_printers)) {
    echo "✅ DRUCKER MIT 'PRT17' GEFUNDEN:\n\n";
    foreach ($found_printers as $idx => $printer) {
        echo "Drucker " . ($idx + 1) . ":\n";
        echo "  Name: " . ($printer['name'] ?? 'N/A') . "\n";
        echo "  Treiber: " . ($printer['driver'] ?? 'N/A') . "\n";
        echo "  Port: " . ($printer['port'] ?? 'N/A') . "\n";
        echo "\n";
    }
    
    // Beispiel-Konfiguration
    $printer_name = $found_printers[0]['name'];
    echo "💡 Verwendung in print_etikett_example.php:\n";
    echo str_repeat("-", 50) . "\n";
    echo "define('PRINTER_NAME', '$printer_name');\n";
} else {
    echo "❌ KEIN DRUCKER MIT 'PRT17' IM NAMEN GEFUNDEN\n\n";
    echo "Mögliche Gründe:\n";
    echo "  - Der Drucker ist nicht installiert\n";
    echo "  - Der Drucker hat einen anderen Namen\n";
    echo "  - Der Drucker ist auf einem anderen Computer/Server\n";
    echo "  - Der Drucker ist als Netzwerkdrucker nicht erreichbar\n";
    echo "\n";
    echo "💡 Tipp: Prüfen Sie:\n";
    echo "  - Systemsteuerung > Geräte und Drucker\n";
    echo "  - Netzwerkdrucker-Einstellungen\n";
    echo "  - Druckerserver-Konfiguration\n";
}

// Zusätzlich: Suche nach ähnlichen Namen
echo "\n" . str_repeat("=", 50) . "\n";
echo "Ähnliche Druckernamen (mit 'PRT' oder '17'):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name', $similar_printers);
$similar_found = false;
foreach ($similar_printers as $printer) {
    $printer = trim($printer);
    if (!empty($printer) && $printer !== 'Name') {
        if (stripos($printer, 'PRT') !== false || stripos($printer, '17') !== false) {
            echo "  - $printer\n";
            $similar_found = true;
        }
    }
}

if (!$similar_found) {
    echo "  (Keine ähnlichen Namen gefunden)\n";
}

?>

